/*
 * Decompiled with CFR 0.152.
 */
package com.cwg.mod.command;

import com.cobblemon.mod.common.command.argument.SpeciesArgumentType;
import com.cobblemon.mod.common.pokemon.Species;
import com.cwg.mod.CobblemonWikiGui;
import com.cwg.mod.api.permission.CobblemonWikiGuiPermissions;
import com.cwg.mod.config.CobblemonWikiGuiConfig;
import com.cwg.mod.gui.PokeWikiGui;
import com.cwg.mod.util.CommandContextExtensionsKt;
import com.cwg.mod.util.CommandUtilKt;
import com.cwg.mod.util.PermissionUtilKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\u000f\u001a\u00020\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00148\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u00148\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0016R\u001d\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001d\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001c\u001a\u0004\b \u0010\u001e\u00a8\u0006!"}, d2={"Lcom/cwg/mod/command/PokeWikiCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/server/level/ServerPlayer;)I", "Lcom/cwg/mod/config/CobblemonWikiGuiConfig;", "config", "Lcom/cwg/mod/config/CobblemonWikiGuiConfig;", "", "NAME", "Ljava/lang/String;", "PLAYER", "SPECIES", "NAME_OTHER", "", "ALIASES", "Ljava/util/List;", "getALIASES", "()Ljava/util/List;", "ALIASES_OTHER", "getALIASES_OTHER", "common"})
@SourceDebugExtension(value={"SMAP\nPokeWikiCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokeWikiCommand.kt\ncom/cwg/mod/command/PokeWikiCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1557#2:80\n1628#2,3:81\n*S KotlinDebug\n*F\n+ 1 PokeWikiCommand.kt\ncom/cwg/mod/command/PokeWikiCommand\n*L\n29#1:80\n29#1:81,3\n*E\n"})
public final class PokeWikiCommand {
    @NotNull
    public static final PokeWikiCommand INSTANCE;
    @NotNull
    private static final CobblemonWikiGuiConfig config;
    @NotNull
    private static final String NAME = "pwiki";
    @NotNull
    private static final String PLAYER = "player";
    @NotNull
    private static final String SPECIES = "species";
    @NotNull
    private static final String NAME_OTHER = "pwikiother";
    @NotNull
    private static final List<String> ALIASES;
    @NotNull
    private static final List<String> ALIASES_OTHER;

    private PokeWikiCommand() {
    }

    @NotNull
    public final List<String> getALIASES() {
        return ALIASES;
    }

    @NotNull
    public final List<String> getALIASES_OTHER() {
        return ALIASES_OTHER;
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder selfCommandBuilder = (LiteralArgumentBuilder)Commands.literal((String)NAME).then(Commands.argument((String)SPECIES, (ArgumentType)((ArgumentType)SpeciesArgumentType.Companion.species())).executes(PokeWikiCommand::register$lambda$1));
        if (config.isEnablePermissions()) {
            Intrinsics.checkNotNull((Object)selfCommandBuilder);
            PermissionUtilKt.permission$default((ArgumentBuilder)selfCommandBuilder, CobblemonWikiGuiPermissions.getPWIKI(), false, 2, null);
        }
        LiteralCommandNode selfCommand = dispatcher.register(selfCommandBuilder);
        for (String alias : ALIASES) {
            Intrinsics.checkNotNull((Object)selfCommand);
            dispatcher.register(CommandUtilKt.alias(selfCommand, alias));
        }
        LiteralArgumentBuilder otherCommandBuilder = (LiteralArgumentBuilder)Commands.literal((String)NAME_OTHER).then(Commands.argument((String)SPECIES, (ArgumentType)((ArgumentType)SpeciesArgumentType.Companion.species())).then(Commands.argument((String)PLAYER, (ArgumentType)((ArgumentType)EntityArgument.player())).executes(PokeWikiCommand::register$lambda$2)));
        if (config.isEnablePermissions()) {
            Intrinsics.checkNotNull((Object)otherCommandBuilder);
            PermissionUtilKt.permission$default((ArgumentBuilder)otherCommandBuilder, CobblemonWikiGuiPermissions.getPWIKIANOTHER(), false, 2, null);
        }
        LiteralCommandNode otherCommand = dispatcher.register(otherCommandBuilder);
        for (String alias : ALIASES_OTHER) {
            Intrinsics.checkNotNull((Object)otherCommand);
            dispatcher.register(CommandUtilKt.alias(otherCommand, alias));
        }
    }

    public final int execute(@NotNull CommandContext<CommandSourceStack> context, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)player, (String)PLAYER);
        try {
            Species pokemonSpecies = SpeciesArgumentType.Companion.getPokemon(context, SPECIES);
            if (!((CommandSourceStack)context.getSource()).isPlayer()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Command without target player cannot be executed by console"));
                return 0;
            }
            PokeWikiGui.INSTANCE.open(pokemonSpecies, player);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"An internal error occurred. Check logs for details."));
            return 0;
        }
    }

    private static final int register$lambda$1(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        ServerPlayer serverPlayer = ((CommandSourceStack)it.getSource()).getPlayerOrException();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayerOrException(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, serverPlayer);
    }

    private static final int register$lambda$2(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        ServerPlayer serverPlayer = CommandContextExtensionsKt.player$default(it, null, 1, null);
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"player$default(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, serverPlayer);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        INSTANCE = new PokeWikiCommand();
        config = CobblemonWikiGui.INSTANCE.getConfig();
        Object[] objectArray = new String[]{"pokewiki", "pokemonwiki", "cobblemonwiki", "cobblewiki", "cwiki"};
        ALIASES = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$map$iv = ALIASES;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it + "other");
        }
        ALIASES_OTHER = (List)var3_3;
    }
}

