/*
 * Decompiled with CFR 0.152.
 */
package com.cwg.mod.util;

import com.cobblemon.mod.common.api.conditional.RegistryLikeCondition;
import com.cobblemon.mod.common.api.spawning.condition.SpawningCondition;
import com.cwg.mod.util.CobblemonBiome;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\f\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/cwg/mod/util/BiomeUtils;", "", "<init>", "()V", "Lnet/minecraft/world/level/Level;", "world", "", "Lcom/cwg/mod/util/CobblemonBiome;", "getAllBiomes", "(Lnet/minecraft/world/level/Level;)Ljava/util/List;", "Lnet/minecraft/world/level/biome/Biome;", "biome", "Lcom/cobblemon/mod/common/api/spawning/condition/SpawningCondition;", "condition", "", "canSpawnAt", "(Lnet/minecraft/world/level/biome/Biome;Lnet/minecraft/world/level/Level;Lcom/cobblemon/mod/common/api/spawning/condition/SpawningCondition;)Z", "common"})
@SourceDebugExtension(value={"SMAP\nBiomeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BiomeUtil.kt\ncom/cwg/mod/util/BiomeUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1557#2:48\n1628#2,3:49\n1782#2,4:52\n*S KotlinDebug\n*F\n+ 1 BiomeUtil.kt\ncom/cwg/mod/util/BiomeUtils\n*L\n21#1:48\n21#1:49,3\n38#1:52,4\n*E\n"})
public final class BiomeUtils {
    @NotNull
    public static final BiomeUtils INSTANCE = new BiomeUtils();

    private BiomeUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CobblemonBiome> getAllBiomes(@NotNull Level world) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Registry registry = world.registryAccess().registryOrThrow(Registries.BIOME);
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"registryOrThrow(...)");
        Registry registry2 = registry;
        Set set = registry2.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ResourceLocation resourceLocation = ((ResourceKey)entry.getKey()).location();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            collection.add(new CobblemonBiome(resourceLocation, (Biome)v));
        }
        return (List)destination$iv$iv;
    }

    public final boolean canSpawnAt(@NotNull Biome biome, @NotNull Level world, @NotNull SpawningCondition<?> condition) {
        int n;
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Registry registry = world.registryAccess().registryOrThrow(Registries.BIOME);
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"registryOrThrow(...)");
        Registry registry2 = registry;
        if (condition.getBiomes() == null) {
            return false;
        }
        Set set = condition.getBiomes();
        Intrinsics.checkNotNull((Object)set);
        Iterable $this$count$iv = set;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                RegistryLikeCondition biomeCondition = (RegistryLikeCondition)element$iv;
                boolean bl = false;
                if (!biomeCondition.fits((Object)biome, registry2) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int count = n;
        return count > 0;
    }
}

