/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui;

import io.github.cottonmc.cotton.gui.EmptyInventory;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.PropertyDelegateHolder;
import io.github.cottonmc.cotton.gui.ValidatedSlot;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.client.LibGui;
import io.github.cottonmc.cotton.gui.networking.NetworkSide;
import io.github.cottonmc.cotton.gui.widget.WGridPanel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WPlayerInvPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import io.github.cottonmc.cotton.gui.widget.data.Vec2i;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SyncedGuiDescription
extends AbstractContainerMenu
implements GuiDescription {
    protected Container blockInventory;
    protected Inventory playerInventory;
    protected Level world;
    protected ContainerData propertyDelegate;
    protected WPanel rootPanel = new WGridPanel().setInsets(Insets.ROOT_PANEL);
    protected int titleColor = 0x404040;
    protected int darkTitleColor = 0xBCBCBC;
    protected boolean fullscreen = false;
    protected boolean titleVisible = true;
    protected HorizontalAlignment titleAlignment = HorizontalAlignment.LEFT;
    protected WWidget focus;
    private Vec2i titlePos = new Vec2i(8, 6);

    public SyncedGuiDescription(MenuType<?> type, int syncId, Inventory playerInventory) {
        super(type, syncId);
        this.blockInventory = null;
        this.playerInventory = playerInventory;
        this.world = playerInventory.player.level();
        this.propertyDelegate = null;
    }

    public SyncedGuiDescription(MenuType<?> type, int syncId, Inventory playerInventory, @Nullable Container blockInventory, @Nullable ContainerData propertyDelegate) {
        super(type, syncId);
        this.blockInventory = blockInventory;
        this.playerInventory = playerInventory;
        this.world = playerInventory.player.level();
        this.propertyDelegate = propertyDelegate;
        if (propertyDelegate != null && propertyDelegate.getCount() > 0) {
            this.addDataSlots(propertyDelegate);
        }
        if (blockInventory != null) {
            blockInventory.startOpen(playerInventory.player);
        }
    }

    @Override
    public WPanel getRootPanel() {
        return this.rootPanel;
    }

    @Override
    public int getTitleColor() {
        return this.world.isClientSide && this.isDarkMode().orElse(LibGui.isDarkMode()) ? this.darkTitleColor : this.titleColor;
    }

    @Override
    public SyncedGuiDescription setRootPanel(WPanel panel) {
        this.rootPanel = panel;
        return this;
    }

    @Override
    public SyncedGuiDescription setTitleColor(int color) {
        this.titleColor = color;
        this.darkTitleColor = color == 0x404040 ? 0xBCBCBC : color;
        return this;
    }

    @Override
    public SyncedGuiDescription setTitleColor(int lightColor, int darkColor) {
        this.titleColor = lightColor;
        this.darkTitleColor = darkColor;
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addPainters() {
        if (this.rootPanel != null && !this.fullscreen) {
            this.rootPanel.setBackgroundPainter(BackgroundPainter.VANILLA);
        }
    }

    @Override
    public void addSlotPeer(ValidatedSlot slot) {
        this.addSlot(slot);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack result = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            result = slotStack.copy();
            if (this.blockInventory != null ? (slot.container == this.blockInventory ? !this.insertItem(slotStack, (Container)this.playerInventory, true, player) : !this.insertItem(slotStack, this.blockInventory, false, player)) : !this.swapHotbar(slotStack, index, (Container)this.playerInventory, player)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return result;
    }

    private boolean insertIntoExisting(ItemStack toInsert, Slot slot, Player player) {
        ItemStack curSlotStack = slot.getItem();
        if (!curSlotStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)toInsert, (ItemStack)curSlotStack) && slot.mayPlace(toInsert)) {
            int maxAmount;
            int combinedAmount = curSlotStack.getCount() + toInsert.getCount();
            if (combinedAmount <= (maxAmount = Math.min(toInsert.getMaxStackSize(), slot.getMaxStackSize(toInsert)))) {
                toInsert.setCount(0);
                curSlotStack.setCount(combinedAmount);
                slot.setChanged();
                return true;
            }
            if (curSlotStack.getCount() < maxAmount) {
                toInsert.shrink(maxAmount - curSlotStack.getCount());
                curSlotStack.setCount(maxAmount);
                slot.setChanged();
                return true;
            }
        }
        return false;
    }

    private boolean insertIntoEmpty(ItemStack toInsert, Slot slot) {
        ItemStack curSlotStack = slot.getItem();
        if (curSlotStack.isEmpty() && slot.mayPlace(toInsert)) {
            if (toInsert.getCount() > slot.getMaxStackSize(toInsert)) {
                slot.setByPlayer(toInsert.split(slot.getMaxStackSize(toInsert)));
            } else {
                slot.setByPlayer(toInsert.split(toInsert.getCount()));
            }
            slot.setChanged();
            return true;
        }
        return false;
    }

    private boolean insertItem(ItemStack toInsert, Container inventory, boolean walkBackwards, Player player) {
        boolean inserted;
        block19: {
            Slot curSlot;
            int i;
            ArrayList<Slot> inventorySlots = new ArrayList<Slot>();
            for (Slot slot : this.slots) {
                if (slot.container != inventory) continue;
                inventorySlots.add(slot);
            }
            if (inventorySlots.isEmpty()) {
                return false;
            }
            inserted = false;
            if (walkBackwards) {
                for (i = inventorySlots.size() - 1; i >= 0; --i) {
                    curSlot = (Slot)inventorySlots.get(i);
                    if (this.insertIntoExisting(toInsert, curSlot, player)) {
                        inserted = true;
                    }
                    if (!toInsert.isEmpty()) {
                        continue;
                    }
                    break;
                }
            } else {
                for (i = 0; i < inventorySlots.size(); ++i) {
                    curSlot = (Slot)inventorySlots.get(i);
                    if (this.insertIntoExisting(toInsert, curSlot, player)) {
                        inserted = true;
                    }
                    if (!toInsert.isEmpty()) {
                        continue;
                    }
                    break;
                }
            }
            if (toInsert.isEmpty()) break block19;
            if (walkBackwards) {
                for (i = inventorySlots.size() - 1; i >= 0; --i) {
                    curSlot = (Slot)inventorySlots.get(i);
                    if (this.insertIntoEmpty(toInsert, curSlot)) {
                        inserted = true;
                    }
                    if (!toInsert.isEmpty()) {
                        continue;
                    }
                    break;
                }
            } else {
                for (i = 0; i < inventorySlots.size(); ++i) {
                    curSlot = (Slot)inventorySlots.get(i);
                    if (this.insertIntoEmpty(toInsert, curSlot)) {
                        inserted = true;
                    }
                    if (!toInsert.isEmpty()) {
                        continue;
                    }
                    break;
                }
            }
        }
        return inserted;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean swapHotbar(ItemStack toInsert, int slotNumber, Container inventory, Player player) {
        ArrayList<Slot> storageSlots = new ArrayList<Slot>();
        ArrayList<Slot> hotbarSlots = new ArrayList<Slot>();
        boolean swapToStorage = true;
        boolean inserted = false;
        for (Slot slot : this.slots) {
            if (slot.container != inventory || !(slot instanceof ValidatedSlot)) continue;
            ValidatedSlot validated = (ValidatedSlot)slot;
            int index = validated.getInventoryIndex();
            if (Inventory.isHotbarSlot((int)index)) {
                hotbarSlots.add(slot);
                continue;
            }
            storageSlots.add(slot);
            if (slot.index != slotNumber) continue;
            swapToStorage = false;
        }
        if (storageSlots.isEmpty() || hotbarSlots.isEmpty()) {
            return false;
        }
        if (swapToStorage) {
            int i;
            for (i = 0; i < storageSlots.size(); ++i) {
                curSlot = (Slot)storageSlots.get(i);
                if (this.insertIntoExisting(toInsert, curSlot, player)) {
                    inserted = true;
                }
                if (toInsert.isEmpty()) break;
            }
            if (toInsert.isEmpty()) return inserted;
            for (i = 0; i < storageSlots.size(); ++i) {
                curSlot = (Slot)storageSlots.get(i);
                if (this.insertIntoEmpty(toInsert, curSlot)) {
                    inserted = true;
                }
                if (toInsert.isEmpty()) return inserted;
            }
            return inserted;
        } else {
            int i;
            for (i = 0; i < hotbarSlots.size(); ++i) {
                curSlot = (Slot)hotbarSlots.get(i);
                if (this.insertIntoExisting(toInsert, curSlot, player)) {
                    inserted = true;
                }
                if (toInsert.isEmpty()) break;
            }
            if (toInsert.isEmpty()) return inserted;
            for (i = 0; i < hotbarSlots.size(); ++i) {
                curSlot = (Slot)hotbarSlots.get(i);
                if (this.insertIntoEmpty(toInsert, curSlot)) {
                    inserted = true;
                }
                if (toInsert.isEmpty()) return inserted;
            }
        }
        return inserted;
    }

    @Override
    @Nullable
    public ContainerData getPropertyDelegate() {
        return this.propertyDelegate;
    }

    @Override
    public GuiDescription setPropertyDelegate(ContainerData delegate) {
        this.propertyDelegate = delegate;
        return this;
    }

    public WPlayerInvPanel createPlayerInventoryPanel() {
        return new WPlayerInvPanel(this.playerInventory);
    }

    public WPlayerInvPanel createPlayerInventoryPanel(boolean hasLabel) {
        return new WPlayerInvPanel(this.playerInventory, hasLabel);
    }

    public WPlayerInvPanel createPlayerInventoryPanel(WWidget label) {
        return new WPlayerInvPanel(this.playerInventory, label);
    }

    public static Container getBlockInventory(ContainerLevelAccess ctx) {
        return SyncedGuiDescription.getBlockInventory(ctx, () -> EmptyInventory.INSTANCE);
    }

    public static Container getBlockInventory(ContainerLevelAccess ctx, int size) {
        return SyncedGuiDescription.getBlockInventory(ctx, () -> new SimpleContainer(size));
    }

    private static Container getBlockInventory(ContainerLevelAccess ctx, Supplier<Container> fallback) {
        return ctx.evaluate((world, pos) -> {
            WorldlyContainerHolder inventoryProvider;
            WorldlyContainer inventory;
            BlockState state = world.getBlockState(pos);
            Block b = state.getBlock();
            if (b instanceof WorldlyContainerHolder && (inventory = (inventoryProvider = (WorldlyContainerHolder)b).getContainer(state, (LevelAccessor)world, pos)) != null) {
                return inventory;
            }
            BlockEntity be = world.getBlockEntity(pos);
            if (be != null) {
                if (be instanceof WorldlyContainerHolder) {
                    WorldlyContainerHolder inventoryProvider2 = (WorldlyContainerHolder)be;
                    WorldlyContainer inventory2 = inventoryProvider2.getContainer(state, (LevelAccessor)world, pos);
                    if (inventory2 != null) {
                        return inventory2;
                    }
                } else if (be instanceof Container) {
                    Container inventory3 = (Container)be;
                    return inventory3;
                }
            }
            return (Container)fallback.get();
        }).orElseGet(fallback);
    }

    public static ContainerData getBlockPropertyDelegate(ContainerLevelAccess ctx) {
        return (ContainerData)ctx.evaluate((world, pos) -> {
            BlockEntity be = world.getBlockEntity(pos);
            if (be instanceof PropertyDelegateHolder) {
                PropertyDelegateHolder holder = (PropertyDelegateHolder)be;
                return holder.getPropertyDelegate();
            }
            return new SimpleContainerData(0);
        }).orElse(new SimpleContainerData(0));
    }

    public static ContainerData getBlockPropertyDelegate(ContainerLevelAccess ctx, int size) {
        return (ContainerData)ctx.evaluate((world, pos) -> {
            BlockEntity be = world.getBlockEntity(pos);
            if (be instanceof PropertyDelegateHolder) {
                PropertyDelegateHolder holder = (PropertyDelegateHolder)be;
                return holder.getPropertyDelegate();
            }
            return new SimpleContainerData(size);
        }).orElse(new SimpleContainerData(size));
    }

    public boolean stillValid(Player entity) {
        return this.blockInventory != null ? this.blockInventory.stillValid(entity) : true;
    }

    public void removed(Player player) {
        super.removed(player);
        if (this.blockInventory != null) {
            this.blockInventory.stopOpen(player);
        }
    }

    @Override
    public boolean isFocused(WWidget widget) {
        return this.focus == widget;
    }

    @Override
    public WWidget getFocus() {
        return this.focus;
    }

    @Override
    public void requestFocus(WWidget widget) {
        if (this.focus == widget) {
            return;
        }
        if (!widget.canFocus()) {
            return;
        }
        if (this.focus != null) {
            this.focus.onFocusLost();
        }
        this.focus = widget;
        this.focus.onFocusGained();
    }

    @Override
    public void releaseFocus(WWidget widget) {
        if (this.focus == widget) {
            this.focus = null;
            widget.onFocusLost();
        }
    }

    @Override
    public boolean isFullscreen() {
        return this.fullscreen;
    }

    @Override
    public void setFullscreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
    }

    @Override
    public boolean isTitleVisible() {
        return this.titleVisible;
    }

    @Override
    public void setTitleVisible(boolean titleVisible) {
        this.titleVisible = titleVisible;
    }

    @Override
    public HorizontalAlignment getTitleAlignment() {
        return this.titleAlignment;
    }

    @Override
    public void setTitleAlignment(HorizontalAlignment titleAlignment) {
        this.titleAlignment = titleAlignment;
    }

    @Override
    public Vec2i getTitlePos() {
        return this.titlePos;
    }

    @Override
    public void setTitlePos(Vec2i titlePos) {
        this.titlePos = titlePos;
    }

    public Level getWorld() {
        return this.world;
    }

    public final NetworkSide getNetworkSide() {
        return this.world instanceof ServerLevel ? NetworkSide.SERVER : NetworkSide.CLIENT;
    }

    public final PacketSender getPacketSender() {
        if (this.getNetworkSide() == NetworkSide.SERVER) {
            return ServerPlayNetworking.getSender((ServerPlayer)((ServerPlayer)this.playerInventory.player));
        }
        return this.getClientPacketSender();
    }

    @Environment(value=EnvType.CLIENT)
    private PacketSender getClientPacketSender() {
        return ClientPlayNetworking.getSender();
    }
}

