/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.github.cottonmc.cotton.gui.impl.VisualLogger;
import io.github.cottonmc.cotton.gui.widget.WItemSlot;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ValidatedSlot
extends Slot {
    public static final Predicate<ItemStack> DEFAULT_ITEM_FILTER = stack -> true;
    private static final VisualLogger LOGGER = new VisualLogger(ValidatedSlot.class);
    private final int slotNumber;
    private boolean insertingAllowed = true;
    private boolean takingAllowed = true;
    private Predicate<ItemStack> inputFilter = DEFAULT_ITEM_FILTER;
    private Predicate<ItemStack> outputFilter = DEFAULT_ITEM_FILTER;
    protected final Multimap<WItemSlot, WItemSlot.ChangeListener> listeners = HashMultimap.create();
    private boolean visible = true;

    public ValidatedSlot(Container inventory, int index, int x, int y) {
        super(inventory, index, x, y);
        if (inventory == null) {
            throw new IllegalArgumentException("Can't make an itemslot from a null inventory!");
        }
        this.slotNumber = index;
    }

    public boolean mayPlace(ItemStack stack) {
        return this.insertingAllowed && this.container.canPlaceItem(this.slotNumber, stack) && this.inputFilter.test(stack);
    }

    public boolean mayPickup(Player player) {
        return this.takingAllowed && this.container.stillValid(player) && this.outputFilter.test(this.getItem());
    }

    public ItemStack getItem() {
        if (this.container == null) {
            LOGGER.warn("Prevented null-inventory from WItemSlot with slot #: {}", this.slotNumber);
            return ItemStack.EMPTY;
        }
        ItemStack result = super.getItem();
        if (result == null) {
            LOGGER.warn("Prevented null-itemstack crash from: {}", this.container.getClass().getCanonicalName());
            return ItemStack.EMPTY;
        }
        return result;
    }

    public void setChanged() {
        this.listeners.forEach((slot, listener) -> listener.onStackChanged((WItemSlot)slot, this.container, this.getInventoryIndex(), this.getItem()));
        super.setChanged();
    }

    public int getInventoryIndex() {
        return this.slotNumber;
    }

    public boolean isInsertingAllowed() {
        return this.insertingAllowed;
    }

    public void setInsertingAllowed(boolean insertingAllowed) {
        this.insertingAllowed = insertingAllowed;
    }

    public boolean isTakingAllowed() {
        return this.takingAllowed;
    }

    public void setTakingAllowed(boolean takingAllowed) {
        this.takingAllowed = takingAllowed;
    }

    public Predicate<ItemStack> getInputFilter() {
        return this.inputFilter;
    }

    public void setInputFilter(Predicate<ItemStack> inputFilter) {
        this.inputFilter = inputFilter;
    }

    public Predicate<ItemStack> getOutputFilter() {
        return this.outputFilter;
    }

    public void setOutputFilter(Predicate<ItemStack> outputFilter) {
        this.outputFilter = outputFilter;
    }

    public void addChangeListener(WItemSlot owner, WItemSlot.ChangeListener listener) {
        Objects.requireNonNull(owner, "owner");
        Objects.requireNonNull(listener, "listener");
        this.listeners.put((Object)owner, (Object)listener);
    }

    public boolean isActive() {
        return this.isVisible();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

