/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.CottonInventoryScreen;
import io.github.cottonmc.cotton.gui.client.Scissors;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.VisualLogger;
import io.github.cottonmc.cotton.gui.impl.client.CottonScreenImpl;
import io.github.cottonmc.cotton.gui.impl.client.FocusElements;
import io.github.cottonmc.cotton.gui.impl.client.MouseInputHandler;
import io.github.cottonmc.cotton.gui.impl.client.NarrationHelper;
import io.github.cottonmc.cotton.gui.impl.mixin.client.ScreenAccessor;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class CottonClientScreen
extends Screen
implements CottonScreenImpl {
    private static final VisualLogger LOGGER = new VisualLogger(CottonInventoryScreen.class);
    protected GuiDescription description;
    protected int left = 0;
    protected int top = 0;
    protected int titleX;
    protected int titleY;
    @Nullable
    protected WWidget lastResponder = null;
    private final MouseInputHandler<CottonClientScreen> mouseInputHandler = new MouseInputHandler<CottonClientScreen>(this);

    public CottonClientScreen(GuiDescription description) {
        this(CommonComponents.EMPTY, description);
    }

    public CottonClientScreen(Component title, GuiDescription description) {
        super(title);
        this.description = description;
        description.getRootPanel().validate(description);
    }

    @Override
    public GuiDescription getDescription() {
        return this.description;
    }

    public void init() {
        super.init();
        WPanel root = this.description.getRootPanel();
        if (root != null) {
            root.addPainters();
        }
        this.description.addPainters();
        this.reposition(this.width, this.height);
        if (root != null) {
            FocusElements.PanelFocusElement rootPanelElement = FocusElements.ofPanel(root);
            ((ScreenAccessor)((Object)this)).libgui$getChildren().add(rootPanelElement);
            this.setInitialFocus(rootPanelElement);
        } else {
            LOGGER.warn("No root panel found, keyboard navigation disabled", new Object[0]);
        }
    }

    public void removed() {
        super.removed();
        VisualLogger.reset();
    }

    @Override
    @Nullable
    public WWidget getLastResponder() {
        return this.lastResponder;
    }

    @Override
    public void setLastResponder(@Nullable WWidget lastResponder) {
        this.lastResponder = lastResponder;
    }

    protected void reposition(int screenWidth, int screenHeight) {
        WPanel root;
        if (this.description != null && (root = this.description.getRootPanel()) != null) {
            this.titleX = this.description.getTitlePos().x();
            this.titleY = this.description.getTitlePos().y();
            if (!this.description.isFullscreen()) {
                this.left = (screenWidth - root.getWidth()) / 2;
                this.top = (screenHeight - root.getHeight()) / 2;
            } else {
                this.left = 0;
                this.top = 0;
                root.setSize(screenWidth, screenHeight);
            }
        }
    }

    private void paint(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.description != null) {
            WPanel root = this.description.getRootPanel();
            if (root != null) {
                GL11.glEnable((int)3089);
                Scissors.refreshScissors();
                root.paint(context, this.left, this.top, mouseX - this.left, mouseY - this.top);
                GL11.glDisable((int)3089);
                Scissors.checkStackIsEmpty();
            }
            if (this.getTitle() != null && this.description.isTitleVisible()) {
                int width = this.description.getRootPanel().getWidth();
                ScreenDrawing.drawString(context, this.getTitle().getVisualOrderText(), this.description.getTitleAlignment(), this.left + this.titleX, this.top + this.titleY, width - 2 * this.titleX, this.description.getTitleColor());
            }
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        WWidget hitChild;
        WPanel root;
        super.render(context, mouseX, mouseY, partialTicks);
        this.paint(context, mouseX, mouseY, partialTicks);
        if (this.description != null && (root = this.description.getRootPanel()) != null && (hitChild = root.hit(mouseX - this.left, mouseY - this.top)) != null) {
            hitChild.renderTooltip(context, this.left, this.top, mouseX - this.left, mouseY - this.top);
        }
        VisualLogger.render(context);
    }

    public void tick() {
        WPanel root;
        super.tick();
        if (this.description != null && (root = this.description.getRootPanel()) != null) {
            root.tick();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.checkFocus(containerX, containerY);
        if (containerX < 0 || containerY < 0 || containerX >= this.width || containerY >= this.height) {
            return true;
        }
        this.mouseInputHandler.onMouseDown(containerX, containerY, mouseButton);
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        super.mouseReleased(mouseX, mouseY, mouseButton);
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.onMouseUp(containerX, containerY, mouseButton);
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
        super.mouseDragged(mouseX, mouseY, mouseButton, deltaX, deltaY);
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.onMouseDrag(containerX, containerY, mouseButton, deltaX, deltaY);
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.onMouseScroll(containerX, containerY, horizontalAmount, verticalAmount);
        return true;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        super.mouseMoved(mouseX, mouseY);
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.onMouseMove(containerX, containerY);
    }

    public boolean charTyped(char ch, int keyCode) {
        WWidget focus = this.description.getFocus();
        if (focus != null && focus.onCharTyped(ch) == InputResult.PROCESSED) {
            return true;
        }
        return super.charTyped(ch, keyCode);
    }

    public boolean keyPressed(int ch, int keyCode, int modifiers) {
        WWidget focus = this.description.getFocus();
        if (focus != null && focus.onKeyPressed(ch, keyCode, modifiers) == InputResult.PROCESSED) {
            return true;
        }
        return super.keyPressed(ch, keyCode, modifiers);
    }

    public boolean keyReleased(int ch, int keyCode, int modifiers) {
        WWidget focus = this.description.getFocus();
        if (focus != null && focus.onKeyReleased(ch, keyCode, modifiers) == InputResult.PROCESSED) {
            return true;
        }
        return super.keyReleased(ch, keyCode, modifiers);
    }

    protected void updateNarratedWidget(NarrationElementOutput builder) {
        if (this.description != null) {
            NarrationHelper.addNarrations(this.description.getRootPanel(), builder);
        }
    }
}

