/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import com.mojang.blaze3d.platform.Lighting;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.SyncedGuiDescription;
import io.github.cottonmc.cotton.gui.client.Scissors;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.VisualLogger;
import io.github.cottonmc.cotton.gui.impl.client.CottonScreenImpl;
import io.github.cottonmc.cotton.gui.impl.client.FocusElements;
import io.github.cottonmc.cotton.gui.impl.client.MouseInputHandler;
import io.github.cottonmc.cotton.gui.impl.client.NarrationHelper;
import io.github.cottonmc.cotton.gui.impl.mixin.client.ScreenAccessor;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class CottonInventoryScreen<T extends SyncedGuiDescription>
extends AbstractContainerScreen<T>
implements CottonScreenImpl {
    private static final VisualLogger LOGGER = new VisualLogger(CottonInventoryScreen.class);
    protected SyncedGuiDescription description;
    @Nullable
    protected WWidget lastResponder = null;
    private final MouseInputHandler<CottonInventoryScreen<T>> mouseInputHandler = new MouseInputHandler<CottonInventoryScreen>(this);

    public CottonInventoryScreen(T description, Inventory inventory) {
        this(description, inventory, CommonComponents.EMPTY);
    }

    public CottonInventoryScreen(T description, Inventory inventory, Component title) {
        super(description, inventory, title);
        this.description = description;
        this.width = 162;
        this.height = 162;
        this.imageWidth = 162;
        this.imageHeight = 162;
        ((SyncedGuiDescription)description).getRootPanel().validate((GuiDescription)description);
    }

    public CottonInventoryScreen(T description, Player player) {
        this(description, player.getInventory());
    }

    public CottonInventoryScreen(T description, Player player, Component title) {
        this(description, player.getInventory(), title);
    }

    public void init() {
        super.init();
        WPanel root = this.description.getRootPanel();
        if (root != null) {
            root.addPainters();
        }
        this.description.addPainters();
        this.reposition(this.width, this.height);
        if (root != null) {
            FocusElements.PanelFocusElement rootPanelElement = FocusElements.ofPanel(root);
            ((ScreenAccessor)((Object)this)).libgui$getChildren().add(rootPanelElement);
            this.setInitialFocus(rootPanelElement);
        } else {
            LOGGER.warn("No root panel found, keyboard navigation disabled", new Object[0]);
        }
    }

    public void removed() {
        super.removed();
        VisualLogger.reset();
    }

    @Override
    @ApiStatus.Internal
    public GuiDescription getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public WWidget getLastResponder() {
        return this.lastResponder;
    }

    @Override
    public void setLastResponder(@Nullable WWidget lastResponder) {
        this.lastResponder = lastResponder;
    }

    private void clearPeers() {
        this.description.slots.clear();
    }

    protected void reposition(int screenWidth, int screenHeight) {
        WPanel basePanel = this.description.getRootPanel();
        if (basePanel != null) {
            this.clearPeers();
            basePanel.validate(this.description);
            this.imageWidth = basePanel.getWidth();
            this.imageHeight = basePanel.getHeight();
            if (this.imageWidth < 16) {
                this.imageWidth = 300;
            }
            if (this.imageHeight < 16) {
                this.imageHeight = 300;
            }
        }
        this.titleLabelX = this.description.getTitlePos().x();
        this.titleLabelY = this.description.getTitlePos().y();
        if (!this.description.isFullscreen()) {
            this.leftPos = screenWidth / 2 - this.imageWidth / 2;
            this.topPos = screenHeight / 2 - this.imageHeight / 2;
        } else {
            this.leftPos = 0;
            this.topPos = 0;
            if (basePanel != null) {
                basePanel.setSize(screenWidth, screenHeight);
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        int containerX = (int)mouseX - this.leftPos;
        int containerY = (int)mouseY - this.topPos;
        this.mouseInputHandler.checkFocus(containerX, containerY);
        if (containerX < 0 || containerY < 0 || containerX >= this.width || containerY >= this.height) {
            return true;
        }
        this.mouseInputHandler.onMouseDown(containerX, containerY, mouseButton);
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        super.mouseReleased(mouseX, mouseY, mouseButton);
        int containerX = (int)mouseX - this.leftPos;
        int containerY = (int)mouseY - this.topPos;
        this.mouseInputHandler.onMouseUp(containerX, containerY, mouseButton);
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
        super.mouseDragged(mouseX, mouseY, mouseButton, deltaX, deltaY);
        int containerX = (int)mouseX - this.leftPos;
        int containerY = (int)mouseY - this.topPos;
        this.mouseInputHandler.onMouseDrag(containerX, containerY, mouseButton, deltaX, deltaY);
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        int containerX = (int)mouseX - this.leftPos;
        int containerY = (int)mouseY - this.topPos;
        this.mouseInputHandler.onMouseScroll(containerX, containerY, horizontalAmount, verticalAmount);
        return true;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        super.mouseMoved(mouseX, mouseY);
        int containerX = (int)mouseX - this.leftPos;
        int containerY = (int)mouseY - this.topPos;
        this.mouseInputHandler.onMouseMove(containerX, containerY);
    }

    public boolean charTyped(char ch, int keyCode) {
        WWidget focus = this.description.getFocus();
        if (focus != null && focus.onCharTyped(ch) == InputResult.PROCESSED) {
            return true;
        }
        return super.charTyped(ch, keyCode);
    }

    public boolean keyPressed(int ch, int keyCode, int modifiers) {
        WWidget focus = this.description.getFocus();
        if (focus != null && focus.onKeyPressed(ch, keyCode, modifiers) == InputResult.PROCESSED) {
            return true;
        }
        return super.keyPressed(ch, keyCode, modifiers);
    }

    public boolean keyReleased(int ch, int keyCode, int modifiers) {
        WWidget focus = this.description.getFocus();
        if (focus != null && focus.onKeyReleased(ch, keyCode, modifiers) == InputResult.PROCESSED) {
            return true;
        }
        return super.keyReleased(ch, keyCode, modifiers);
    }

    protected void renderBg(GuiGraphics context, float partialTicks, int mouseX, int mouseY) {
    }

    public void paintDescription(GuiGraphics context, int mouseX, int mouseY, float delta) {
        WPanel root;
        if (this.description != null && (root = this.description.getRootPanel()) != null) {
            GL11.glEnable((int)3089);
            Scissors.refreshScissors();
            root.paint(context, this.leftPos, this.topPos, mouseX - this.leftPos, mouseY - this.topPos);
            GL11.glDisable((int)3089);
            Scissors.checkStackIsEmpty();
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        WWidget hitChild;
        WPanel root;
        super.render(context, mouseX, mouseY, partialTicks);
        Lighting.setupForFlatItems();
        if (this.description != null && (root = this.description.getRootPanel()) != null && (hitChild = root.hit(mouseX - this.leftPos, mouseY - this.topPos)) != null) {
            hitChild.renderTooltip(context, this.leftPos, this.topPos, mouseX - this.leftPos, mouseY - this.topPos);
        }
        this.renderTooltip(context, mouseX, mouseY);
        VisualLogger.render(context);
    }

    protected void renderLabels(GuiGraphics context, int mouseX, int mouseY) {
        if (this.description != null && this.description.isTitleVisible()) {
            int width = this.description.getRootPanel().getWidth();
            ScreenDrawing.drawString(context, this.getTitle().getVisualOrderText(), this.description.getTitleAlignment(), this.titleLabelX, this.titleLabelY, width - 2 * this.titleLabelX, this.description.getTitleColor());
        }
    }

    protected void containerTick() {
        WPanel root;
        super.containerTick();
        if (this.description != null && (root = this.description.getRootPanel()) != null) {
            root.tick();
        }
    }

    protected void updateNarratedWidget(NarrationElementOutput builder) {
        if (this.description != null) {
            NarrationHelper.addNarrations(this.description.getRootPanel(), builder);
        }
    }
}

