/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.impl.client.NinePatchTextureRendererImpl;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import juuxel.libninepatch.ContextualTextureRenderer;
import juuxel.libninepatch.NinePatch;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

@Environment(value=EnvType.CLIENT)
public final class NinePatchBackgroundPainter
implements BackgroundPainter {
    private final NinePatch<ResourceLocation> ninePatch;
    private int topPadding = 0;
    private int leftPadding = 0;
    private int bottomPadding = 0;
    private int rightPadding = 0;

    public NinePatchBackgroundPainter(NinePatch<ResourceLocation> ninePatch) {
        this.ninePatch = ninePatch;
    }

    public int getTopPadding() {
        return this.topPadding;
    }

    public NinePatchBackgroundPainter setTopPadding(int topPadding) {
        this.topPadding = topPadding;
        return this;
    }

    public int getLeftPadding() {
        return this.leftPadding;
    }

    public NinePatchBackgroundPainter setLeftPadding(int leftPadding) {
        this.leftPadding = leftPadding;
        return this;
    }

    public int getBottomPadding() {
        return this.bottomPadding;
    }

    public NinePatchBackgroundPainter setBottomPadding(int bottomPadding) {
        this.bottomPadding = bottomPadding;
        return this;
    }

    public int getRightPadding() {
        return this.rightPadding;
    }

    public NinePatchBackgroundPainter setRightPadding(int rightPadding) {
        this.rightPadding = rightPadding;
        return this;
    }

    public NinePatchBackgroundPainter setPadding(int padding) {
        this.bottomPadding = this.rightPadding = padding;
        this.leftPadding = this.rightPadding;
        this.topPadding = this.rightPadding;
        return this;
    }

    public NinePatchBackgroundPainter setPadding(int vertical, int horizontal) {
        this.topPadding = this.bottomPadding = vertical;
        this.leftPadding = this.rightPadding = horizontal;
        return this;
    }

    public NinePatchBackgroundPainter setPadding(int topPadding, int leftPadding, int bottomPadding, int rightPadding) {
        this.topPadding = topPadding;
        this.leftPadding = leftPadding;
        this.bottomPadding = bottomPadding;
        this.rightPadding = rightPadding;
        return this;
    }

    @Override
    public void paintBackground(GuiGraphics context, int left, int top, WWidget panel) {
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.translate((float)(left - this.leftPadding), (float)(top - this.topPadding), 0.0f);
        this.ninePatch.draw((ContextualTextureRenderer)NinePatchTextureRendererImpl.INSTANCE, (Object)context, panel.getWidth() + this.leftPadding + this.rightPadding, panel.getHeight() + this.topPadding + this.bottomPadding);
        matrices.popPose();
    }
}

