/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.cottonmc.cotton.gui.client.LibGui;
import io.github.cottonmc.cotton.gui.client.Scissors;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.Texture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ScreenDrawing {
    private ScreenDrawing() {
    }

    public static void texturedRect(GuiGraphics context, int x, int y, int width, int height, ResourceLocation texture, int color) {
        ScreenDrawing.texturedRect(context, x, y, width, height, texture, 0.0f, 0.0f, 1.0f, 1.0f, color, 1.0f);
    }

    public static void texturedRect(GuiGraphics context, int x, int y, int width, int height, ResourceLocation texture, int color, float opacity) {
        ScreenDrawing.texturedRect(context, x, y, width, height, texture, 0.0f, 0.0f, 1.0f, 1.0f, color, opacity);
    }

    public static void texturedRect(GuiGraphics context, int x, int y, int width, int height, ResourceLocation texture, float u1, float v1, float u2, float v2, int color) {
        ScreenDrawing.texturedRect(context, x, y, width, height, texture, u1, v1, u2, v2, color, 1.0f);
    }

    public static void texturedRect(GuiGraphics context, int x, int y, int width, int height, Texture texture, int color) {
        ScreenDrawing.texturedRect(context, x, y, width, height, texture, color, 1.0f);
    }

    /*
     * Unable to fully structure code
     */
    public static void texturedRect(GuiGraphics context, int x, int y, int width, int height, Texture texture, int color, float opacity) {
        switch (1.$SwitchMap$io$github$cottonmc$cotton$gui$widget$data$Texture$Type[texture.type().ordinal()]) {
            case 1: {
                ScreenDrawing.texturedRect(context, x, y, width, height, texture.image(), texture.u1(), texture.v1(), texture.u2(), texture.v2(), color, opacity);
                break;
            }
            case 2: {
                r = (float)(color >> 16 & 255) / 255.0f;
                g = (float)(color >> 8 & 255) / 255.0f;
                b = (float)(color & 255) / 255.0f;
                a = (float)(color >> 24 & 255) / 255.0f;
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)(opacity * a));
                if (texture.u1() != 0.0f || texture.u2() != 1.0f || texture.v1() != 0.0f || texture.v2() != 1.0f) ** GOTO lbl15
                context.blitSprite(texture.image(), x, y, width, height);
                ** GOTO lbl33
lbl15:
                // 1 sources

                fullWidth = (float)width / Math.abs(texture.u2() - texture.u1());
                fullHeight = (float)height / Math.abs(texture.v2() - texture.v1());
                if (Float.isInfinite(fullWidth) || Float.isInfinite(fullHeight)) ** GOTO lbl33
                xo = (float)x - fullWidth * Math.min(texture.u1(), texture.u2());
                yo = (float)y - fullHeight * Math.min(texture.v1(), texture.v2());
                matrices = context.pose();
                matrices.pushPose();
                matrices.translate(xo, yo, 0.0f);
                matrices.scale(fullWidth / (float)width, fullHeight / (float)height, 1.0f);
                frame = Scissors.push(x, y, width, height);
                try {
                    context.blitSprite(texture.image(), 0, 0, width, height);
                }
                finally {
                    if (frame != null) {
                        frame.close();
                    }
                }
                matrices.popPose();
lbl33:
                // 3 sources

                RenderSystem.disableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    public static void texturedRect(GuiGraphics context, int x, int y, int width, int height, ResourceLocation texture, float u1, float v1, float u2, float v2, int color, float opacity) {
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        Matrix4f model = context.pose().last().pose();
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)(opacity * a));
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(model, (float)x, (float)(y + height), 0.0f).setUv(u1, v2);
        buffer.addVertex(model, (float)(x + width), (float)(y + height), 0.0f).setUv(u2, v2);
        buffer.addVertex(model, (float)(x + width), (float)y, 0.0f).setUv(u2, v1);
        buffer.addVertex(model, (float)x, (float)y, 0.0f).setUv(u1, v1);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void texturedGuiRect(GuiGraphics context, int x, int y, int width, int height, ResourceLocation texture, int textureX, int textureY, int color) {
        float px = 0.00390625f;
        ScreenDrawing.texturedRect(context, x, y, width, height, texture, (float)textureX * px, (float)textureY * px, (float)(textureX + width) * px, (float)(textureY + height) * px, color);
    }

    public static void texturedGuiRect(GuiGraphics context, int left, int top, int width, int height, ResourceLocation texture, int color) {
        ScreenDrawing.texturedGuiRect(context, left, top, width, height, texture, 0, 0, color);
    }

    public static void coloredRect(GuiGraphics context, int left, int top, int width, int height, int color) {
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        context.fill(left, top, left + width, top + height, color);
    }

    public static void drawGuiPanel(GuiGraphics context, int x, int y, int width, int height) {
        if (LibGui.isDarkMode()) {
            ScreenDrawing.drawGuiPanel(context, x, y, width, height, -16053493, -13684945, -12500671, -16777216);
        } else {
            ScreenDrawing.drawGuiPanel(context, x, y, width, height, -11184811, -3750202, -1, -16777216);
        }
    }

    public static void drawGuiPanel(GuiGraphics context, int x, int y, int width, int height, int panelColor) {
        int shadowColor = ScreenDrawing.multiplyColor(panelColor, 0.5f);
        int hilightColor = ScreenDrawing.multiplyColor(panelColor, 1.25f);
        ScreenDrawing.drawGuiPanel(context, x, y, width, height, shadowColor, panelColor, hilightColor, -16777216);
    }

    public static void drawGuiPanel(GuiGraphics context, int x, int y, int width, int height, int shadow, int panel, int hilight, int outline) {
        ScreenDrawing.coloredRect(context, x + 3, y + 3, width - 6, height - 6, panel);
        ScreenDrawing.coloredRect(context, x + 2, y + 1, width - 4, 2, hilight);
        ScreenDrawing.coloredRect(context, x + 2, y + height - 3, width - 4, 2, shadow);
        ScreenDrawing.coloredRect(context, x + 1, y + 2, 2, height - 4, hilight);
        ScreenDrawing.coloredRect(context, x + width - 3, y + 2, 2, height - 4, shadow);
        ScreenDrawing.coloredRect(context, x + width - 3, y + 2, 1, 1, panel);
        ScreenDrawing.coloredRect(context, x + 2, y + height - 3, 1, 1, panel);
        ScreenDrawing.coloredRect(context, x + 3, y + 3, 1, 1, hilight);
        ScreenDrawing.coloredRect(context, x + width - 4, y + height - 4, 1, 1, shadow);
        ScreenDrawing.coloredRect(context, x + 2, y, width - 4, 1, outline);
        ScreenDrawing.coloredRect(context, x, y + 2, 1, height - 4, outline);
        ScreenDrawing.coloredRect(context, x + width - 1, y + 2, 1, height - 4, outline);
        ScreenDrawing.coloredRect(context, x + 2, y + height - 1, width - 4, 1, outline);
        ScreenDrawing.coloredRect(context, x + 1, y + 1, 1, 1, outline);
        ScreenDrawing.coloredRect(context, x + 1, y + height - 2, 1, 1, outline);
        ScreenDrawing.coloredRect(context, x + width - 2, y + 1, 1, 1, outline);
        ScreenDrawing.coloredRect(context, x + width - 2, y + height - 2, 1, 1, outline);
    }

    public static void drawBeveledPanel(GuiGraphics context, int x, int y) {
        ScreenDrawing.drawBeveledPanel(context, x, y, 18, 18, -13158601, -7631989, -1);
    }

    public static void drawBeveledPanel(GuiGraphics context, int x, int y, int width, int height) {
        ScreenDrawing.drawBeveledPanel(context, x, y, width, height, -13158601, -7631989, -1);
    }

    public static void drawBeveledPanel(GuiGraphics context, int x, int y, int width, int height, int topleft, int panel, int bottomright) {
        ScreenDrawing.coloredRect(context, x, y, width, height, panel);
        ScreenDrawing.coloredRect(context, x, y, width - 1, 1, topleft);
        ScreenDrawing.coloredRect(context, x, y + 1, 1, height - 2, topleft);
        ScreenDrawing.coloredRect(context, x + width - 1, y + 1, 1, height - 1, bottomright);
        ScreenDrawing.coloredRect(context, x + 1, y + height - 1, width - 1, 1, bottomright);
    }

    public static void drawString(GuiGraphics context, String s, HorizontalAlignment align, int x, int y, int width, int color) {
        Font textRenderer = Minecraft.getInstance().font;
        switch (align) {
            case LEFT: {
                context.drawString(textRenderer, s, x, y, color, false);
                break;
            }
            case CENTER: {
                int wid = textRenderer.width(s);
                int l = width / 2 - wid / 2;
                context.drawString(textRenderer, s, x + l, y, color, false);
                break;
            }
            case RIGHT: {
                int wid = textRenderer.width(s);
                int l = width - wid;
                context.drawString(textRenderer, s, x + l, y, color, false);
            }
        }
    }

    public static void drawString(GuiGraphics context, FormattedCharSequence text, HorizontalAlignment align, int x, int y, int width, int color) {
        Font textRenderer = Minecraft.getInstance().font;
        switch (align) {
            case LEFT: {
                context.drawString(textRenderer, text, x, y, color, false);
                break;
            }
            case CENTER: {
                int wid = textRenderer.width(text);
                int l = width / 2 - wid / 2;
                context.drawString(textRenderer, text, x + l, y, color, false);
                break;
            }
            case RIGHT: {
                int wid = textRenderer.width(text);
                int l = width - wid;
                context.drawString(textRenderer, text, x + l, y, color, false);
            }
        }
    }

    public static void drawStringWithShadow(GuiGraphics context, String s, HorizontalAlignment align, int x, int y, int width, int color) {
        Font textRenderer = Minecraft.getInstance().font;
        switch (align) {
            case LEFT: {
                context.drawString(textRenderer, s, x, y, color, true);
                break;
            }
            case CENTER: {
                int wid = textRenderer.width(s);
                int l = width / 2 - wid / 2;
                context.drawString(textRenderer, s, x + l, y, color, true);
                break;
            }
            case RIGHT: {
                int wid = textRenderer.width(s);
                int l = width - wid;
                context.drawString(textRenderer, s, x + l, y, color, true);
            }
        }
    }

    public static void drawStringWithShadow(GuiGraphics context, FormattedCharSequence text, HorizontalAlignment align, int x, int y, int width, int color) {
        Font textRenderer = Minecraft.getInstance().font;
        switch (align) {
            case LEFT: {
                context.drawString(textRenderer, text, x, y, color, true);
                break;
            }
            case CENTER: {
                int wid = textRenderer.width(text);
                int l = width / 2 - wid / 2;
                context.drawString(textRenderer, text, x + l, y, color, true);
                break;
            }
            case RIGHT: {
                int wid = textRenderer.width(text);
                int l = width - wid;
                context.drawString(textRenderer, text, x + l, y, color, true);
            }
        }
    }

    public static void drawString(GuiGraphics context, String s, int x, int y, int color) {
        context.drawString(Minecraft.getInstance().font, s, x, y, color, false);
    }

    public static void drawString(GuiGraphics context, FormattedCharSequence text, int x, int y, int color) {
        context.drawString(Minecraft.getInstance().font, text, x, y, color, false);
    }

    public static void drawTextHover(GuiGraphics context, @Nullable Style textStyle, int x, int y) {
        context.renderComponentHoverEffect(Minecraft.getInstance().font, textStyle, x, y);
    }

    public static int colorAtOpacity(int opaque, float opacity) {
        if (opacity < 0.0f) {
            opacity = 0.0f;
        }
        if (opacity > 1.0f) {
            opacity = 1.0f;
        }
        int a = (int)(opacity * 255.0f);
        return opaque & 0xFFFFFF | a << 24;
    }

    public static int multiplyColor(int color, float amount) {
        int a = color & 0xFF000000;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        r = Math.min(r * amount, 1.0f);
        g = Math.min(g * amount, 1.0f);
        b = Math.min(b * amount, 1.0f);
        int ir = (int)(r * 255.0f);
        int ig = (int)(g * 255.0f);
        int ib = (int)(b * 255.0f);
        return a | ir << 16 | ig << 8 | ib;
    }
}

