/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.impl;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import io.github.cottonmc.cotton.gui.SyncedGuiDescription;
import io.github.cottonmc.cotton.gui.impl.LibGuiCommon;
import io.github.cottonmc.cotton.gui.networking.NetworkSide;
import io.github.cottonmc.cotton.gui.networking.ScreenNetworking;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenNetworkingImpl
implements ScreenNetworking {
    private static final long MAX_NBT_SIZE = 0x200000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScreenNetworkingImpl.class);
    private static final Map<SyncedGuiDescription, ScreenNetworkingImpl> instanceCache = new WeakHashMap<SyncedGuiDescription, ScreenNetworkingImpl>();
    private final Map<ResourceLocation, ReceiverData<?>> receivers = new HashMap();
    private final SyncedGuiDescription description;
    private final NetworkSide side;

    private ScreenNetworkingImpl(SyncedGuiDescription description, NetworkSide side) {
        this.description = description;
        this.side = side;
    }

    private static RegistryOps<Tag> getRegistryOps(RegistryAccess registryManager) {
        return registryManager.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
    }

    @Override
    public <D> void receive(ResourceLocation message, Decoder<D> decoder, ScreenNetworking.MessageReceiver<D> receiver) {
        Objects.requireNonNull(message, "message");
        Objects.requireNonNull(decoder, "decoder");
        Objects.requireNonNull(receiver, "receiver");
        if (this.receivers.containsKey(message)) {
            throw new IllegalStateException("Message " + String.valueOf(message) + " on side " + String.valueOf((Object)this.side) + " already registered");
        }
        this.receivers.put(message, new ReceiverData<D>(decoder, receiver));
    }

    @Override
    public <D> void send(ResourceLocation message, Encoder<D> encoder, D data) {
        Objects.requireNonNull(message, "message");
        Objects.requireNonNull(encoder, "encoder");
        RegistryOps<Tag> ops = ScreenNetworkingImpl.getRegistryOps(this.description.getWorld().registryAccess());
        Tag encoded = (Tag)encoder.encodeStart(ops, data).getOrThrow();
        ScreenMessage packet = new ScreenMessage(this.description.containerId, message, encoded);
        this.description.getPacketSender().sendPacket((CustomPacketPayload)packet);
    }

    public static void init() {
        PayloadTypeRegistry.playS2C().register(ScreenMessage.ID, ScreenMessage.CODEC);
        PayloadTypeRegistry.playC2S().register(ScreenMessage.ID, ScreenMessage.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ScreenMessage.ID, (payload, context) -> ScreenNetworkingImpl.handle((Executor)context.player().server, (Player)context.player(), payload));
    }

    public static void handle(Executor executor, Player player, ScreenMessage packet) {
        AbstractContainerMenu screenHandler = player.containerMenu;
        if (!(screenHandler instanceof SyncedGuiDescription)) {
            LOGGER.error("Received message packet for screen handler {} which is not a SyncedGuiDescription", (Object)screenHandler);
            return;
        }
        if (packet.syncId() != screenHandler.containerId) {
            LOGGER.error("Received message for sync ID {}, current sync ID: {}", (Object)packet.syncId(), (Object)screenHandler.containerId);
            return;
        }
        ScreenNetworkingImpl networking = instanceCache.get(screenHandler);
        if (networking != null) {
            ReceiverData<?> receiverData = networking.receivers.get(packet.message());
            if (receiverData != null) {
                ScreenNetworkingImpl.processMessage(executor, player, packet, screenHandler, receiverData);
            } else {
                LOGGER.error("Message {} not registered for {} on side {}", new Object[]{packet.message(), screenHandler, networking.side});
            }
        } else {
            LOGGER.warn("GUI description {} does not use networking", (Object)screenHandler);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <D> void processMessage(Executor executor, Player player, ScreenMessage packet, AbstractContainerMenu description, ReceiverData<D> receiverData) {
        DataResult result;
        RegistryOps<Tag> ops = ScreenNetworkingImpl.getRegistryOps(player.registryAccess());
        DataResult dataResult = result = receiverData.decoder().parse(ops, (Object)packet.nbt());
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                DataResult.Success success = (DataResult.Success)dataResult2;
                try {
                    Object object;
                    Object data = object = success.value();
                    Object lifecycle = object = success.lifecycle();
                    executor.execute(() -> {
                        try {
                            receiverData.receiver().onMessage(data);
                        }
                        catch (Exception e) {
                            LOGGER.error("Error handling screen message {} for {}", new Object[]{packet.message(), description, e});
                        }
                    });
                    return;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        DataResult.Error error = (DataResult.Error)dataResult2;
        LOGGER.error("Could not parse screen message {}: {}", (Object)packet.message(), (Object)error.message());
    }

    public static ScreenNetworking of(SyncedGuiDescription description, NetworkSide networkSide) {
        Objects.requireNonNull(description, "description");
        Objects.requireNonNull(networkSide, "networkSide");
        if (description.getNetworkSide() == networkSide) {
            return instanceCache.computeIfAbsent(description, it -> new ScreenNetworkingImpl(description, networkSide));
        }
        return DummyNetworking.INSTANCE;
    }

    private record ReceiverData<D>(Decoder<D> decoder, ScreenNetworking.MessageReceiver<D> receiver) {
    }

    public record ScreenMessage(int syncId, ResourceLocation message, Tag nbt) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ScreenMessage> ID = new CustomPacketPayload.Type(LibGuiCommon.id("screen_message"));
        public static final StreamCodec<RegistryFriendlyByteBuf, ScreenMessage> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ScreenMessage::syncId, (StreamCodec)ResourceLocation.STREAM_CODEC, ScreenMessage::message, (StreamCodec)ByteBufCodecs.tagCodec(() -> NbtAccounter.create((long)0x200000L)), ScreenMessage::nbt, ScreenMessage::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    private static final class DummyNetworking
    extends ScreenNetworkingImpl {
        static final DummyNetworking INSTANCE = new DummyNetworking();

        private DummyNetworking() {
            super(null, null);
        }

        @Override
        public <D> void receive(ResourceLocation message, Decoder<D> decoder, ScreenNetworking.MessageReceiver<D> receiver) {
        }

        @Override
        public <D> void send(ResourceLocation message, Encoder<D> encoder, D data) {
        }
    }
}

