/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.impl;

import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public final class VisualLogger {
    private static final List<Component> WARNINGS = new ArrayList<Component>();
    private final Logger logger;
    private final Class<?> clazz;

    public VisualLogger(Class<?> clazz) {
        this.logger = LogManager.getLogger(clazz);
        this.clazz = clazz;
    }

    public void error(String message, Object ... params) {
        this.log(message, params, Level.ERROR, ChatFormatting.RED);
    }

    public void warn(String message, Object ... params) {
        this.log(message, params, Level.WARN, ChatFormatting.GOLD);
    }

    private void log(String message, Object[] params, Level level, ChatFormatting formatting) {
        this.logger.log(level, message, params);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            MutableComponent text = Component.literal((String)(this.clazz.getSimpleName() + "/"));
            text.append((Component)Component.literal((String)level.name()).withStyle(formatting));
            text.append((Component)Component.literal((String)(": " + ParameterizedMessage.format((String)message, (Object[])params))));
            WARNINGS.add((Component)text);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void render(GuiGraphics context) {
        Minecraft client = Minecraft.getInstance();
        Font textRenderer = client.font;
        int width = client.getWindow().getGuiScaledWidth();
        ArrayList lines = new ArrayList();
        for (Component warning : WARNINGS) {
            lines.addAll(textRenderer.split((FormattedText)warning, width));
        }
        Objects.requireNonNull(textRenderer);
        int fontHeight = 9;
        int y = 0;
        for (FormattedCharSequence line : lines) {
            ScreenDrawing.coloredRect(context, 2, 2 + y, textRenderer.width(line), fontHeight, -2013265920);
            ScreenDrawing.drawString(context, line, 2, 2 + y, -1);
            y += fontHeight;
        }
    }

    public static void reset() {
        WARNINGS.clear();
    }
}

