/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.impl.client;

import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Rect2i;
import io.github.cottonmc.cotton.gui.widget.focus.Focus;
import io.github.cottonmc.cotton.gui.widget.focus.FocusModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import org.jetbrains.annotations.Nullable;

public final class FocusElements {
    public static PanelFocusElement ofPanel(WPanel panel) {
        PanelFocusElement result = new PanelFocusElement(panel);
        result.refreshChildren();
        return result;
    }

    public static Stream<FocusElement<?>> toElements(WWidget widget) {
        if (widget instanceof WPanel) {
            WPanel panel = (WPanel)widget;
            return Stream.of(FocusElements.ofPanel(panel));
        }
        return FocusElements.fromFoci(widget);
    }

    private static Stream<FocusElement<?>> fromFoci(WWidget widget) {
        @Nullable FocusModel<?> focusModel = widget.getFocusModel();
        if (focusModel == null) {
            return Stream.empty();
        }
        return focusModel.foci().map(focus -> new LeafFocusElement(widget, (Focus<?>)focus));
    }

    private static final class PanelFocusElement
    extends AbstractContainerEventHandler
    implements FocusElement<WPanel> {
        private final List<FocusElement<?>> children = new ArrayList();
        private final WPanel widget;
        private List<WWidget> childWidgets;

        private PanelFocusElement(WPanel widget) {
            this.widget = widget;
        }

        private void refreshChildren() {
            boolean shouldRefresh = false;
            if (this.childWidgets == null) {
                this.childWidgets = this.widget.streamChildren().toList();
                shouldRefresh = true;
            } else {
                List<WWidget> currentChildren = this.widget.streamChildren().toList();
                if (!this.childWidgets.equals(currentChildren)) {
                    this.childWidgets = currentChildren;
                    shouldRefresh = true;
                }
            }
            if (shouldRefresh) {
                this.children.clear();
                FocusElements.fromFoci(this.widget).forEach(this.children::add);
                this.childWidgets.stream().flatMap(FocusElements::toElements).forEach(this.children::add);
                this.refreshFocus();
            }
        }

        public List<FocusElement<?>> children() {
            this.refreshChildren();
            return this.children;
        }

        @Override
        public WPanel widget() {
            return this.widget;
        }

        @Nullable
        public GuiEventListener getFocused() {
            this.refreshFocus();
            return super.getFocused();
        }

        public void refreshFocus() {
            if (this.children.isEmpty()) {
                return;
            }
            boolean foundFocus = false;
            for (FocusElement<?> child : this.children) {
                if (child instanceof PanelFocusElement) {
                    PanelFocusElement panel = (PanelFocusElement)child;
                    panel.refreshFocus();
                }
                if (foundFocus || !child.isFocused()) continue;
                this.setFocused(child);
                foundFocus = true;
            }
        }
    }

    private record LeafFocusElement(WWidget widget, Focus<?> focus) implements FocusElement<WWidget>
    {
        public void setFocused(boolean focused) {
            if (focused) {
                Focus<?> focus = this.focus();
                if (focus != null) {
                    this.widget.requestFocus();
                    this.widget.getFocusModel().setFocused(focus);
                }
            } else {
                this.widget.releaseFocus();
            }
        }

        public boolean isFocused() {
            FocusModel<?> focusModel;
            if (this.widget.isFocused() && (focusModel = this.widget.getFocusModel()) != null) {
                return focusModel.isFocused(this.focus);
            }
            return false;
        }

        public ScreenRectangle getRectangle() {
            Rect2i area = this.focus.area();
            return new ScreenRectangle(this.widget.getAbsoluteX() + area.x(), this.widget.getAbsoluteY() + area.y(), area.width(), area.height());
        }

        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent navigation) {
            return this.widget.canFocus() && !this.isFocused() ? ComponentPath.leaf((GuiEventListener)this) : null;
        }
    }

    public static sealed interface FocusElement<W extends WWidget>
    extends GuiEventListener
    permits PanelFocusElement, LeafFocusElement {
        public W widget();
    }
}

