/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.impl.client;

import io.github.cottonmc.cotton.gui.impl.client.CottonScreenImpl;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public final class ItemUseChecker {
    private static final String ALLOW_ITEM_USE_PROPERTY = "libgui.allowItemUse";
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private static final List<Tuple<String, MethodType>> ITEM_USE_METHODS = (List)Util.make(new ArrayList(), result -> {
        MappingResolver resolver = FabricLoader.getInstance().getMappingResolver();
        String hand = "class_1268";
        String actionResult = "class_1269";
        String typedActionResult = "class_1271";
        String livingEntity = "class_1309";
        String playerEntity = "class_1657";
        String itemStack = "class_1799";
        String itemUsageContext = "class_1838";
        String world = "class_1937";
        result.add(ItemUseChecker.resolveItemMethod(resolver, "use", typedActionResult, world, playerEntity, hand));
        result.add(ItemUseChecker.resolveItemMethod(resolver, "useOn", actionResult, itemUsageContext));
        result.add(ItemUseChecker.resolveItemMethod(resolver, "interactLivingEntity", actionResult, itemStack, playerEntity, livingEntity, hand));
    });

    private static Tuple<String, MethodType> resolveItemMethod(MappingResolver resolver, String name, String returnType, String ... parameterTypes) {
        StringBuilder desc = new StringBuilder("(");
        for (String type : parameterTypes) {
            desc.append("Lnet/minecraft/").append(type).append(';');
        }
        desc.append(")Lnet/minecraft/").append(returnType).append(';');
        String deobfName = resolver.mapMethodName("intermediary", "net.minecraft.world.item.Item", name, desc.toString());
        Function<String, Class> getIntermediaryClass = className -> {
            className = resolver.mapClassName("intermediary", "net.minecraft." + className);
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not resolve class net.minecraft." + className, e);
            }
        };
        Class[] paramClasses = (Class[])Arrays.stream(parameterTypes).map(getIntermediaryClass).toArray(Class[]::new);
        Class returnClass = getIntermediaryClass.apply(returnType);
        try {
            Item.class.getMethod(deobfName, paramClasses);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find Item method " + deobfName, e);
        }
        return new Tuple((Object)deobfName, (Object)MethodType.methodType(returnClass, paramClasses));
    }

    public static void checkSetScreen(Screen screen) {
        CottonScreenImpl cs;
        block5: {
            block4: {
                if (!(screen instanceof CottonScreenImpl)) break block4;
                cs = (CottonScreenImpl)screen;
                if (!Boolean.getBoolean(ALLOW_ITEM_USE_PROPERTY)) break block5;
            }
            return;
        }
        @Nullable Tuple useMethodCaller = STACK_WALKER.walk(s -> s.skip(3L).flatMap(frame -> {
            if (!Item.class.isAssignableFrom(frame.getDeclaringClass())) {
                return Stream.empty();
            }
            return ITEM_USE_METHODS.stream().filter(method -> ((String)method.getA()).equals(frame.getMethodName()) && ((MethodType)method.getB()).equals((Object)frame.getMethodType())).map(method -> new Tuple(frame.getDeclaringClass(), (Object)((String)method.getA())));
        }).findFirst()).orElse(null);
        if (useMethodCaller != null) {
            String message = "[LibGui] Screens cannot be opened in item use methods. Some alternatives include:\n\t- Using a packet together with LightweightGuiDescription\n\t- Using an ItemSyncedGuiDescription\nSetting the screen in item use methods leads to threading issues and\nother potential crashes on both the client and the server.\nIf you want to disable this check, set the system property %s to \"true\".".formatted(ALLOW_ITEM_USE_PROPERTY);
            UnsupportedOperationException cause = new UnsupportedOperationException(message);
            cause.fillInStackTrace();
            CrashReport report = CrashReport.forThrowable((Throwable)cause, (String)"Opening screen");
            report.addCategory("Screen opening details").setDetail("Screen class", (Object)screen.getClass().getName()).setDetail("GUI description", () -> cs.getDescription().getClass().getName()).setDetail("Item class", () -> ((Class)useMethodCaller.getA()).getName()).setDetail("Involved method", useMethodCaller.getB());
            throw new ReportedException(report);
        }
    }
}

