/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.impl.client;

import io.github.cottonmc.cotton.gui.impl.client.NarrationMessages;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

@Environment(value=EnvType.CLIENT)
public final class NarrationHelper {
    public static void addNarrations(WPanel rootPanel, NarrationElementOutput builder) {
        List narratableWidgets = NarrationHelper.getAllWidgets(rootPanel).filter(WWidget::isNarratable).collect(Collectors.toList());
        int childCount = narratableWidgets.size();
        for (int i = 0; i < childCount; ++i) {
            WWidget child = (WWidget)narratableWidgets.get(i);
            if (!child.isFocused() && !child.isHovered()) continue;
            if (narratableWidgets.size() > 1) {
                builder.add(NarratedElementType.POSITION, (Component)Component.translatable((String)"narrator.position.screen", (Object[])new Object[]{i + 1, childCount}));
                if (child.isFocused()) {
                    builder.add(NarratedElementType.USAGE, NarrationMessages.Vanilla.COMPONENT_LIST_USAGE);
                }
            }
            child.addNarrations(builder.nest());
        }
    }

    private static Stream<WWidget> getAllWidgets(WPanel panel) {
        return Stream.concat(Stream.of(panel), panel.streamChildren().flatMap(widget -> {
            if (widget instanceof WPanel) {
                WPanel nested = (WPanel)widget;
                return NarrationHelper.getAllWidgets(nested);
            }
            return Stream.of(widget);
        }));
    }
}

