/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.impl.client;

import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.VerticalAlignment;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.util.FormattedCharSequence;

public final class TextAlignment {
    public static int getTextOffsetX(HorizontalAlignment alignment, int width, FormattedCharSequence text) {
        return switch (alignment) {
            default -> throw new MatchException(null, null);
            case HorizontalAlignment.LEFT -> 0;
            case HorizontalAlignment.CENTER -> {
                Font renderer = Minecraft.getInstance().font;
                int textWidth = renderer.width(text);
                yield width / 2 - textWidth / 2;
            }
            case HorizontalAlignment.RIGHT -> {
                Font renderer = Minecraft.getInstance().font;
                int textWidth = renderer.width(text);
                yield width - textWidth;
            }
        };
    }

    public static int getTextOffsetY(VerticalAlignment alignment, int height, int lines) {
        return switch (alignment) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> 0;
            case VerticalAlignment.CENTER -> {
                Font renderer = Minecraft.getInstance().font;
                Objects.requireNonNull(renderer);
                int textHeight = 9 * lines;
                yield height / 2 - textHeight / 2;
            }
            case VerticalAlignment.BOTTOM -> {
                Font renderer = Minecraft.getInstance().font;
                Objects.requireNonNull(renderer);
                int textHeight = 9 * lines;
                yield height - textHeight;
            }
        };
    }
}

