/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.TooltipBuilder;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Texture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.ContainerData;
import org.jetbrains.annotations.Nullable;

public class WBar
extends WWidget {
    @Nullable
    protected final Texture bg;
    @Nullable
    protected final Texture bar;
    protected final int field;
    protected final int max;
    protected int maxValue;
    protected ContainerData properties;
    private boolean manuallySetProperties = false;
    protected final Direction direction;
    protected String tooltipLabel;
    protected Component tooltipTextComponent;

    public WBar(@Nullable Texture bg, @Nullable Texture bar, int field, int maxField) {
        this(bg, bar, field, maxField, Direction.UP);
    }

    public WBar(@Nullable Texture bg, @Nullable Texture bar, int field, int maxField, Direction dir) {
        this.bg = bg;
        this.bar = bar;
        this.field = field;
        this.max = maxField;
        this.maxValue = 0;
        this.direction = dir;
    }

    public WBar(ResourceLocation bg, ResourceLocation bar, int field, int maxField) {
        this(bg, bar, field, maxField, Direction.UP);
    }

    public WBar(ResourceLocation bg, ResourceLocation bar, int field, int maxField, Direction dir) {
        this(new Texture(bg), new Texture(bar), field, maxField, dir);
    }

    public WBar withTooltip(String label) {
        this.tooltipLabel = label;
        return this;
    }

    public WBar withTooltip(Component label) {
        this.tooltipTextComponent = label;
        return this;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(GuiGraphics context, int x, int y, int mouseX, int mouseY) {
        int barSize;
        if (this.bg != null) {
            ScreenDrawing.texturedRect(context, x, y, this.getWidth(), this.getHeight(), this.bg, -1);
        } else {
            ScreenDrawing.coloredRect(context, x, y, this.getWidth(), this.getHeight(), ScreenDrawing.colorAtOpacity(0, 0.25f));
        }
        int maxVal = this.max >= 0 ? this.properties.get(this.max) : this.maxValue;
        float percent = (float)this.properties.get(this.field) / (float)maxVal;
        if (percent < 0.0f) {
            percent = 0.0f;
        }
        if (percent > 1.0f) {
            percent = 1.0f;
        }
        int barMax = this.getWidth();
        if (this.direction == Direction.DOWN || this.direction == Direction.UP) {
            barMax = this.getHeight();
        }
        if ((barSize = (int)((float)barMax * (percent = (float)((int)(percent * (float)barMax)) / (float)barMax))) <= 0) {
            return;
        }
        switch (this.direction.ordinal()) {
            case 0: {
                int left = x;
                int top = y + this.getHeight();
                top -= barSize;
                if (this.bar != null) {
                    Texture clipped = this.bar.withUv(this.bar.u1(), Mth.lerp((float)percent, (float)this.bar.v2(), (float)this.bar.v1()), this.bar.u2(), this.bar.v2());
                    ScreenDrawing.texturedRect(context, left, top, this.getWidth(), barSize, clipped, -1);
                    break;
                }
                ScreenDrawing.coloredRect(context, left, top, this.getWidth(), barSize, ScreenDrawing.colorAtOpacity(0xFFFFFF, 0.5f));
                break;
            }
            case 1: {
                if (this.bar != null) {
                    Texture clipped = this.bar.withUv(this.bar.u1(), this.bar.v1(), Mth.lerp((float)percent, (float)this.bar.u1(), (float)this.bar.u2()), this.bar.v2());
                    ScreenDrawing.texturedRect(context, x, y, barSize, this.getHeight(), clipped, -1);
                    break;
                }
                ScreenDrawing.coloredRect(context, x, y, barSize, this.getHeight(), ScreenDrawing.colorAtOpacity(0xFFFFFF, 0.5f));
                break;
            }
            case 2: {
                if (this.bar != null) {
                    Texture clipped = this.bar.withUv(this.bar.u1(), this.bar.v1(), this.bar.u2(), Mth.lerp((float)percent, (float)this.bar.v1(), (float)this.bar.v2()));
                    ScreenDrawing.texturedRect(context, x, y, this.getWidth(), barSize, clipped, -1);
                    break;
                }
                ScreenDrawing.coloredRect(context, x, y, this.getWidth(), barSize, ScreenDrawing.colorAtOpacity(0xFFFFFF, 0.5f));
                break;
            }
            case 3: {
                int left = x + this.getWidth();
                int top = y;
                left -= barSize;
                if (this.bar != null) {
                    Texture clipped = this.bar.withUv(Mth.lerp((float)percent, (float)this.bar.u2(), (float)this.bar.u1()), this.bar.v1(), this.bar.u2(), this.bar.v2());
                    ScreenDrawing.texturedRect(context, left, top, barSize, this.getHeight(), clipped, -1);
                    break;
                }
                ScreenDrawing.coloredRect(context, left, top, barSize, this.getHeight(), ScreenDrawing.colorAtOpacity(0xFFFFFF, 0.5f));
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addTooltip(TooltipBuilder information) {
        if (this.tooltipLabel != null) {
            int value = this.field >= 0 ? this.properties.get(this.field) : 0;
            int valMax = this.max >= 0 ? this.properties.get(this.max) : this.maxValue;
            information.add(new Component[]{Component.translatable((String)this.tooltipLabel, (Object[])new Object[]{value, valMax})});
        }
        if (this.tooltipTextComponent != null) {
            try {
                information.add(this.tooltipTextComponent);
            }
            catch (Throwable t) {
                information.add(new Component[]{Component.literal((String)t.getLocalizedMessage())});
            }
        }
    }

    @Override
    public void validate(GuiDescription host) {
        super.validate(host);
        if (this.properties == null || !this.manuallySetProperties) {
            this.properties = host.getPropertyDelegate();
        }
    }

    @Nullable
    public ContainerData getProperties() {
        return this.properties;
    }

    public WBar setProperties(ContainerData properties) {
        this.properties = properties;
        this.manuallySetProperties = properties != null;
        return this;
    }

    public static WBar withConstantMaximum(ResourceLocation bg, ResourceLocation bar, int field, int maxValue, Direction dir) {
        WBar result = new WBar(bg, bar, field, -1, dir);
        result.maxValue = maxValue;
        return result;
    }

    public static WBar withConstantMaximum(Texture bg, Texture bar, int field, int maxValue, Direction dir) {
        WBar result = new WBar(bg, bar, field, -1, dir);
        result.maxValue = maxValue;
        return result;
    }

    public static enum Direction {
        UP,
        RIGHT,
        DOWN,
        LEFT;

    }
}

