/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.client.NarrationMessages;
import io.github.cottonmc.cotton.gui.impl.client.WidgetTextures;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;

public class WButton
extends WWidget {
    private static final int ICON_SPACING = 2;
    @Nullable
    private Component label;
    protected int color = 0x404040;
    protected int iconSize = 16;
    private boolean enabled = true;
    protected HorizontalAlignment alignment = HorizontalAlignment.CENTER;
    @Nullable
    private Runnable onClick;
    @Nullable
    private Icon icon = null;

    public WButton() {
    }

    public WButton(@Nullable Icon icon) {
        this.icon = icon;
    }

    public WButton(@Nullable Component label) {
        this.label = label;
    }

    public WButton(@Nullable Icon icon, @Nullable Component label) {
        this.icon = icon;
        this.label = label;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(GuiGraphics context, int x, int y, int mouseX, int mouseY) {
        boolean hovered = this.isWithinBounds(mouseX, mouseY);
        WidgetSprites textures = WidgetTextures.getButtonTextures(this.shouldRenderInDarkMode());
        context.blitSprite(textures.get(this.enabled, hovered || this.isFocused()), x, y, this.getWidth(), this.getHeight());
        if (this.icon != null) {
            this.icon.paint(context, x + 2, y + (this.getHeight() - this.iconSize) / 2, this.iconSize);
        }
        if (this.label != null) {
            int color = 0xE0E0E0;
            if (!this.enabled) {
                color = 0xA0A0A0;
            }
            int xOffset = this.icon != null && this.alignment == HorizontalAlignment.LEFT ? 2 + this.iconSize + 2 : 0;
            ScreenDrawing.drawStringWithShadow(context, this.label.getVisualOrderText(), this.alignment, x + xOffset, y + (this.getHeight() - 8) / 2, this.width, color);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onClick(int x, int y, int button) {
        super.onClick(x, y, button);
        if (this.enabled && this.isWithinBounds(x, y)) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            if (this.onClick != null) {
                this.onClick.run();
            }
            return InputResult.PROCESSED;
        }
        return InputResult.IGNORED;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onKeyPressed(int ch, int key, int modifiers) {
        if (WButton.isActivationKey(ch)) {
            this.onClick(0, 0, 0);
            return InputResult.PROCESSED;
        }
        return InputResult.IGNORED;
    }

    @Nullable
    public Runnable getOnClick() {
        return this.onClick;
    }

    public WButton setOnClick(@Nullable Runnable onClick) {
        this.onClick = onClick;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public WButton setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    public Component getLabel() {
        return this.label;
    }

    public WButton setLabel(Component label) {
        this.label = label;
        return this;
    }

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public WButton setAlignment(HorizontalAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public WButton setIconSize(int iconSize) {
        this.iconSize = iconSize;
        return this;
    }

    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    public WButton setIcon(@Nullable Icon icon) {
        this.icon = icon;
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addNarrations(NarrationElementOutput builder) {
        builder.add(NarratedElementType.TITLE, (Component)AbstractWidget.wrapDefaultNarrationMessage((Component)this.getLabel()));
        if (this.isEnabled()) {
            if (this.isFocused()) {
                builder.add(NarratedElementType.USAGE, NarrationMessages.Vanilla.BUTTON_USAGE_FOCUSED);
            } else if (this.isHovered()) {
                builder.add(NarratedElementType.USAGE, NarrationMessages.Vanilla.BUTTON_USAGE_HOVERED);
            }
        }
    }
}

