/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class WItem
extends WWidget {
    private List<ItemStack> items;
    private int duration = 25;
    private int ticks = 0;
    private int current = 0;

    public WItem(List<ItemStack> items) {
        this.setItems(items);
    }

    public WItem(TagKey<? extends ItemLike> tag) {
        this(WItem.getRenderStacks(tag));
    }

    public WItem(ItemStack stack) {
        this(Collections.singletonList(stack));
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void tick() {
        if (this.ticks++ >= this.duration) {
            this.ticks = 0;
            this.current = (this.current + 1) % this.items.size();
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(GuiGraphics context, int x, int y, int mouseX, int mouseY) {
        RenderSystem.enableDepthTest();
        context.renderFakeItem(this.items.get(this.current), x + this.getWidth() / 2 - 8, y + this.getHeight() / 2 - 8);
    }

    public int getDuration() {
        return this.duration;
    }

    public WItem setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public WItem setItems(List<ItemStack> items) {
        Objects.requireNonNull(items, "stacks == null!");
        if (items.isEmpty()) {
            throw new IllegalArgumentException("The stack list is empty!");
        }
        this.items = items;
        this.current = 0;
        this.ticks = 0;
        return this;
    }

    private static List<ItemStack> getRenderStacks(TagKey<? extends ItemLike> tag) {
        Registry registry = (Registry)BuiltInRegistries.REGISTRY.get(tag.registry().location());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Holder item : registry.getOrCreateTag(tag)) {
            builder.add((Object)((ItemLike)item.value()).asItem().getDefaultInstance());
        }
        return builder.build();
    }
}

