/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.ValidatedSlot;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.impl.LibGuiCommon;
import io.github.cottonmc.cotton.gui.impl.VisualLogger;
import io.github.cottonmc.cotton.gui.impl.client.NarrationMessages;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.data.Rect2i;
import io.github.cottonmc.cotton.gui.widget.focus.Focus;
import io.github.cottonmc.cotton.gui.widget.focus.FocusModel;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class WItemSlot
extends WWidget {
    public static final ResourceLocation SLOT_TEXTURE = LibGuiCommon.id("textures/widget/item_slot.png");
    private static final VisualLogger LOGGER = new VisualLogger(WItemSlot.class);
    private final List<ValidatedSlot> peers = new ArrayList<ValidatedSlot>();
    @Nullable
    @Environment(value=EnvType.CLIENT)
    private BackgroundPainter backgroundPainter;
    @Nullable
    private Icon icon = null;
    private boolean iconOnlyPaintedForEmptySlots = false;
    private Container inventory;
    private int startIndex = 0;
    private int slotsWide = 1;
    private int slotsHigh = 1;
    private boolean big = false;
    private boolean insertingAllowed = true;
    private boolean takingAllowed = true;
    private int focusedSlot = -1;
    private int hoveredSlot = -1;
    private Predicate<ItemStack> inputFilter = ValidatedSlot.DEFAULT_ITEM_FILTER;
    private Predicate<ItemStack> outputFilter = ValidatedSlot.DEFAULT_ITEM_FILTER;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>();
    private final FocusModel<Integer> focusModel = new FocusModel<Integer>(){

        @Override
        public boolean isFocused(Focus<Integer> focus) {
            return WItemSlot.this.focusedSlot == focus.key();
        }

        @Override
        public void setFocused(Focus<Integer> focus) {
            WItemSlot.this.focusedSlot = focus.key();
        }

        @Override
        public Stream<Focus<Integer>> foci() {
            Stream.Builder<Focus<Integer>> builder = Stream.builder();
            int index = 0;
            for (int y = 0; y < WItemSlot.this.slotsHigh; ++y) {
                for (int x = 0; x < WItemSlot.this.slotsWide; ++x) {
                    int slotX = x * 18;
                    int slotY = y * 18;
                    int size = 18;
                    if (WItemSlot.this.big) {
                        slotX -= 4;
                        slotY -= 4;
                        size = 26;
                    }
                    builder.add(new Focus<Integer>(index, new Rect2i(slotX, slotY, size, size)));
                    ++index;
                }
            }
            return builder.build();
        }
    };

    public WItemSlot(Container inventory, int startIndex, int slotsWide, int slotsHigh, boolean big) {
        this();
        this.inventory = inventory;
        this.startIndex = startIndex;
        this.slotsWide = slotsWide;
        this.slotsHigh = slotsHigh;
        this.big = big;
    }

    private WItemSlot() {
        this.hoveredProperty().addListener((property, from, to) -> {
            assert (to != null);
            if (!to.booleanValue()) {
                this.hoveredSlot = -1;
            }
        });
    }

    public static WItemSlot of(Container inventory, int index) {
        WItemSlot w = new WItemSlot();
        w.inventory = inventory;
        w.startIndex = index;
        return w;
    }

    public static WItemSlot of(Container inventory, int startIndex, int slotsWide, int slotsHigh) {
        WItemSlot w = new WItemSlot();
        w.inventory = inventory;
        w.startIndex = startIndex;
        w.slotsWide = slotsWide;
        w.slotsHigh = slotsHigh;
        return w;
    }

    public static WItemSlot outputOf(Container inventory, int index) {
        WItemSlot w = new WItemSlot();
        w.inventory = inventory;
        w.startIndex = index;
        w.big = true;
        return w;
    }

    public static WItemSlot ofPlayerStorage(final Container inventory) {
        WItemSlot w = new WItemSlot(){

            @Override
            protected Component getNarrationName() {
                Component component;
                if (inventory instanceof Inventory) {
                    Inventory inv = (Inventory)inventory;
                    component = inv.getDisplayName();
                } else {
                    component = NarrationMessages.Vanilla.INVENTORY;
                }
                return component;
            }
        };
        w.inventory = inventory;
        w.startIndex = 9;
        w.slotsWide = 9;
        w.slotsHigh = 3;
        return w;
    }

    @Override
    public int getWidth() {
        return this.slotsWide * 18;
    }

    @Override
    public int getHeight() {
        return this.slotsHigh * 18;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    public boolean isBigSlot() {
        return this.big;
    }

    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    public WItemSlot setIcon(@Nullable Icon icon) {
        this.icon = icon;
        if (icon != null && this.slotsWide * this.slotsHigh > 1) {
            LOGGER.warn("Setting icon {} for item slot {} with more than 1 slot ({})", icon, this, this.slotsWide * this.slotsHigh);
        }
        return this;
    }

    public boolean isIconOnlyPaintedForEmptySlots() {
        return this.iconOnlyPaintedForEmptySlots;
    }

    public WItemSlot setIconOnlyPaintedForEmptySlots(boolean iconOnlyPaintedForEmptySlots) {
        this.iconOnlyPaintedForEmptySlots = iconOnlyPaintedForEmptySlots;
        return this;
    }

    public boolean isModifiable() {
        return this.takingAllowed || this.insertingAllowed;
    }

    public WItemSlot setModifiable(boolean modifiable) {
        this.insertingAllowed = modifiable;
        this.takingAllowed = modifiable;
        for (ValidatedSlot peer : this.peers) {
            peer.setInsertingAllowed(modifiable);
            peer.setTakingAllowed(modifiable);
        }
        return this;
    }

    public boolean isInsertingAllowed() {
        return this.insertingAllowed;
    }

    public WItemSlot setInsertingAllowed(boolean insertingAllowed) {
        this.insertingAllowed = insertingAllowed;
        for (ValidatedSlot peer : this.peers) {
            peer.setInsertingAllowed(insertingAllowed);
        }
        return this;
    }

    public boolean isTakingAllowed() {
        return this.takingAllowed;
    }

    public WItemSlot setTakingAllowed(boolean takingAllowed) {
        this.takingAllowed = takingAllowed;
        for (ValidatedSlot peer : this.peers) {
            peer.setTakingAllowed(takingAllowed);
        }
        return this;
    }

    public int getFocusedSlot() {
        return this.focusedSlot;
    }

    @Override
    public void validate(GuiDescription host) {
        super.validate(host);
        this.peers.clear();
        int index = this.startIndex;
        for (int y = 0; y < this.slotsHigh; ++y) {
            for (int x = 0; x < this.slotsWide; ++x) {
                ValidatedSlot slot = this.createSlotPeer(this.inventory, index, this.getAbsoluteX() + x * 18 + 1, this.getAbsoluteY() + y * 18 + 1);
                slot.setInsertingAllowed(this.insertingAllowed);
                slot.setTakingAllowed(this.takingAllowed);
                slot.setInputFilter(this.inputFilter);
                slot.setOutputFilter(this.outputFilter);
                for (ChangeListener listener : this.listeners) {
                    slot.addChangeListener(this, listener);
                }
                this.peers.add(slot);
                host.addSlotPeer(slot);
                ++index;
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onKeyPressed(int ch, int key, int modifiers) {
        GuiDescription guiDescription;
        if (WItemSlot.isActivationKey(ch) && (guiDescription = this.host) instanceof AbstractContainerMenu) {
            AbstractContainerMenu handler = (AbstractContainerMenu)guiDescription;
            if (this.focusedSlot >= 0) {
                Minecraft client = Minecraft.getInstance();
                ValidatedSlot peer = this.peers.get(this.focusedSlot);
                client.gameMode.handleInventoryMouseClick(handler.containerId, peer.index, 0, ClickType.PICKUP, (Player)client.player);
                return InputResult.PROCESSED;
            }
        }
        return InputResult.IGNORED;
    }

    protected ValidatedSlot createSlotPeer(Container inventory, int index, int x, int y) {
        return new ValidatedSlot(inventory, index, x, y);
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public BackgroundPainter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    @Environment(value=EnvType.CLIENT)
    public void setBackgroundPainter(@Nullable BackgroundPainter painter) {
        this.backgroundPainter = painter;
    }

    public Predicate<ItemStack> getInputFilter() {
        return this.inputFilter;
    }

    public WItemSlot setInputFilter(Predicate<ItemStack> inputFilter) {
        this.inputFilter = inputFilter;
        for (ValidatedSlot peer : this.peers) {
            peer.setInputFilter(inputFilter);
        }
        return this;
    }

    public Predicate<ItemStack> getOutputFilter() {
        return this.outputFilter;
    }

    public WItemSlot setOutputFilter(Predicate<ItemStack> outputFilter) {
        this.outputFilter = outputFilter;
        for (ValidatedSlot peer : this.peers) {
            peer.setOutputFilter(outputFilter);
        }
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(GuiGraphics context, int x, int y, int mouseX, int mouseY) {
        if (this.backgroundPainter != null) {
            this.backgroundPainter.paintBackground(context, x, y, this);
        }
        if (this.icon != null && (!this.iconOnlyPaintedForEmptySlots || this.inventory.getItem(this.startIndex).isEmpty())) {
            this.icon.paint(context, x + 1, y + 1, 16);
        }
    }

    @Override
    @Nullable
    public FocusModel<?> getFocusModel() {
        return this.focusModel;
    }

    @Override
    public void onFocusLost() {
        this.focusedSlot = -1;
    }

    public void addChangeListener(ChangeListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.listeners.add(listener);
        for (ValidatedSlot peer : this.peers) {
            peer.addChangeListener(this, listener);
        }
    }

    @Override
    public void onShown() {
        for (ValidatedSlot peer : this.peers) {
            peer.setVisible(true);
        }
    }

    @Override
    public InputResult onMouseMove(int x, int y) {
        int slotX = x / 18;
        int slotY = y / 18;
        this.hoveredSlot = slotX + slotY * this.slotsWide;
        return InputResult.PROCESSED;
    }

    @Override
    public void onHidden() {
        super.onHidden();
        for (ValidatedSlot peer : this.peers) {
            peer.setVisible(false);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addPainters() {
        this.backgroundPainter = BackgroundPainter.SLOT;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addNarrations(NarrationElementOutput builder) {
        ArrayList<Object> parts = new ArrayList<Object>();
        Component name = this.getNarrationName();
        if (name != null) {
            parts.add(name);
        }
        if (this.focusedSlot >= 0) {
            parts.add(Component.translatable((String)"widget.libgui.item_slot.narration.title", (Object[])new Object[]{this.focusedSlot + 1, this.slotsWide * this.slotsHigh}));
        } else if (this.hoveredSlot >= 0) {
            parts.add(Component.translatable((String)"widget.libgui.item_slot.narration.title", (Object[])new Object[]{this.hoveredSlot + 1, this.slotsWide * this.slotsHigh}));
        }
        builder.add(NarratedElementType.TITLE, parts.toArray(new Component[0]));
    }

    @Nullable
    protected Component getNarrationName() {
        return null;
    }

    @FunctionalInterface
    public static interface ChangeListener {
        public void onStackChanged(WItemSlot var1, Container var2, int var3, ItemStack var4);
    }
}

