/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.client.TextAlignment;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.data.VerticalAlignment;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;

public class WLabel
extends WWidget {
    protected Component text;
    protected HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    protected VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
    protected int color;
    protected int darkmodeColor;
    public static final int DEFAULT_TEXT_COLOR = 0x404040;
    public static final int DEFAULT_DARKMODE_TEXT_COLOR = 0xBCBCBC;

    public WLabel(Component text, int color) {
        this.text = text;
        this.color = color;
        this.darkmodeColor = color == 0x404040 ? 0xBCBCBC : color;
    }

    public WLabel(Component text) {
        this(text, 0x404040);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(GuiGraphics context, int x, int y, int mouseX, int mouseY) {
        int yOffset = TextAlignment.getTextOffsetY(this.verticalAlignment, this.height, 1);
        ScreenDrawing.drawString(context, this.text.getVisualOrderText(), this.horizontalAlignment, x, y + yOffset, this.getWidth(), this.shouldRenderInDarkMode() ? this.darkmodeColor : this.color);
        Style hoveredTextStyle = this.getTextStyleAt(mouseX, mouseY);
        ScreenDrawing.drawTextHover(context, hoveredTextStyle, x + mouseX, y + mouseY);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onClick(int x, int y, int button) {
        Screen screen;
        Style hoveredTextStyle = this.getTextStyleAt(x, y);
        if (hoveredTextStyle != null && (screen = Minecraft.getInstance().screen) != null) {
            return InputResult.of(screen.handleComponentClicked(hoveredTextStyle));
        }
        return InputResult.IGNORED;
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public Style getTextStyleAt(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            int xOffset = TextAlignment.getTextOffsetX(this.horizontalAlignment, this.width, this.text.getVisualOrderText());
            return Minecraft.getInstance().font.getSplitter().componentStyleAtWidth((FormattedText)this.text, x - xOffset);
        }
        return null;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, Math.max(8, y));
    }

    public int getDarkmodeColor() {
        return this.darkmodeColor;
    }

    public WLabel setDarkmodeColor(int color) {
        this.darkmodeColor = color;
        return this;
    }

    public WLabel disableDarkmode() {
        this.darkmodeColor = this.color;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public WLabel setColor(int color) {
        this.color = color;
        return this;
    }

    public WLabel setColor(int color, int darkmodeColor) {
        this.color = color;
        this.darkmodeColor = darkmodeColor;
        return this;
    }

    public Component getText() {
        return this.text;
    }

    public WLabel setText(Component text) {
        this.text = text;
        return this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public WLabel setHorizontalAlignment(HorizontalAlignment align) {
        this.horizontalAlignment = align;
        return this;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public WLabel setVerticalAlignment(VerticalAlignment align) {
        this.verticalAlignment = align;
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addNarrations(NarrationElementOutput builder) {
        builder.add(NarratedElementType.TITLE, this.text);
    }
}

