/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.client.NarrationMessages;
import io.github.cottonmc.cotton.gui.impl.client.WidgetTextures;
import io.github.cottonmc.cotton.gui.impl.mixin.client.SliderWidgetAccessor;
import io.github.cottonmc.cotton.gui.widget.WAbstractSlider;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class WLabeledSlider
extends WAbstractSlider {
    @Nullable
    private Component label = null;
    @Nullable
    private LabelUpdater labelUpdater = null;
    private HorizontalAlignment labelAlignment = HorizontalAlignment.CENTER;

    public WLabeledSlider(int min, int max) {
        this(min, max, Axis.HORIZONTAL);
    }

    public WLabeledSlider(int min, int max, Axis axis) {
        super(min, max, axis);
    }

    public WLabeledSlider(int min, int max, Axis axis, @Nullable Component label) {
        this(min, max, axis);
        this.label = label;
    }

    public WLabeledSlider(int min, int max, @Nullable Component label) {
        this(min, max);
        this.label = label;
    }

    @Nullable
    public Component getLabel() {
        return this.label;
    }

    public void setLabel(@Nullable Component label) {
        this.label = label;
    }

    @Override
    protected void onValueChanged(int value) {
        super.onValueChanged(value);
        if (this.labelUpdater != null) {
            this.label = this.labelUpdater.updateLabel(value);
        }
    }

    public HorizontalAlignment getLabelAlignment() {
        return this.labelAlignment;
    }

    public void setLabelAlignment(HorizontalAlignment labelAlignment) {
        this.labelAlignment = labelAlignment;
    }

    @Nullable
    public LabelUpdater getLabelUpdater() {
        return this.labelUpdater;
    }

    public void setLabelUpdater(@Nullable LabelUpdater labelUpdater) {
        this.labelUpdater = labelUpdater;
    }

    @Override
    protected int getThumbWidth() {
        return 8;
    }

    @Override
    protected boolean isMouseInsideBounds(int x, int y) {
        return x >= 0 && x <= this.width && y >= 0 && y <= this.height;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(GuiGraphics context, int x, int y, int mouseX, int mouseY) {
        int aHeight;
        int aWidth = this.axis == Axis.HORIZONTAL ? this.width : this.height;
        int n = aHeight = this.axis == Axis.HORIZONTAL ? this.height : this.width;
        int rotMouseX = this.axis == Axis.HORIZONTAL ? (this.direction == WAbstractSlider.Direction.LEFT ? this.width - mouseX : mouseX) : (this.direction == WAbstractSlider.Direction.UP ? this.height - mouseY : mouseY);
        int rotMouseY = this.axis == Axis.HORIZONTAL ? mouseY : mouseX;
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.translate((float)x, (float)y, 0.0f);
        if (this.axis == Axis.VERTICAL) {
            matrices.translate(0.0f, (float)this.height, 0.0f);
            matrices.mulPose(com.mojang.math.Axis.ZP.rotationDegrees(270.0f));
        }
        context.blitSprite(SliderWidgetAccessor.libgui$getTexture(), 0, 0, aWidth, aHeight);
        int thumbX = Math.round(this.coordToValueRatio * (float)(this.value - this.min));
        int thumbY = 0;
        int thumbWidth = this.getThumbWidth();
        int thumbHeight = aHeight;
        boolean hovering = rotMouseX >= thumbX && rotMouseX <= thumbX + thumbWidth && rotMouseY >= thumbY && rotMouseY <= thumbY + thumbHeight;
        WidgetSprites thumbTextures = WidgetTextures.getLabeledSliderHandleTextures(this.shouldRenderInDarkMode());
        ResourceLocation thumbTexture = thumbTextures.get(true, this.dragging || hovering);
        context.blitSprite(thumbTexture, thumbX, thumbY, thumbWidth, thumbHeight);
        if (this.label != null) {
            int color = this.isMouseInsideBounds(mouseX, mouseY) ? 0xFFFFA0 : 0xE0E0E0;
            ScreenDrawing.drawStringWithShadow(context, this.label.getVisualOrderText(), this.labelAlignment, 2, aHeight / 2 - 4, aWidth - 4, color);
        }
        matrices.popPose();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addNarrations(NarrationElementOutput builder) {
        if (this.getLabel() != null) {
            builder.add(NarratedElementType.TITLE, (Component)Component.translatable((String)"widget.libgui.labeled_slider.narration.title", (Object[])new Object[]{this.getLabel(), this.value, this.min, this.max}));
            builder.add(NarratedElementType.USAGE, NarrationMessages.SLIDER_USAGE);
        } else {
            super.addNarrations(builder);
        }
    }

    @FunctionalInterface
    public static interface LabelUpdater {
        public Component updateLabel(int var1);
    }
}

