/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;

public abstract class WPanel
extends WWidget {
    protected final List<WWidget> children = new WidgetList(this, new ArrayList<WWidget>());
    @Environment(value=EnvType.CLIENT)
    private BackgroundPainter backgroundPainter;

    public void remove(WWidget w) {
        this.children.remove(w);
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public WPanel setBackgroundPainter(BackgroundPainter painter) {
        this.backgroundPainter = painter;
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    public BackgroundPainter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    public void layout() {
        for (WWidget child : this.children) {
            if (child instanceof WPanel) {
                WPanel panel = (WPanel)child;
                panel.layout();
            }
            this.expandToFit(child);
        }
    }

    protected void expandToFit(WWidget w) {
        this.expandToFit(w, Insets.NONE);
    }

    protected void expandToFit(WWidget w, Insets insets) {
        int pushRight = w.getX() + w.getWidth() + insets.right();
        int pushDown = w.getY() + w.getHeight() + insets.bottom();
        this.setSize(Math.max(this.getWidth(), pushRight), Math.max(this.getHeight(), pushDown));
    }

    @Override
    public WWidget hit(int x, int y) {
        if (this.children.isEmpty()) {
            return this;
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            int wy;
            int wx;
            WWidget child = this.children.get(i);
            if (!child.isWithinBounds(wx = x - child.getX(), wy = y - child.getY())) continue;
            return child.hit(wx, wy);
        }
        return this;
    }

    @Override
    public void validate(GuiDescription c) {
        super.validate(c);
        this.layout();
        for (WWidget child : this.children) {
            child.validate(c);
        }
    }

    @Override
    public void setHost(GuiDescription host) {
        super.setHost(host);
        for (WWidget child : this.children) {
            child.setHost(host);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(GuiGraphics context, int x, int y, int mouseX, int mouseY) {
        if (this.backgroundPainter != null) {
            this.backgroundPainter.paintBackground(context, x, y, this);
        }
        for (WWidget child : this.children) {
            child.paint(context, x + child.getX(), y + child.getY(), mouseX - child.getX(), mouseY - child.getY());
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void tick() {
        for (WWidget child : this.children) {
            child.tick();
        }
    }

    @Override
    public void onShown() {
        for (WWidget child : this.children) {
            child.onShown();
        }
    }

    @Override
    public void onHidden() {
        super.onHidden();
        for (WWidget child : this.children) {
            child.onHidden();
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addPainters() {
        for (WWidget child : this.children) {
            child.addPainters();
        }
    }

    public final Stream<WWidget> streamChildren() {
        return this.children.stream();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {\n" + this.children.stream().map(Object::toString).map(x -> x + ",").flatMap(x -> Stream.of(x.split("\n")).filter(y -> !y.isEmpty()).map(y -> "\t" + y)).collect(Collectors.joining("\n")) + "\n}";
    }

    private static final class WidgetList
    extends AbstractList<WWidget> {
        private final WPanel owner;
        private final List<WWidget> backing;

        private WidgetList(WPanel owner, List<WWidget> backing) {
            this.owner = owner;
            this.backing = backing;
        }

        @Override
        public WWidget get(int index) {
            return this.backing.get(index);
        }

        private void checkWidget(WWidget widget) {
            if (widget == null) {
                throw new NullPointerException("Adding null widget to " + String.valueOf(this.owner));
            }
            int n = 0;
            WPanel parent = this.owner;
            while (parent != null) {
                if (widget == parent) {
                    if (n == 0) {
                        throw new IllegalArgumentException("Adding panel to itself: " + String.valueOf(widget));
                    }
                    throw new IllegalArgumentException("Adding level " + n + " parent recursively to " + String.valueOf(this.owner) + ": " + String.valueOf(widget));
                }
                parent = parent.getParent();
                ++n;
            }
        }

        @Override
        public WWidget set(int index, WWidget element) {
            this.checkWidget(element);
            return this.backing.set(index, element);
        }

        @Override
        public void add(int index, WWidget element) {
            this.checkWidget(element);
            this.backing.add(index, element);
        }

        @Override
        public WWidget remove(int index) {
            return this.backing.remove(index);
        }

        @Override
        public int size() {
            return this.backing.size();
        }
    }
}

