/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.impl.client.NarrationMessages;
import io.github.cottonmc.cotton.gui.widget.WItemSlot;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WPlainPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.Nullable;

public class WPlayerInvPanel
extends WPlainPanel {
    protected final WItemSlot inventory;
    protected final WItemSlot hotbar;
    @Nullable
    protected final WWidget label;

    public WPlayerInvPanel(Inventory playerInventory) {
        this(playerInventory, true);
    }

    public WPlayerInvPanel(Inventory playerInventory, boolean hasLabel) {
        this(playerInventory, hasLabel ? WPlayerInvPanel.createInventoryLabel(playerInventory) : null);
    }

    public WPlayerInvPanel(Inventory playerInventory, @Nullable WWidget label) {
        int y = 0;
        this.label = label;
        if (label != null) {
            this.add(label, 0, 0, label.getWidth(), label.getHeight());
            y += label.getHeight();
        }
        this.inventory = WItemSlot.ofPlayerStorage((Container)playerInventory);
        this.hotbar = new WItemSlot(this, (Container)playerInventory, 0, 9, 1, false){

            @Override
            protected Component getNarrationName() {
                return NarrationMessages.Vanilla.HOTBAR;
            }
        };
        this.add(this.inventory, 0, y);
        this.add(this.hotbar, 0, y + 58);
    }

    @Override
    public boolean canResize() {
        return false;
    }

    public static WLabel createInventoryLabel(Inventory playerInventory) {
        WLabel label = new WLabel(playerInventory.getDisplayName());
        label.setSize(162, 11);
        return label;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WPanel setBackgroundPainter(BackgroundPainter painter) {
        super.setBackgroundPainter(null);
        this.inventory.setBackgroundPainter(painter);
        this.hotbar.setBackgroundPainter(painter);
        return this;
    }

    @Override
    public void validate(GuiDescription c) {
        WWidget wWidget;
        super.validate(c);
        if (c != null && (wWidget = this.label) instanceof WLabel) {
            WLabel l = (WLabel)wWidget;
            l.setColor(c.getTitleColor());
        }
    }
}

