/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.cottonmc.cotton.gui.impl.LibGuiCommon;
import io.github.cottonmc.cotton.gui.impl.client.NarrationMessages;
import io.github.cottonmc.cotton.gui.impl.client.WidgetTextures;
import io.github.cottonmc.cotton.gui.widget.WAbstractSlider;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.resources.ResourceLocation;

public class WScrollBar
extends WWidget {
    private static final ResourceLocation FOCUS_TEXTURE = LibGuiCommon.id("widget/scroll_bar/focus");
    public static final int DEFAULT_SCROLLING_SPEED = 4;
    private int scrollingSpeed = 4;
    protected Axis axis = Axis.HORIZONTAL;
    protected int value;
    protected int maxValue = 100;
    protected int window = 16;
    protected int anchor = -1;
    protected int anchorValue = -1;
    protected boolean sliding = false;

    public WScrollBar() {
    }

    public WScrollBar(Axis axis) {
        this.axis = axis;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(GuiGraphics context, int x, int y, int mouseX, int mouseY) {
        PoseStack matrices = context.pose();
        boolean darkMode = this.shouldRenderInDarkMode();
        WidgetTextures.ScrollBarTextures textures = WidgetTextures.getScrollBarTextures(darkMode);
        context.blitSprite(textures.background(), x, y, this.getWidth(), this.getHeight());
        ResourceLocation thumbTexture = textures.thumb();
        if (this.maxValue <= 0) {
            return;
        }
        if (this.sliding) {
            thumbTexture = textures.thumbPressed();
        } else if (this.isWithinBounds(mouseX, mouseY)) {
            thumbTexture = textures.thumbHovered();
        }
        matrices.pushPose();
        if (this.axis == Axis.HORIZONTAL) {
            matrices.translate((float)(x + 1 + this.getHandlePosition()), (float)(y + 1), 0.0f);
            context.blitSprite(thumbTexture, 0, 0, this.getHandleSize(), this.getHeight() - 2);
            if (this.isFocused()) {
                context.blitSprite(FOCUS_TEXTURE, 0, 0, this.getHandleSize(), this.getHeight() - 2);
            }
        } else {
            matrices.translate((float)(x + 1), (float)(y + 1 + this.getHandlePosition()), 0.0f);
            context.blitSprite(thumbTexture, 0, 0, this.getWidth() - 2, this.getHandleSize());
            if (this.isFocused()) {
                context.blitSprite(FOCUS_TEXTURE, 0, 0, this.getWidth() - 2, this.getHandleSize());
            }
        }
        matrices.popPose();
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    public int getHandleSize() {
        int bar;
        float percentage = this.window >= this.maxValue ? 1.0f : (float)this.window / (float)this.maxValue;
        int result = (int)(percentage * (float)(bar = this.axis == Axis.HORIZONTAL ? this.width - 2 : this.height - 2));
        if (result < 6) {
            result = 6;
        }
        return result;
    }

    public int getMovableDistance() {
        int bar = this.axis == Axis.HORIZONTAL ? this.width - 2 : this.height - 2;
        return bar - this.getHandleSize();
    }

    public int pixelsToValues(int pixels) {
        int bar = this.getMovableDistance();
        float percent = (float)pixels / (float)bar;
        return (int)(percent * (float)(this.maxValue - this.window));
    }

    public int getHandlePosition() {
        float percent = (float)this.value / (float)Math.max(this.maxValue - this.window, 1);
        return (int)(percent * (float)this.getMovableDistance());
    }

    public int getMaxScrollValue() {
        return this.maxValue - this.window;
    }

    protected void adjustSlider(int x, int y) {
        int delta = 0;
        delta = this.axis == Axis.HORIZONTAL ? x - this.anchor : y - this.anchor;
        int valueDelta = this.pixelsToValues(delta);
        int valueNew = this.anchorValue + valueDelta;
        if (valueNew > this.getMaxScrollValue()) {
            valueNew = this.getMaxScrollValue();
        }
        if (valueNew < 0) {
            valueNew = 0;
        }
        this.value = valueNew;
    }

    @Override
    public InputResult onMouseDown(int x, int y, int button) {
        this.requestFocus();
        if (this.axis == Axis.HORIZONTAL) {
            this.anchor = x;
            this.anchorValue = this.value;
        } else {
            this.anchor = y;
            this.anchorValue = this.value;
        }
        this.sliding = true;
        return InputResult.PROCESSED;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onMouseDrag(int x, int y, int button, double deltaX, double deltaY) {
        this.adjustSlider(x, y);
        return InputResult.PROCESSED;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onMouseUp(int x, int y, int button) {
        this.anchor = -1;
        this.anchorValue = -1;
        this.sliding = false;
        return InputResult.PROCESSED;
    }

    @Override
    public InputResult onKeyPressed(int ch, int key, int modifiers) {
        WAbstractSlider.Direction direction;
        WAbstractSlider.Direction direction2 = direction = this.axis == Axis.HORIZONTAL ? WAbstractSlider.Direction.RIGHT : WAbstractSlider.Direction.DOWN;
        if (WAbstractSlider.isIncreasingKey(ch, direction)) {
            if (this.value < this.getMaxScrollValue()) {
                ++this.value;
            }
            return InputResult.PROCESSED;
        }
        if (WAbstractSlider.isDecreasingKey(ch, direction)) {
            if (this.value > 0) {
                --this.value;
            }
            return InputResult.PROCESSED;
        }
        return InputResult.IGNORED;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onMouseScroll(int x, int y, double horizontalAmount, double verticalAmount) {
        this.setValue(this.getValue() + (int)(horizontalAmount - verticalAmount) * this.scrollingSpeed);
        return InputResult.PROCESSED;
    }

    public int getValue() {
        return this.value;
    }

    public WScrollBar setValue(int value) {
        this.value = value;
        this.checkValue();
        return this;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public WScrollBar setMaxValue(int max) {
        this.maxValue = max;
        this.checkValue();
        return this;
    }

    public WScrollBar setScrollingSpeed(int scrollingSpeed) {
        if (scrollingSpeed < 0) {
            throw new IllegalArgumentException("Negative value for scrolling speed");
        }
        if (scrollingSpeed == 0) {
            throw new IllegalArgumentException("Zero value for scrolling speed");
        }
        this.scrollingSpeed = scrollingSpeed;
        return this;
    }

    public int getScrollingSpeed() {
        return this.scrollingSpeed;
    }

    public int getWindow() {
        return this.window;
    }

    public WScrollBar setWindow(int window) {
        this.window = window;
        return this;
    }

    protected void checkValue() {
        if (this.value > this.maxValue - this.window) {
            this.value = this.maxValue - this.window;
        }
        if (this.value < 0) {
            this.value = 0;
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addNarrations(NarrationElementOutput builder) {
        builder.add(NarratedElementType.TITLE, NarrationMessages.SCROLL_BAR_TITLE);
        builder.add(NarratedElementType.USAGE, NarrationMessages.SLIDER_USAGE);
    }
}

