/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.client.TextAlignment;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.data.VerticalAlignment;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class WText
extends WWidget {
    protected Component text;
    protected int color;
    protected int darkmodeColor;
    protected HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    protected VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
    @Environment(value=EnvType.CLIENT)
    private List<FormattedCharSequence> wrappedLines;
    private boolean wrappingScheduled = false;

    public WText(Component text) {
        this(text, 0x404040);
    }

    public WText(Component text, int color) {
        this.text = Objects.requireNonNull(text, "text must not be null");
        this.color = color;
        this.darkmodeColor = color == 0x404040 ? 0xBCBCBC : color;
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, y);
        this.wrappingScheduled = true;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    private void wrapLines() {
        Font font = Minecraft.getInstance().font;
        this.wrappedLines = font.split((FormattedText)this.text, this.width);
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public Style getTextStyleAt(int x, int y) {
        Font font = Minecraft.getInstance().font;
        int yOffset = TextAlignment.getTextOffsetY(this.verticalAlignment, this.height, this.wrappedLines.size());
        Objects.requireNonNull(font);
        int lineIndex = (y - yOffset) / 9;
        if (lineIndex >= 0 && lineIndex < this.wrappedLines.size()) {
            FormattedCharSequence line = this.wrappedLines.get(lineIndex);
            int xOffset = TextAlignment.getTextOffsetX(this.horizontalAlignment, this.width, line);
            return font.getSplitter().componentStyleAtWidth(line, x - xOffset);
        }
        return null;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(GuiGraphics context, int x, int y, int mouseX, int mouseY) {
        if (this.wrappedLines == null || this.wrappingScheduled) {
            this.wrapLines();
            this.wrappingScheduled = false;
        }
        Font font = Minecraft.getInstance().font;
        int yOffset = TextAlignment.getTextOffsetY(this.verticalAlignment, this.height, this.wrappedLines.size());
        for (int i = 0; i < this.wrappedLines.size(); ++i) {
            FormattedCharSequence line = this.wrappedLines.get(i);
            int c = this.shouldRenderInDarkMode() ? this.darkmodeColor : this.color;
            Objects.requireNonNull(font);
            ScreenDrawing.drawString(context, line, this.horizontalAlignment, x, y + yOffset + i * 9, this.width, c);
        }
        Style hoveredTextStyle = this.getTextStyleAt(mouseX, mouseY);
        ScreenDrawing.drawTextHover(context, hoveredTextStyle, x + mouseX, y + mouseY);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onClick(int x, int y, int button) {
        if (button != 0) {
            return InputResult.IGNORED;
        }
        Style hoveredTextStyle = this.getTextStyleAt(x, y);
        if (hoveredTextStyle != null) {
            boolean processed = Minecraft.getInstance().screen.handleComponentClicked(hoveredTextStyle);
            return InputResult.of(processed);
        }
        return InputResult.IGNORED;
    }

    public Component getText() {
        return this.text;
    }

    public WText setText(Component text) {
        Objects.requireNonNull(text, "text is null");
        this.text = text;
        this.wrappingScheduled = true;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public WText setColor(int color) {
        this.color = color;
        return this;
    }

    public int getDarkmodeColor() {
        return this.darkmodeColor;
    }

    public WText setDarkmodeColor(int darkmodeColor) {
        this.darkmodeColor = darkmodeColor;
        return this;
    }

    public WText setColor(int color, int darkmodeColor) {
        this.setColor(color);
        this.setDarkmodeColor(darkmodeColor);
        return this;
    }

    public WText disableDarkmode() {
        this.darkmodeColor = this.color;
        return this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public WText setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public WText setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addNarrations(NarrationElementOutput builder) {
        builder.add(NarratedElementType.TITLE, this.text);
    }
}

