/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class WTextField
extends WWidget {
    public static final int TEXT_PADDING_X = 4;
    public static final int TEXT_PADDING_Y = 6;
    public static final int CURSOR_PADDING_Y = 4;
    public static final int CURSOR_HEIGHT = 12;
    @Environment(value=EnvType.CLIENT)
    @Nullable
    private Font textRenderer;
    private String text = "";
    private int maxLength = 16;
    private boolean editable = true;
    private int tickCount = 0;
    private int disabledColor = 0x707070;
    private int enabledColor = 0xE0E0E0;
    private int suggestionColor = 0x808080;
    private static final int BACKGROUND_COLOR = -16777216;
    private static final int BORDER_COLOR_SELECTED = -96;
    private static final int BORDER_COLOR_UNSELECTED = -6250336;
    private static final int CURSOR_COLOR = -3092272;
    @Nullable
    private Component suggestion = null;
    private int scrollOffset = 0;
    private int cursor = 0;
    private int select = -1;
    private Consumer<String> onChanged;
    private Predicate<String> textPredicate;
    @Environment(value=EnvType.CLIENT)
    @Nullable
    private BackgroundPainter backgroundPainter;

    public WTextField() {
    }

    public WTextField(Component suggestion) {
        this.suggestion = suggestion;
    }

    public void setText(String s) {
        this.setTextWithResult(s);
    }

    private boolean setTextWithResult(String s) {
        if (this.textPredicate == null || this.textPredicate.test(s)) {
            String string = this.text = s.length() > this.maxLength ? s.substring(0, this.maxLength) : s;
            if (this.onChanged != null) {
                this.onChanged.accept(this.text);
            }
            this.cursor = this.clampCursor(this.cursor);
            return true;
        }
        return false;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        ++this.tickCount;
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, 20);
    }

    private int clampCursor(int cursor) {
        return Mth.clamp((int)cursor, (int)0, (int)this.text.length());
    }

    public void setCursorPos(int location) {
        this.cursor = this.clampCursor(location);
        this.scrollCursorIntoView();
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getCursor() {
        return this.cursor;
    }

    @Environment(value=EnvType.CLIENT)
    private Font getTextRenderer() {
        return this.textRenderer != null ? this.textRenderer : (this.textRenderer = Minecraft.getInstance().font);
    }

    @Environment(value=EnvType.CLIENT)
    public void scrollCursorIntoView() {
        Font font = this.getTextRenderer();
        if (this.scrollOffset > this.cursor) {
            this.scrollOffset = this.cursor;
        }
        if (this.scrollOffset < this.cursor && font.plainSubstrByWidth(this.text.substring(this.scrollOffset), this.width - 8).length() + this.scrollOffset < this.cursor) {
            this.scrollOffset = this.cursor;
        }
        this.checkScrollOffset();
    }

    @Environment(value=EnvType.CLIENT)
    private void checkScrollOffset() {
        int rightMostScrollOffset = this.text.length() - this.getTextRenderer().plainSubstrByWidth(this.text, this.width - 8, true).length();
        this.scrollOffset = Math.min(rightMostScrollOffset, this.scrollOffset);
    }

    @Nullable
    public String getSelection() {
        if (this.select < 0) {
            return null;
        }
        if (this.select == this.cursor) {
            return null;
        }
        if (this.select > this.text.length()) {
            this.select = this.text.length();
        }
        this.cursor = this.clampCursor(this.cursor);
        int start = Math.min(this.select, this.cursor);
        int end = Math.max(this.select, this.cursor);
        return this.text.substring(start, end);
    }

    public boolean isEditable() {
        return this.editable;
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderBox(GuiGraphics context, int x, int y) {
        int borderColor = this.isFocused() ? -96 : -6250336;
        ScreenDrawing.coloredRect(context, x - 1, y - 1, this.width + 2, this.height + 2, borderColor);
        ScreenDrawing.coloredRect(context, x, y, this.width, this.height, -16777216);
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderText(GuiGraphics context, int x, int y, String visibleText) {
        int textColor = this.editable ? this.enabledColor : this.disabledColor;
        context.drawString(this.getTextRenderer(), visibleText, x + 4, y + 6, textColor, true);
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderCursor(GuiGraphics context, int x, int y, String visibleText) {
        if (this.tickCount / 6 % 2 == 0) {
            return;
        }
        if (this.cursor < this.scrollOffset) {
            return;
        }
        if (this.cursor > this.scrollOffset + visibleText.length()) {
            return;
        }
        int cursorOffset = this.getTextRenderer().width(visibleText.substring(0, this.cursor - this.scrollOffset));
        ScreenDrawing.coloredRect(context, x + 4 + cursorOffset, y + 4, 1, 12, -3092272);
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderSuggestion(GuiGraphics context, int x, int y) {
        if (this.suggestion == null) {
            return;
        }
        context.drawString(this.getTextRenderer(), this.suggestion, x + 4, y + 6, this.suggestionColor, true);
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderSelection(GuiGraphics context, int x, int y, String visibleText) {
        if (this.select == this.cursor || this.select == -1) {
            return;
        }
        int textLength = visibleText.length();
        int left = Math.min(this.cursor, this.select);
        int right = Math.max(this.cursor, this.select);
        if (right < this.scrollOffset || left > this.scrollOffset + textLength) {
            return;
        }
        int normalizedLeft = Math.max(this.scrollOffset, left) - this.scrollOffset;
        int normalizedRight = Math.min(this.scrollOffset + textLength, right) - this.scrollOffset;
        Font font = this.getTextRenderer();
        int leftCaret = font.width(visibleText.substring(0, normalizedLeft));
        int selectionWidth = font.width(visibleText.substring(normalizedLeft, normalizedRight));
        this.invertedRect(context, x + 4 + leftCaret, y + 4, selectionWidth, 12);
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderTextField(GuiGraphics context, int x, int y) {
        this.checkScrollOffset();
        String visibleText = this.getTextRenderer().plainSubstrByWidth(this.text.substring(this.scrollOffset), this.width - 8);
        this.renderBox(context, x, y);
        this.renderText(context, x, y, visibleText);
        if (this.text.isEmpty() && !this.isFocused()) {
            this.renderSuggestion(context, x, y);
        }
        if (this.isFocused()) {
            this.renderCursor(context, x, y, visibleText);
        }
        this.renderSelection(context, x, y, visibleText);
    }

    @Environment(value=EnvType.CLIENT)
    private void invertedRect(GuiGraphics context, int x, int y, int width, int height) {
        Matrix4f model = context.pose().last().pose();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionShader);
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        buffer.addVertex(model, (float)x, (float)(y + height), 0.0f);
        buffer.addVertex(model, (float)(x + width), (float)(y + height), 0.0f);
        buffer.addVertex(model, (float)(x + width), (float)y, 0.0f);
        buffer.addVertex(model, (float)x, (float)y, 0.0f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableColorLogicOp();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public WTextField setTextPredicate(Predicate<String> predicate_1) {
        this.textPredicate = predicate_1;
        return this;
    }

    public WTextField setChangedListener(Consumer<String> listener) {
        this.onChanged = listener;
        return this;
    }

    public WTextField setMaxLength(int max) {
        this.maxLength = max;
        if (this.text.length() > max) {
            this.setText(this.text.substring(0, max));
        }
        return this;
    }

    public WTextField setEnabledColor(int col) {
        this.enabledColor = col;
        return this;
    }

    public WTextField setSuggestionColor(int suggestionColor) {
        this.suggestionColor = suggestionColor;
        return this;
    }

    public WTextField setDisabledColor(int col) {
        this.disabledColor = col;
        return this;
    }

    public WTextField setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    @Nullable
    public Component getSuggestion() {
        return this.suggestion;
    }

    public WTextField setSuggestion(@Nullable Component suggestion) {
        this.suggestion = suggestion;
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    public WTextField setBackgroundPainter(BackgroundPainter painter) {
        this.backgroundPainter = painter;
        return this;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    @Override
    public void onFocusGained() {
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(GuiGraphics context, int x, int y, int mouseX, int mouseY) {
        this.renderTextField(context, x, y);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onClick(int x, int y, int button) {
        this.requestFocus();
        this.cursor = this.getCaretPosition(x - 4);
        this.scrollCursorIntoView();
        return InputResult.PROCESSED;
    }

    @Environment(value=EnvType.CLIENT)
    public int getCaretPosition(int clickX) {
        if (clickX < 0) {
            return 0;
        }
        int lastPos = 0;
        this.checkScrollOffset();
        String string = this.text.substring(this.scrollOffset);
        Font font = this.getTextRenderer();
        for (int i = 0; i < string.length(); ++i) {
            int w = font.width("" + string.charAt(i));
            if (lastPos + w >= clickX && clickX - lastPos < w / 2) {
                return i + this.scrollOffset;
            }
            lastPos += w;
        }
        return string.length();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onCharTyped(char ch) {
        if (!this.isEditable()) {
            return InputResult.IGNORED;
        }
        this.insertText("" + ch);
        return InputResult.PROCESSED;
    }

    @Environment(value=EnvType.CLIENT)
    private void insertText(String toInsert) {
        String after;
        String before;
        if (this.select != -1 && this.select != this.cursor) {
            int left = Math.min(this.cursor, this.select);
            int right = Math.max(this.cursor, this.select);
            before = this.text.substring(0, left);
            after = this.text.substring(right);
        } else {
            before = this.text.substring(0, this.cursor);
            after = this.text.substring(this.cursor);
        }
        if (before.length() + after.length() + toInsert.length() > this.maxLength) {
            return;
        }
        if (this.setTextWithResult(before + toInsert + after)) {
            this.select = -1;
            this.cursor = (before + toInsert).length();
            this.scrollCursorIntoView();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void copySelection() {
        String selection = this.getSelection();
        if (selection != null) {
            Minecraft.getInstance().keyboardHandler.setClipboard(selection);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void paste() {
        String clip = Minecraft.getInstance().keyboardHandler.getClipboard();
        this.insertText(clip);
    }

    @Environment(value=EnvType.CLIENT)
    private void deleteSelection() {
        int left = Math.min(this.cursor, this.select);
        int right = Math.max(this.cursor, this.select);
        if (this.setTextWithResult(this.text.substring(0, left) + this.text.substring(right))) {
            this.select = -1;
            this.cursor = this.clampCursor(left);
            this.scrollCursorIntoView();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void delete(int modifiers, boolean backwards) {
        if (this.select == -1 || this.select == this.cursor) {
            this.select = this.skipCharacters((2 & modifiers) != 0, backwards ? -1 : 1);
        }
        this.deleteSelection();
    }

    @Environment(value=EnvType.CLIENT)
    private int skipCharacters(boolean skipMany, int direction) {
        if (direction != -1 && direction != 1) {
            return this.cursor;
        }
        int position = this.cursor;
        do {
            if ((position += direction) < 0) {
                return 0;
            }
            if (position > this.text.length()) {
                return this.text.length();
            }
            if (skipMany) continue;
            return position;
        } while (position >= this.text.length() || !Character.isWhitespace(this.text.charAt(position)));
        return position;
    }

    @Environment(value=EnvType.CLIENT)
    public void onDirectionalKey(int direction, int modifiers) {
        if ((1 & modifiers) != 0) {
            if (this.select == -1 || this.select == this.cursor) {
                this.select = this.cursor;
            }
            this.cursor = this.skipCharacters((2 & modifiers) != 0, direction);
        } else if (this.select != -1) {
            this.cursor = direction < 0 ? Math.min(this.cursor, this.select) : Math.max(this.cursor, this.select);
            this.select = -1;
        } else {
            this.cursor = this.skipCharacters((2 & modifiers) != 0, direction);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onKeyPressed(int ch, int key, int modifiers) {
        if (!this.isEditable()) {
            return InputResult.IGNORED;
        }
        if (Screen.isCopy((int)ch)) {
            this.copySelection();
            return InputResult.PROCESSED;
        }
        if (Screen.isPaste((int)ch)) {
            this.paste();
            return InputResult.PROCESSED;
        }
        if (Screen.isSelectAll((int)ch)) {
            this.select = 0;
            this.cursor = this.text.length();
            return InputResult.PROCESSED;
        }
        switch (ch) {
            case 261: {
                this.delete(modifiers, false);
                break;
            }
            case 259: {
                this.delete(modifiers, true);
                break;
            }
            case 263: {
                this.onDirectionalKey(-1, modifiers);
                break;
            }
            case 262: {
                this.onDirectionalKey(1, modifiers);
                break;
            }
            case 265: 
            case 268: {
                if ((1 & modifiers) == 0) {
                    this.select = -1;
                }
                this.cursor = 0;
                break;
            }
            case 264: 
            case 269: {
                if ((1 & modifiers) == 0) {
                    this.select = -1;
                }
                this.cursor = this.text.length();
                break;
            }
            default: {
                return InputResult.IGNORED;
            }
        }
        this.scrollCursorIntoView();
        return InputResult.PROCESSED;
    }

    @Override
    public void addNarrations(NarrationElementOutput builder) {
        builder.add(NarratedElementType.TITLE, (Component)Component.translatable((String)"widget.libgui.text_field.narration.title", (Object[])new Object[]{this.text}));
        if (this.suggestion != null) {
            builder.add(NarratedElementType.HINT, (Component)Component.translatable((String)"widget.libgui.text_field.narration.suggestion", (Object[])new Object[]{this.suggestion}));
        }
    }
}

