/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WSprite;
import io.github.cottonmc.cotton.gui.widget.data.Texture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class WTiledSprite
extends WSprite {
    private int tileWidth;
    private int tileHeight;

    public WTiledSprite(int tileWidth, int tileHeight, ResourceLocation image) {
        super(image);
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
    }

    public WTiledSprite(int tileWidth, int tileHeight, int frameTime, ResourceLocation ... frames) {
        super(frameTime, frames);
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
    }

    public WTiledSprite(int tileWidth, int tileHeight, Texture image) {
        super(image);
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
    }

    public WTiledSprite(int tileWidth, int tileHeight, int frameTime, Texture ... frames) {
        super(frameTime, frames);
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
    }

    public void setTileSize(int width, int height) {
        this.tileWidth = width;
        this.tileHeight = height;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public WTiledSprite setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
        return this;
    }

    public WTiledSprite setTileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paintFrame(GuiGraphics context, int x, int y, Texture texture) {
        for (int tileYOffset = 0; tileYOffset < this.height; tileYOffset += this.tileHeight) {
            for (int tileXOffset = 0; tileXOffset < this.width; tileXOffset += this.tileWidth) {
                ScreenDrawing.texturedRect(context, x + tileXOffset, y + tileYOffset, this.getTileWidth(), this.getTileHeight(), texture, this.tint);
            }
        }
    }
}

