/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.LibGuiCommon;
import io.github.cottonmc.cotton.gui.impl.client.NarrationMessages;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.data.Texture;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;

public class WToggleButton
extends WWidget {
    protected static final Texture DEFAULT_OFF_IMAGE = new Texture(LibGuiCommon.id("textures/widget/toggle_off.png"));
    protected static final Texture DEFAULT_ON_IMAGE = new Texture(LibGuiCommon.id("textures/widget/toggle_on.png"));
    protected static final Texture DEFAULT_FOCUS_IMAGE = new Texture(LibGuiCommon.id("textures/widget/toggle_focus.png"));
    protected Texture onImage;
    protected Texture offImage;
    protected Texture focusImage = DEFAULT_FOCUS_IMAGE;
    @Nullable
    protected Component label = null;
    protected boolean isOn = false;
    @Nullable
    protected Consumer<Boolean> onToggle = null;
    protected int color = 0x404040;
    protected int darkmodeColor = 0xBCBCBC;

    public WToggleButton() {
        this(DEFAULT_ON_IMAGE, DEFAULT_OFF_IMAGE);
    }

    public WToggleButton(Component label) {
        this(DEFAULT_ON_IMAGE, DEFAULT_OFF_IMAGE);
        this.label = label;
    }

    public WToggleButton(ResourceLocation onImage, ResourceLocation offImage) {
        this(new Texture(onImage), new Texture(offImage));
    }

    public WToggleButton(ResourceLocation onImage, ResourceLocation offImage, Component label) {
        this(new Texture(onImage), new Texture(offImage), label);
    }

    public WToggleButton(Texture onImage, Texture offImage) {
        this.onImage = onImage;
        this.offImage = offImage;
    }

    public WToggleButton(Texture onImage, Texture offImage, Component label) {
        this.onImage = onImage;
        this.offImage = offImage;
        this.label = label;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(GuiGraphics context, int x, int y, int mouseX, int mouseY) {
        ScreenDrawing.texturedRect(context, x, y, 18, 18, this.isOn ? this.onImage : this.offImage, -1);
        if (this.isFocused()) {
            ScreenDrawing.texturedRect(context, x, y, 18, 18, this.focusImage, -1);
        }
        if (this.label != null) {
            ScreenDrawing.drawString(context, this.label.getVisualOrderText(), x + 22, y + 6, this.shouldRenderInDarkMode() ? this.darkmodeColor : this.color);
        }
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onClick(int x, int y, int button) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        this.isOn = !this.isOn;
        this.onToggle(this.isOn);
        return InputResult.PROCESSED;
    }

    @Override
    public InputResult onKeyPressed(int ch, int key, int modifiers) {
        if (WToggleButton.isActivationKey(ch)) {
            this.onClick(0, 0, 0);
            return InputResult.PROCESSED;
        }
        return InputResult.IGNORED;
    }

    protected void onToggle(boolean on) {
        if (this.onToggle != null) {
            this.onToggle.accept(on);
        }
    }

    public boolean getToggle() {
        return this.isOn;
    }

    public void setToggle(boolean on) {
        this.isOn = on;
    }

    @Nullable
    public Consumer<Boolean> getOnToggle() {
        return this.onToggle;
    }

    public WToggleButton setOnToggle(@Nullable Consumer<Boolean> onToggle) {
        this.onToggle = onToggle;
        return this;
    }

    @Nullable
    public Component getLabel() {
        return this.label;
    }

    public WToggleButton setLabel(@Nullable Component label) {
        this.label = label;
        return this;
    }

    public WToggleButton setColor(int light, int dark) {
        this.color = light;
        this.darkmodeColor = dark;
        return this;
    }

    public Texture getOnImage() {
        return this.onImage;
    }

    public WToggleButton setOnImage(Texture onImage) {
        this.onImage = onImage;
        return this;
    }

    public Texture getOffImage() {
        return this.offImage;
    }

    public WToggleButton setOffImage(Texture offImage) {
        this.offImage = offImage;
        return this;
    }

    public Texture getFocusImage() {
        return this.focusImage;
    }

    public WToggleButton setFocusImage(Texture focusImage) {
        this.focusImage = focusImage;
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addNarrations(NarrationElementOutput builder) {
        Component onOff = this.isOn ? NarrationMessages.TOGGLE_BUTTON_ON : NarrationMessages.TOGGLE_BUTTON_OFF;
        MutableComponent title = this.label != null ? Component.translatable((String)"widget.libgui.toggle_button.narration.named", (Object[])new Object[]{this.label, onOff}) : Component.translatable((String)"widget.libgui.toggle_button.narration.unnamed", (Object[])new Object[]{onOff});
        builder.add(NarratedElementType.TITLE, (Component)title);
        if (this.isFocused()) {
            builder.add(NarratedElementType.USAGE, NarrationMessages.Vanilla.BUTTON_USAGE_FOCUSED);
        } else if (this.isHovered()) {
            builder.add(NarratedElementType.USAGE, NarrationMessages.Vanilla.BUTTON_USAGE_HOVERED);
        }
    }
}

