/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget.icon;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemIcon
implements Icon {
    private static final int GHOST_OVERLAY_COLOR = 0x30FFFFFF;
    private final ItemStack stack;
    private boolean ghost = false;

    public ItemIcon(ItemStack stack) {
        this.stack = Objects.requireNonNull(stack, "stack");
    }

    public ItemIcon(Item item) {
        this(Objects.requireNonNull(item, "item").getDefaultInstance());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(GuiGraphics context, int x, int y, int size) {
        float scale = size != 16 ? (float)size / 16.0f : 1.0f;
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.translate((float)x, (float)y, 0.0f);
        matrices.scale(scale, scale, 1.0f);
        context.renderFakeItem(this.stack, 0, 0);
        if (this.isGhost()) {
            context.fill(RenderType.guiGhostRecipeOverlay(), 0, 0, 16, 16, 0x30FFFFFF);
        }
        matrices.popPose();
    }

    public boolean isGhost() {
        return this.ghost;
    }

    public ItemIcon setGhost(boolean ghost) {
        this.ghost = ghost;
        return this;
    }
}

