/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.compat.create.CreateCompat;
import com.tiviacz.travelersbackpack.config.BackpackEffect;
import com.tiviacz.travelersbackpack.config.Cooldown;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import com.tiviacz.travelersbackpack.util.CooldownHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.EnderManAngerEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class BackpackAbilities {
    public static final BackpackAbilities ABILITIES = new BackpackAbilities();
    public final AttributeModifier NETHERITE_ARMOR_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"netherite_backpack_armor"), 4.0, AttributeModifier.Operation.ADD_VALUE);
    public final AttributeModifier DIAMOND_ARMOR_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"diamond_backpack_armor"), 3.0, AttributeModifier.Operation.ADD_VALUE);
    public final AttributeModifier IRON_ARMOR_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"iron_backpack_armor"), 2.0, AttributeModifier.Operation.ADD_VALUE);
    public final AttributeModifier GOLD_ARMOR_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"gold_backpack_armor"), 2.0, AttributeModifier.Operation.ADD_VALUE);
    public final AttributeModifier ENDERMAN_REACH_DISTANCE_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"enderman_backpack_reach"), 1.0, AttributeModifier.Operation.ADD_VALUE);
    public final AttributeModifier WARDEN_MAX_HEALTH_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"warden_backpack_max_health"), 4.0, AttributeModifier.Operation.ADD_VALUE);
    public final AttributeModifier FOX_MOVEMENT_SPEED_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"fox_movement_speed"), 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    public final AttributeModifier LUCK_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"emerald_backpack_luck"), 1.0, AttributeModifier.Operation.ADD_VALUE);
    private final TargetingConditions ocelotAbilityTargeting = TargetingConditions.forCombat().range(64.0);
    public static final List<Item> ALLOWED_ABILITIES = new ArrayList<Item>();
    public static final Multimap<Item, BackpackEffect> BACKPACK_EFFECTS = ArrayListMultimap.create();
    public static final Map<Item, Cooldown> COOLDOWNS = new HashMap<Item, Cooldown>();
    public static List<Item> ITEM_ABILITIES_LIST = new ArrayList<TravelersBackpackItem>(List.of((TravelersBackpackItem)((Object)ModItems.NETHERITE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.DIAMOND_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.GOLD_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.EMERALD_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.IRON_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.LAPIS_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.QUARTZ_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CAKE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CACTUS_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.HAY_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CREEPER_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.DRAGON_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.BLAZE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.GHAST_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.SPIDER_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.WITHER_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.WARDEN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.BAT_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.BEE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.OCELOT_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.COW_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CHICKEN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.SQUID_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.FOX_TRAVELERS_BACKPACK.get())));
    public static List<Item> ITEM_ABILITIES_REMOVAL_LIST = new ArrayList<TravelersBackpackItem>(List.of((TravelersBackpackItem)((Object)ModItems.NETHERITE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.DIAMOND_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.GOLD_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.IRON_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.EMERALD_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.WARDEN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.FOX_TRAVELERS_BACKPACK.get())));
    public static List<Item> BLOCK_ABILITIES_LIST = new ArrayList<TravelersBackpackItem>(List.of((TravelersBackpackItem)((Object)ModItems.REDSTONE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.BOOKSHELF_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.SPONGE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CACTUS_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.MELON_TRAVELERS_BACKPACK.get())));
    public static List<Item> CUSTOM_DESCRIPTIONS = new ArrayList<TravelersBackpackItem>(List.of((TravelersBackpackItem)((Object)ModItems.LAPIS_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.REDSTONE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.BOOKSHELF_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.SPONGE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CAKE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CACTUS_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.HAY_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.MELON_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CREEPER_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.BLAZE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.GHAST_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.SPIDER_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.WITHER_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.WARDEN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.BEE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.OCELOT_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.COW_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CHICKEN_TRAVELERS_BACKPACK.get())));

    public boolean abilityTick(@Nullable ItemStack backpack, @Nullable Player player) {
        boolean tickCooldown = false;
        if (backpack != null) {
            Item backpackItem = backpack.getItem();
            boolean effectHasCooldown = false;
            if (BackpackAbilities.getBackpackEffects().containsKey((Object)backpack.getItem())) {
                if (BackpackAbilities.getCooldowns().containsKey(backpack.getItem())) {
                    effectHasCooldown = true;
                }
                if (!effectHasCooldown) {
                    Collection backpackEffects = BackpackAbilities.getBackpackEffects().get((Object)backpackItem);
                    for (BackpackEffect backpackEffect : backpackEffects) {
                        if (backpack.getItem() == ModItems.SQUID_TRAVELERS_BACKPACK.asItem() && backpackEffect.effect() == MobEffects.NIGHT_VISION && !player.isInWater()) continue;
                        this.addTimedMobEffect(player, backpackEffect.effect(), backpackEffect.minDuration(), backpackEffect.maxDuration(), backpackEffect.amplifier(), false, false, false);
                    }
                } else {
                    if (!BackpackAbilities.hasCooldown(backpack)) {
                        Collection backpackEffects = BackpackAbilities.getBackpackEffects().get((Object)backpackItem);
                        for (BackpackEffect backpackEffect : backpackEffects) {
                            this.addTimedMobEffect(player, backpackEffect.effect(), backpackEffect.minDuration(), backpackEffect.maxDuration(), backpackEffect.amplifier(), false, false, false);
                        }
                        BackpackAbilities.setCooldown(AttachmentUtils.getBackpackWrapperArtificial(player), backpackItem);
                    }
                    tickCooldown = true;
                }
            }
            if (backpackItem == ModItems.NETHERITE_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, (Holder<Attribute>)Attributes.ARMOR, this.NETHERITE_ARMOR_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.DIAMOND_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, (Holder<Attribute>)Attributes.ARMOR, this.DIAMOND_ARMOR_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.GOLD_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, (Holder<Attribute>)Attributes.ARMOR, this.GOLD_ARMOR_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.EMERALD_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, (Holder<Attribute>)Attributes.LUCK, this.LUCK_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.IRON_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, (Holder<Attribute>)Attributes.ARMOR, this.IRON_ARMOR_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, (Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, this.ENDERMAN_REACH_DISTANCE_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.WARDEN_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, (Holder<Attribute>)Attributes.MAX_HEALTH, this.WARDEN_MAX_HEALTH_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, this.FOX_MOVEMENT_SPEED_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.CAKE_TRAVELERS_BACKPACK.get()) {
                this.cakeAbility(backpack, player);
                return true;
            }
            if (backpackItem == ModItems.CACTUS_TRAVELERS_BACKPACK.get()) {
                this.cactusAbilityEquipped(player, backpack);
                return false;
            }
            if (backpackItem == ModItems.CHICKEN_TRAVELERS_BACKPACK.get()) {
                this.chickenAbility(backpack, player, false);
                return true;
            }
            if (backpackItem == ModItems.CREEPER_TRAVELERS_BACKPACK.get()) {
                return true;
            }
            if (backpackItem == ModItems.BLAZE_TRAVELERS_BACKPACK.get()) {
                this.blazeAbility(player);
                return false;
            }
            if (backpackItem == ModItems.SPIDER_TRAVELERS_BACKPACK.get()) {
                this.spiderAbility(player);
                return false;
            }
            if (backpackItem == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
                this.ocelotAbility(player);
                return false;
            }
            if (backpackItem == ModItems.COW_TRAVELERS_BACKPACK.get()) {
                this.cowAbility(backpack, player);
                return true;
            }
            if (backpackItem == ModItems.WITHER_TRAVELERS_BACKPACK.get()) {
                BackpackAbilities.witherAbilityTick(player);
                return false;
            }
        }
        return tickCooldown;
    }

    public boolean abilityTickBlock(@Nullable BackpackBlockEntity blockEntity) {
        Item backpackItem;
        if (blockEntity.getWrapper() != null && (backpackItem = blockEntity.getWrapper().getBackpackStack().getItem()) == ModItems.CACTUS_TRAVELERS_BACKPACK.get()) {
            this.cactusAbilityBlockEntity(blockEntity.getWrapper(), blockEntity);
            return false;
        }
        return false;
    }

    public void abilityRemoval(@Nullable ItemStack stack, @Nullable Player player) {
        if (stack.getItem() == ModItems.NETHERITE_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, (Holder<Attribute>)Attributes.ARMOR, this.NETHERITE_ARMOR_MODIFIER);
        }
        if (stack.getItem() == ModItems.DIAMOND_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, (Holder<Attribute>)Attributes.ARMOR, this.DIAMOND_ARMOR_MODIFIER);
        }
        if (stack.getItem() == ModItems.IRON_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, (Holder<Attribute>)Attributes.ARMOR, this.IRON_ARMOR_MODIFIER);
        }
        if (stack.getItem() == ModItems.GOLD_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, (Holder<Attribute>)Attributes.ARMOR, this.GOLD_ARMOR_MODIFIER);
        }
        if (stack.getItem() == ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, (Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, this.ENDERMAN_REACH_DISTANCE_MODIFIER);
        }
        if (stack.getItem() == ModItems.WARDEN_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, (Holder<Attribute>)Attributes.MAX_HEALTH, this.WARDEN_MAX_HEALTH_MODIFIER);
        }
        if (stack.getItem() == ModItems.EMERALD_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, (Holder<Attribute>)Attributes.LUCK, this.LUCK_MODIFIER);
        }
        if (stack.getItem() == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, this.FOX_MOVEMENT_SPEED_MODIFIER);
        }
    }

    public void animateTick(BackpackBlockEntity backpackBlockEntity, BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (backpackBlockEntity.getWrapper() != null && backpackBlockEntity.getWrapper().isAbilityEnabled()) {
            Block block = stateIn.getBlock();
            if (block == ModBlocks.BOOKSHELF_TRAVELERS_BACKPACK.get()) {
                this.bookshelfAbility(null, backpackBlockEntity);
            }
            if (block == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
                this.spongeAbility(backpackBlockEntity);
            }
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeAbilityMultimap(ItemStack backpack) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        if (backpack.getItem() == ModItems.NETHERITE_TRAVELERS_BACKPACK.get()) {
            multimap.put((Object)Attributes.ARMOR, (Object)this.NETHERITE_ARMOR_MODIFIER);
            return multimap;
        }
        if (backpack.getItem() == ModItems.DIAMOND_TRAVELERS_BACKPACK.get()) {
            multimap.put((Object)Attributes.ARMOR, (Object)this.DIAMOND_ARMOR_MODIFIER);
            return multimap;
        }
        if (backpack.getItem() == ModItems.GOLD_TRAVELERS_BACKPACK.get()) {
            multimap.put((Object)Attributes.ARMOR, (Object)this.GOLD_ARMOR_MODIFIER);
            return multimap;
        }
        if (backpack.getItem() == ModItems.IRON_TRAVELERS_BACKPACK.get()) {
            multimap.put((Object)Attributes.ARMOR, (Object)this.IRON_ARMOR_MODIFIER);
            return multimap;
        }
        if (backpack.getItem() == ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()) {
            multimap.put((Object)Attributes.BLOCK_INTERACTION_RANGE, (Object)this.ENDERMAN_REACH_DISTANCE_MODIFIER);
            return multimap;
        }
        if (backpack.getItem() == ModItems.WARDEN_TRAVELERS_BACKPACK.get()) {
            multimap.put((Object)Attributes.MAX_HEALTH, (Object)this.WARDEN_MAX_HEALTH_MODIFIER);
            return multimap;
        }
        if (backpack.getItem() == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
            multimap.put((Object)Attributes.MOVEMENT_SPEED, (Object)this.FOX_MOVEMENT_SPEED_MODIFIER);
            return multimap;
        }
        if (backpack.getItem() == ModItems.EMERALD_TRAVELERS_BACKPACK.get()) {
            multimap.put((Object)Attributes.LUCK, (Object)this.LUCK_MODIFIER);
            return multimap;
        }
        return multimap;
    }

    public void attributeAbility(Player player, boolean isRemoval, Holder<Attribute> attribute, AttributeModifier modifier) {
        AttributeInstance armor = player.getAttribute(attribute);
        if (isRemoval && armor != null && armor.hasModifier(modifier.id())) {
            armor.removeModifier(modifier.id());
        }
        if (!isRemoval && armor != null && !armor.hasModifier(modifier.id())) {
            armor.addPermanentModifier(modifier);
        }
    }

    public void armorAbilityRemovals(Player player) {
        this.attributeAbility(player, true, (Holder<Attribute>)Attributes.ARMOR, this.NETHERITE_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (Holder<Attribute>)Attributes.ARMOR, this.DIAMOND_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (Holder<Attribute>)Attributes.ARMOR, this.IRON_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (Holder<Attribute>)Attributes.ARMOR, this.GOLD_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, this.ENDERMAN_REACH_DISTANCE_MODIFIER);
        this.attributeAbility(player, true, (Holder<Attribute>)Attributes.MAX_HEALTH, this.WARDEN_MAX_HEALTH_MODIFIER);
        this.attributeAbility(player, true, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, this.FOX_MOVEMENT_SPEED_MODIFIER);
        this.attributeAbility(player, true, (Holder<Attribute>)Attributes.LUCK, this.LUCK_MODIFIER);
    }

    public void lapisAbility(Player player, ExperienceOrb orb) {
        float random;
        if (ABILITIES.checkBackpack(player, (Item)ModItems.LAPIS_TRAVELERS_BACKPACK.get()) && (random = player.getRandom().nextFloat()) <= 0.15f) {
            if (random <= 0.025f) {
                BackpackAbilities.sendParticlesPacket((ParticleOptions)ParticleTypes.GLOW, player, 2);
            }
            orb.value *= 2;
        }
    }

    public void bookshelfAbility(@Nullable Player player, @Nullable BackpackBlockEntity backpackBlockEntity) {
        BlockPos enchanting = BackpackDeathHelper.findBlock3D(backpackBlockEntity.getLevel(), backpackBlockEntity.getBlockPos().getX(), backpackBlockEntity.getBlockPos().getY(), backpackBlockEntity.getBlockPos().getZ(), Blocks.ENCHANTING_TABLE, 2, 2);
        if (enchanting != null) {
            if (!backpackBlockEntity.getLevel().isEmptyBlock(new BlockPos((enchanting.getX() - backpackBlockEntity.getBlockPos().getX()) / 2 + backpackBlockEntity.getBlockPos().getX(), enchanting.getY(), (enchanting.getZ() - backpackBlockEntity.getBlockPos().getZ()) / 2 + backpackBlockEntity.getBlockPos().getZ()))) {
                return;
            }
            for (int o = 0; o < 4; ++o) {
                backpackBlockEntity.getLevel().addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)enchanting.getX() + 0.5, (double)enchanting.getY() + 2.0, (double)enchanting.getZ() + 0.5, (double)((float)(backpackBlockEntity.getBlockPos().getX() - enchanting.getX()) + backpackBlockEntity.getLevel().random.nextFloat()) - 0.5, (double)((float)(backpackBlockEntity.getBlockPos().getY() - enchanting.getY()) - backpackBlockEntity.getLevel().random.nextFloat() - 1.0f), (double)((float)(backpackBlockEntity.getBlockPos().getZ() - enchanting.getZ()) + backpackBlockEntity.getLevel().random.nextFloat()) - 0.5);
            }
        }
    }

    public void spongeAbility(BackpackBlockEntity backpackBlockEntity) {
        TanksUpgrade tanksUpgrade;
        if (backpackBlockEntity.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent() && !(tanksUpgrade = backpackBlockEntity.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).get()).getLeftTank().isEmpty() && !tanksUpgrade.getRightTank().isEmpty() && tanksUpgrade.getLeftTank().getFluid().getFluid().isSame((Fluid)Fluids.WATER) && tanksUpgrade.getRightTank().getFluid().getFluid().isSame((Fluid)Fluids.WATER) && tanksUpgrade.getLeftTank().getFluidAmount() == tanksUpgrade.getLeftTank().getCapacity() && tanksUpgrade.getRightTank().getFluidAmount() == tanksUpgrade.getRightTank().getCapacity()) {
            float f = backpackBlockEntity.getLevel().random.nextFloat() * (float)Math.PI * 2.0f;
            float f1 = backpackBlockEntity.getLevel().random.nextFloat() * 0.5f + 0.5f;
            float f2 = Mth.sin((float)f) * 0.5f * f1;
            float f3 = Mth.cos((float)f) * 0.5f * f1;
            backpackBlockEntity.getLevel().addParticle((ParticleOptions)ParticleTypes.SPLASH, (double)((float)backpackBlockEntity.getBlockPos().getX() + f2 + 0.5f), (double)((float)backpackBlockEntity.getBlockPos().getY() + backpackBlockEntity.getLevel().random.nextFloat()), (double)((float)backpackBlockEntity.getBlockPos().getZ() + f3 + 0.5f), (double)((float)Math.pow(2.0, (double)(backpackBlockEntity.getLevel().random.nextInt(169) - 12) / 12.0)) / 24.0, -1.0, 0.0);
        }
    }

    public void cakeAbility(ItemStack backpack, Player player) {
        if (!BackpackAbilities.hasCooldown(backpack)) {
            player.getFoodData().eat(20, 0.1f);
            player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200));
            player.level().playSound(null, player.blockPosition(), SoundEvents.GENERIC_EAT, SoundSource.AMBIENT, 0.6f, (player.level().random.nextFloat() - player.level().random.nextFloat()) * 0.3f + 1.0f);
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                for (int i = 0; i < 3; ++i) {
                    float f = server.random.nextFloat() * (float)Math.PI * 2.0f;
                    float f1 = server.random.nextFloat() * 0.5f + 0.5f;
                    float f2 = Mth.sin((float)f) * 0.5f * f1;
                    float f3 = Mth.cos((float)f) * 0.5f * f1;
                    server.sendParticles((ParticleOptions)ParticleTypes.HEART, player.position().x + (double)f2, player.getBoundingBox().minY + (double)player.level().random.nextFloat() + 0.5, player.position().z + (double)f3, 3, (double)((float)Math.pow(2.0, (double)(player.level().random.nextInt(169) - 12) / 12.0)) / 24.0, -1.0, 0.0, 0.0);
                }
            }
            if (BackpackAbilities.getCooldowns().containsKey(backpack.getItem())) {
                Cooldown config = BackpackAbilities.getCooldowns().get(backpack.getItem());
                backpack.set((DataComponentType)ModDataComponents.COOLDOWN.get(), (Object)CooldownHelper.createCooldown(config.minCooldown(), config.maxCooldown()));
            }
        }
    }

    public void chickenAbility(ItemStack backpack, Player player, boolean firstSwitch) {
        if (firstSwitch && !player.level().isClientSide && !BackpackAbilities.hasCooldown(backpack)) {
            BackpackWrapper wrapper = AttachmentUtils.getBackpackWrapperArtificial(player);
            BackpackAbilities.setCooldown(wrapper, wrapper.getBackpackStack().getItem());
            return;
        }
        if (!BackpackAbilities.hasCooldown(backpack)) {
            BackpackWrapper wrapper = AttachmentUtils.getBackpackWrapperArtificial(player);
            player.level().playSound(null, player.blockPosition(), SoundEvents.CHICKEN_EGG, SoundSource.AMBIENT, 1.0f, (player.level().random.nextFloat() - player.level().random.nextFloat()) * 0.3f + 1.0f);
            player.spawnAtLocation((ItemLike)Items.EGG);
            if (player.level().isClientSide) {
                return;
            }
            BackpackAbilities.setCooldown(wrapper, wrapper.getBackpackStack().getItem());
        }
    }

    public void cactusAbilityEquipped(@Nullable Player player, @Nullable ItemStack backpack) {
        BackpackWrapper wrapper;
        int gameTime = (int)player.level().getGameTime();
        int cooldown = (Integer)backpack.getOrDefault(ModDataComponents.COOLDOWN, (Object)0);
        if (cooldown >= 1000) {
            wrapper = AttachmentUtils.getBackpackWrapper(player, AttachmentUtils.UPGRADES_ONLY);
            if (wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                TanksUpgrade upgrade = wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get();
                FluidTank leftTank = upgrade.getLeftTank();
                FluidTank rightTank = upgrade.getRightTank();
                FluidStack water = new FluidStack((Fluid)Fluids.WATER, 1000);
                if (!player.level().isClientSide) {
                    leftTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                    rightTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                }
                if (player.level().isClientSide) {
                    return;
                }
                wrapper.setCooldown(0);
            } else {
                return;
            }
        }
        int drops = 0;
        if (gameTime % 100 == 0) {
            wrapper = AttachmentUtils.getBackpackWrapperArtificial(player);
            if (player.isInWater()) {
                drops += 50;
            }
            if (this.isUnderRain(player.blockPosition(), player.level())) {
                drops += 50;
            }
            int getCurrentDrops = wrapper.getCooldown();
            if (drops > 0) {
                if (player.level().isClientSide) {
                    return;
                }
                wrapper.setCooldown(getCurrentDrops + drops);
            }
        }
    }

    public void cactusAbilityBlockEntity(@Nullable BackpackWrapper wrapper, @Nullable BackpackBlockEntity blockEntity) {
        int cooldown = wrapper.getCooldown();
        if (cooldown >= 1000) {
            if (wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                TanksUpgrade upgrade = wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get();
                FluidTank leftTank = upgrade.getLeftTank();
                FluidTank rightTank = upgrade.getRightTank();
                FluidStack water = new FluidStack((Fluid)Fluids.WATER, 1000);
                leftTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                rightTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                wrapper.setCooldown(0);
            } else {
                return;
            }
        }
        int drops = 0;
        int gameTime = (int)blockEntity.getLevel().getGameTime();
        if (gameTime % 100 == 0) {
            if (this.isUnderRain(blockEntity.getBlockPos(), blockEntity.getLevel())) {
                drops += 50;
            }
            int getCurrentDrops = wrapper.getCooldown();
            if (drops > 0) {
                wrapper.setCooldown(getCurrentDrops + drops);
            }
        }
    }

    public static void melonAbility(BackpackBlockEntity backpackBlockEntity) {
        if (backpackBlockEntity.getWrapper().isAbilityEnabled() && backpackBlockEntity.getWrapper().getCooldown() <= 0) {
            Block.popResource((Level)backpackBlockEntity.getLevel(), (BlockPos)backpackBlockEntity.getBlockPos(), (ItemStack)new ItemStack((ItemLike)Items.MELON_SLICE, backpackBlockEntity.getLevel().random.nextInt(0, 3)));
            BackpackAbilities.setCooldown(backpackBlockEntity.getWrapper(), backpackBlockEntity.getWrapper().getBackpackStack().getItem());
        }
    }

    public static void pumpkinAbility(EnderManAngerEvent event) {
        if (ABILITIES.checkBackpack(event.getPlayer(), (Item)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get())) {
            event.setCanceled(true);
        }
    }

    public static boolean creeperAbility(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            BackpackWrapper wrapper = AttachmentUtils.getBackpackWrapperArtificial(player);
            if (player.isDeadOrDying() && wrapper != null && wrapper.getBackpackStack().getItem() == ModItems.CREEPER_TRAVELERS_BACKPACK.get() && wrapper.isAbilityEnabled() && wrapper.getCooldown() <= 0) {
                player.setHealth(1.0f);
                player.removeAllEffects();
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 450, 1));
                player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 0));
                player.level().explode((Entity)player, player.damageSources().playerAttack(player), null, player.getRandomX(0.5), player.getY(), player.getRandomZ(0.5), 3.0f, false, Level.ExplosionInteraction.NONE);
                player.level().playSound(null, player.blockPosition(), SoundEvents.CREEPER_PRIMED, SoundSource.AMBIENT, 1.2f, 0.5f);
                if (!player.level().isClientSide) {
                    BackpackAbilities.setCooldown(wrapper, wrapper.getBackpackStack().getItem());
                }
                event.setCanceled(true);
                return true;
            }
        }
        return false;
    }

    public void blazeAbility(Player player) {
        if (player.fallDistance >= 3.0f) {
            for (int i = 0; i < 4; ++i) {
                player.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, player.getRandomX(0.5), player.getRandomY(), player.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
            player.fallDistance = 0.0f;
        }
    }

    public static void blazeAbility(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile instanceof SmallFireball) {
            Player player;
            EntityHitResult result;
            Entity entity;
            SmallFireball fireball = (SmallFireball)projectile;
            if (event.getRayTraceResult().getType() == HitResult.Type.ENTITY && (entity = (result = (EntityHitResult)event.getRayTraceResult()).getEntity()) instanceof Player && ABILITIES.checkBackpack(player = (Player)entity, (Item)ModItems.BLAZE_TRAVELERS_BACKPACK.get())) {
                player.level().playSound(null, player.blockPosition(), SoundEvents.SHIELD_BLOCK, SoundSource.PLAYERS, 1.0f, 0.8f + player.level().random.nextFloat() * 0.4f);
                BackpackAbilities.sendParticlesPacket((ParticleOptions)ParticleTypes.FLAME, player, 3);
                fireball.discard();
                event.setCanceled(true);
            }
        }
    }

    public static void ghastAbility(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Ghast) {
            Player player;
            Ghast ghast = (Ghast)livingEntity;
            livingEntity = event.getOriginalAboutToBeSetTarget();
            if (livingEntity instanceof Player && ABILITIES.checkBackpack(player = (Player)livingEntity, (Item)ModItems.GHAST_TRAVELERS_BACKPACK.get()) && ghast.getLastHurtByMob() != player) {
                event.setCanceled(true);
            }
        }
    }

    public void spiderAbility(Player player) {
        if (player.horizontalCollision && !player.isInFluidType()) {
            if (player.isFallFlying()) {
                player.stopFallFlying();
            }
            if (!player.onGround() && player.isCrouching()) {
                player.setDeltaMovement(player.getDeltaMovement().x, 0.0, player.getDeltaMovement().z);
            } else {
                player.setDeltaMovement(player.getDeltaMovement().x, 0.2, player.getDeltaMovement().z);
                Level level = player.level();
                BlockState state = level.getBlockState(player.blockPosition().relative(player.getDirection()));
                if (state.getBlockHolder().getKey() != null && state.getBlockHolder().getKey().location().getNamespace().equals("create")) {
                    return;
                }
                player.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state).setPos(player.blockPosition()), player.getX() + (level.random.nextDouble() - 0.5) * (double)player.getDimensions(Pose.STANDING).width(), player.getY() + 0.1, player.getZ() + (level.random.nextDouble() - 0.5) * (double)player.getDimensions(Pose.STANDING).width(), 0.0, 1.5, 0.0);
            }
        }
    }

    public static void witherAbilityTick(Player player) {
        if (ABILITIES.checkBackpack(player, (Item)ModItems.WITHER_TRAVELERS_BACKPACK.get()) && player.hasEffect(MobEffects.WITHER)) {
            player.removeEffect(MobEffects.WITHER);
        }
    }

    public static void witherAbility(AttackEntityEvent event) {
        Entity entity;
        if (ABILITIES.checkBackpack(event.getEntity(), (Item)ModItems.WITHER_TRAVELERS_BACKPACK.get()) && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(MobEffects.WITHER, 60, 1));
        }
    }

    public static void wardenAbility(AttackEntityEvent event) {
        Entity entity;
        if (ABILITIES.checkBackpack(event.getEntity(), (Item)ModItems.WARDEN_TRAVELERS_BACKPACK.get()) && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 1));
        }
    }

    public static void beeAbility(AttackEntityEvent event) {
        if (ABILITIES.checkBackpack(event.getEntity(), (Item)ModItems.BEE_TRAVELERS_BACKPACK.get())) {
            if (TravelersBackpack.createLoaded && CreateCompat.isPackageEntity(event.getTarget())) {
                return;
            }
            DamageSource damageSource = event.getEntity().damageSources().sting((LivingEntity)event.getEntity());
            boolean flag = event.getTarget().hurt(damageSource, 1.0f);
            if (flag) {
                Level level = event.getEntity().level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)event.getTarget(), (DamageSource)damageSource);
                }
                if ((level = event.getTarget()) instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)level;
                    living.setStingerCount(living.getStingerCount() + 1);
                    living.addEffect(new MobEffectInstance(MobEffects.POISON, 80, 0), (Entity)event.getEntity());
                }
            }
        }
    }

    public void ocelotAbility(Player player) {
        if (player.level().getNearestEntity(Monster.class, this.ocelotAbilityTargeting, (LivingEntity)player, player.getX(), player.getY(), player.getZ(), player.getBoundingBox().inflate(6.0, 2.0, 6.0)) != null) {
            this.addTimedMobEffect(player, (Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, 20, 30, 0, false, false, false);
        }
    }

    public void cowAbility(ItemStack stack, Player player) {
        if (!player.getActiveEffects().isEmpty() && !BackpackAbilities.hasCooldown(stack) && player.getActiveEffects().stream().anyMatch(effect -> ((MobEffect)effect.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL)) {
            BackpackWrapper wrapper = AttachmentUtils.getBackpackWrapperArtificial(player);
            if (!player.level().isClientSide) {
                player.level().levelEvent(2007, player.blockPosition(), 0xFFFFFF);
                BackpackAbilities.setCooldown(wrapper, stack.getItem());
            }
            player.level().playSound(null, player.blockPosition(), SoundEvents.HONEYCOMB_WAX_ON, SoundSource.PLAYERS, 1.0f, player.getRandom().nextFloat() * 0.1f + 0.9f);
            this.removeAllNegativeEffects(player.level(), player);
        }
    }

    public boolean removeAllNegativeEffects(Level level, Player player) {
        if (level.isClientSide) {
            return false;
        }
        if (player.getActiveEffects().isEmpty()) {
            return false;
        }
        List<MobEffectInstance> negativeEffects = player.getActiveEffects().stream().filter(effect -> ((MobEffect)effect.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL).toList();
        for (MobEffectInstance instance : negativeEffects) {
            player.removeEffect(instance.getEffect());
        }
        return true;
    }

    private boolean isUnderRain(BlockPos pos, Level level) {
        return level.canSeeSky(pos) && level.isRaining();
    }

    public static boolean isAbilityEnabledInConfig(ItemStack stack) {
        return (Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get() != false && ALLOWED_ABILITIES.contains(stack.getItem());
    }

    public boolean checkBackpack(Player player, Item item) {
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue() || !ALLOWED_ABILITIES.contains(item)) {
            return false;
        }
        return AttachmentUtils.isWearingBackpack(player) && AttachmentUtils.getWearingBackpack(player).getItem() == item && (Boolean)AttachmentUtils.getWearingBackpack(player).getOrDefault(ModDataComponents.ABILITY_ENABLED, (Object)true) != false;
    }

    public void addTimedMobEffect(Player player, Holder<MobEffect> effect, int minDuration, int maxDuration, int amplifier, boolean ambient, boolean showParticle, boolean showIcon) {
        if (!player.hasEffect(effect)) {
            player.addEffect(new MobEffectInstance(effect, maxDuration, amplifier, ambient, showParticle, showIcon));
        } else if (player.hasEffect(effect) && player.getEffect(effect) != null && player.getEffect(effect).getDuration() <= minDuration) {
            player.addEffect(new MobEffectInstance(effect, maxDuration, amplifier, ambient, showParticle, showIcon));
        }
    }

    public static void sendParticlesPacket(ParticleOptions type, Player player, int count) {
        for (int i = 0; i < count; ++i) {
            double d0 = player.level().random.nextGaussian() * 0.02;
            double d1 = player.level().random.nextGaussian() * 0.02;
            double d2 = player.level().random.nextGaussian() * 0.02;
            Level level = player.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel server = (ServerLevel)level;
            server.sendParticles(type, player.getRandomX(1.0), player.getRandomY() + 0.5, player.getRandomZ(1.0), 1, d0, d1, d2, 0.0);
        }
    }

    public static boolean isOnList(List<Item> list, ItemStack stackToCheck) {
        return list.stream().anyMatch(s -> s == stackToCheck.getItem());
    }

    public static boolean hasCooldown(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.COOLDOWN, (Object)0) > 0;
    }

    public static void setCooldown(BackpackWrapper wrapper, Item item) {
        if (BackpackAbilities.getCooldowns().containsKey(item)) {
            Cooldown cooldown = BackpackAbilities.getCooldowns().get(item);
            wrapper.setCooldown(CooldownHelper.createCooldown(cooldown.minCooldown(), cooldown.maxCooldown()));
        }
    }

    public static Map<Item, Cooldown> getCooldowns() {
        return COOLDOWNS;
    }

    public static Multimap<Item, BackpackEffect> getBackpackEffects() {
        return BACKPACK_EFFECTS;
    }
}

