/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.compat.comforts.ComfortsCompat;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.components.StarterUpgrades;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModTags;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.items.upgrades.TanksUpgradeItem;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.block.Block;

public class ShapedBackpackRecipe
extends ShapedRecipe {
    public ShapedBackpackRecipe(String groupIn, CraftingBookCategory category, ShapedRecipePattern shapedRecipePattern, ItemStack recipeOutputIn, boolean pShowNotification) {
        super(groupIn, category, shapedRecipePattern, recipeOutputIn, pShowNotification);
    }

    public ItemStack assemble(CraftingInput pInput, HolderLookup.Provider pRegistries) {
        ItemStack output = this.getResultItem(pRegistries).copy();
        if (!output.isEmpty()) {
            boolean hasTanks = false;
            boolean customBackpack = false;
            for (int i = 0; i < pInput.size(); ++i) {
                ItemStack ingredient = pInput.getItem(i);
                if (ingredient.getItem() instanceof TravelersBackpackItem) {
                    output.applyComponents(ingredient.getComponentsPatch());
                    customBackpack = true;
                    break;
                }
                if (ingredient.is(ModTags.SLEEPING_BAGS)) {
                    int color = ShapedBackpackRecipe.getProperColor(ingredient.getItem());
                    output.set(ModDataComponents.SLEEPING_BAG_COLOR, (Object)color);
                }
                if (hasTanks || ingredient.getItem() != ModItems.BACKPACK_TANK.get()) continue;
                output.set(ModDataComponents.STARTER_UPGRADES, (Object)new StarterUpgrades(List.of(ModItems.TANKS_UPGRADE.toStack())));
                hasTanks = true;
            }
            if (!customBackpack) {
                output.set(ModDataComponents.STORAGE_SLOTS, (Object)Tiers.LEATHER.getStorageSlots());
                if (hasTanks) {
                    output.set(ModDataComponents.RENDER_INFO, (Object)TanksUpgradeItem.writeToRenderData());
                } else {
                    output.set(ModDataComponents.RENDER_INFO, (Object)RenderInfo.EMPTY);
                }
            }
        }
        return output;
    }

    public static int getProperColor(Item item) {
        BlockItem blockItem;
        Block block;
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof SleepingBagBlock) {
            SleepingBagBlock sleepingBagBlock = (SleepingBagBlock)block;
            return sleepingBagBlock.getColor().getId();
        }
        if (TravelersBackpack.comfortsLoaded) {
            return ComfortsCompat.getComfortsSleepingBagColor(item);
        }
        return DyeColor.RED.getId();
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return RecipeType.CRAFTING;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedBackpackRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<ShapedBackpackRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340778_ -> p_340778_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_311729_ -> p_311729_.getGroup()), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_311732_ -> p_311732_.category()), (App)ShapedRecipePattern.MAP_CODEC.forGetter(p_311733_ -> p_311733_.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_311730_ -> p_311730_.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(p_311731_ -> p_311731_.showNotification())).apply((Applicative)p_340778_, ShapedBackpackRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedBackpackRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ShapedBackpackRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapedBackpackRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapedBackpackRecipe fromNetwork(RegistryFriendlyByteBuf p_319998_) {
            String s = p_319998_.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)p_319998_.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern shapedrecipepattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)p_319998_);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)p_319998_);
            boolean flag = p_319998_.readBoolean();
            return new ShapedBackpackRecipe(s, craftingbookcategory, shapedrecipepattern, itemstack, flag);
        }

        private static void toNetwork(RegistryFriendlyByteBuf p_320738_, ShapedBackpackRecipe p_320586_) {
            p_320738_.writeUtf(p_320586_.getGroup());
            p_320738_.writeEnum((Enum)p_320586_.category());
            ShapedRecipePattern.STREAM_CODEC.encode((Object)p_320738_, (Object)p_320586_.pattern);
            ItemStack.STREAM_CODEC.encode((Object)p_320738_, (Object)p_320586_.result);
            p_320738_.writeBoolean(p_320586_.showNotification());
        }
    }
}

