/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.curios;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tiviacz.travelersbackpack.client.renderer.BackpackLayer;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class TravelersBackpackCurio
implements ICurio {
    public final ItemStack stack;

    public static void registerCurio(RegisterCapabilitiesEvent event) {
        ModItems.ITEMS.getEntries().stream().filter(holder -> holder.get() instanceof TravelersBackpackItem).forEach(holder -> {
            ItemLike[] itemLikeArray = new ItemLike[1];
            itemLikeArray[0] = () -> ((DeferredHolder)holder).get();
            event.registerItem(CuriosCapability.ITEM, (stack, context) -> new TravelersBackpackCurio((ItemStack)stack), itemLikeArray);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerCurioRenderer() {
        ModItems.ITEMS.getEntries().stream().filter(holder -> holder.get() instanceof TravelersBackpackItem).forEach(holder -> CuriosRendererRegistry.register((Item)((Item)holder.get()), Renderer::new));
    }

    public TravelersBackpackCurio(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean canEquip(SlotContext context) {
        return (Boolean)TravelersBackpackConfig.SERVER.backpackSettings.backSlotIntegration.get();
    }

    public boolean canEquipFromUse(SlotContext slotContext) {
        return false;
    }

    public void curioTick(SlotContext slotContext) {
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.backSlotIntegration.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            BackpackWrapper.tick(this.stack, player, true);
        }
    }

    @Nonnull
    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit) {
        return ICurio.DropRule.DEFAULT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Renderer
    implements ICurioRenderer {
        public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            LivingEntity livingEntity;
            if (stack.getItem() instanceof TravelersBackpackItem && (livingEntity = slotContext.entity()) instanceof Player) {
                Player player = (Player)livingEntity;
                livingEntity = renderLayerParent.getModel();
                if (livingEntity instanceof PlayerModel) {
                    PlayerModel playerModel = (PlayerModel)livingEntity;
                    BackpackLayer.renderBackpackLayer((HumanoidModel)playerModel, matrixStack, renderTypeBuffer, light, (LivingEntity)player, stack);
                }
            }
        }
    }
}

