/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.components.FluidTanksOld;
import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.components.Slots;
import com.tiviacz.travelersbackpack.components.StarterUpgrades;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.items.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import com.tiviacz.travelersbackpack.network.ClientboundSyncItemStackPacket;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class BackpackWrapper {
    public static final BackpackWrapper DUMMY = new BackpackWrapper(ModItems.STANDARD_TRAVELERS_BACKPACK.toStack(), 3, null, null, null);
    protected ItemStack stack;
    public final ItemStackHandler inventory;
    public final ItemStackHandler upgrades;
    public final ItemStackHandler tools;
    public ItemStackHandler upgradesTracker;
    private final UpgradeManager upgradeManager;
    private Player owner;
    public ArrayList<Player> playersUsing = new ArrayList();
    protected HolderLookup.Provider registriesAccess;
    protected Level level;
    private final int screenID;
    private int tanksCapacity = 0;
    public int index = -1;
    public int[] dataLoad = new int[]{1, 1, 1};
    public Runnable saveHandler = () -> {};
    public Runnable abilityHandler = () -> {};
    public BlockPos backpackPos;
    public static final int STORAGE_ID = 0;
    public static final int UPGRADES_ID = 1;
    public static final int TOOLS_ID = 2;

    public BackpackWrapper(ItemStack stack, int screenID, HolderLookup.Provider registriesAccess, @Nullable Player player, @Nullable Level level, int index) {
        this(stack, screenID, registriesAccess, player, level);
        this.index = index;
    }

    public BackpackWrapper(ItemStack stack, int screenID, HolderLookup.Provider registriesAccess, @Nullable Player player, @Nullable Level level) {
        this(stack, screenID, registriesAccess, player, level, new int[]{1, 1, 1});
    }

    public BackpackWrapper(ItemStack stack, int screenID, HolderLookup.Provider registriesAccess, @Nullable Player player, @Nullable Level level, int[] dataLoad) {
        StarterUpgrades upgrades;
        if (player != null) {
            this.playersUsing.add(player);
        }
        if (screenID == 2) {
            this.setBackpackOwner(player);
        }
        this.stack = stack;
        if (!BackpackWrapper.isSizeInitialized(stack)) {
            BackpackWrapper.initializeSize(stack);
        }
        int storageSlots = (Integer)stack.get(ModDataComponents.STORAGE_SLOTS);
        int upgradeSlots = (Integer)stack.get(ModDataComponents.UPGRADE_SLOTS);
        int toolSlots = (Integer)stack.get(ModDataComponents.TOOL_SLOTS);
        this.screenID = screenID;
        this.registriesAccess = registriesAccess;
        this.level = level;
        this.dataLoad = dataLoad;
        this.inventory = this.createHandler(storageSlots, 0);
        this.upgrades = this.createUpgradeHandler(upgradeSlots, 1);
        this.tools = this.createHandler(toolSlots, 2);
        this.upgradesTracker = new ItemStackHandler(this.upgrades.getSlots());
        if (registriesAccess != null) {
            this.loadHandlers();
        }
        this.setBackpackTankCapacity();
        this.upgradeManager = new UpgradeManager(this);
        if (!this.stack.has(ModDataComponents.RENDER_INFO)) {
            this.setRenderInfo(RenderInfo.EMPTY.compoundTag());
        }
        if (stack.has(ModDataComponents.STARTER_UPGRADES) && (upgrades = (StarterUpgrades)stack.get(ModDataComponents.STARTER_UPGRADES)) != null) {
            upgrades.upgrades().forEach(this::setStarterUpgrade);
            stack.remove(ModDataComponents.STARTER_UPGRADES);
        }
        if (stack.has(ModDataComponents.FLUID_TANKS)) {
            ItemStack oldTanks = ModItems.TANKS_UPGRADE.toStack();
            oldTanks.set(ModDataComponents.FLUIDS, (Object)new Fluids(((FluidTanksOld)stack.get(ModDataComponents.FLUID_TANKS)).leftFluidStack(), ((FluidTanksOld)stack.get(ModDataComponents.FLUID_TANKS)).rightFluidStack()));
            this.setStarterUpgrade(oldTanks);
            stack.remove(ModDataComponents.FLUID_TANKS);
        }
    }

    public void setBackpackStack(ItemStack backpack) {
        this.stack = backpack;
        this.getUpgradeManager().getUpgrade(TanksUpgrade.class).ifPresent(tanksUpgrade -> tanksUpgrade.syncClients(backpack));
    }

    public ItemStack getBackpackStack() {
        return this.stack;
    }

    public int getBackpackSlotIndex() {
        return this.index;
    }

    public void setBackpackOwner(Player player) {
        this.owner = player;
    }

    @Nullable
    public Player getBackpackOwner() {
        return this.owner;
    }

    public ArrayList<Player> getPlayersUsing() {
        return this.playersUsing;
    }

    public void addUser(Player player) {
        if (!this.playersUsing.contains(player)) {
            this.playersUsing.add(player);
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void loadHandler(DataComponentType<BackpackContainerContents> data, int defaultSize, ItemStackHandler ... handlers) {
        if (this.stack.has(data)) {
            BackpackContainerContents contents = (BackpackContainerContents)this.stack.get(data);
            if (contents.getItems().size() < defaultSize) {
                contents = this.expandContents(contents, defaultSize, this.stack, data);
            }
            for (ItemStackHandler handler : handlers) {
                handler.deserializeNBT(this.registriesAccess, contents.toNbt(this.registriesAccess));
            }
        }
    }

    public void loadHandlers() {
        if (this.dataLoad[0] == 1) {
            this.loadStorage();
        }
        if (this.dataLoad[1] == 1) {
            this.loadUpgrades();
        }
        if (this.dataLoad[2] == 1) {
            this.loadTools();
        }
    }

    public void loadStorage() {
        this.loadHandler((DataComponentType<BackpackContainerContents>)((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get()), this.getStorageSize(), this.inventory);
    }

    public void loadUpgrades() {
        this.loadHandler((DataComponentType<BackpackContainerContents>)((DataComponentType)ModDataComponents.UPGRADES.get()), this.getUpgradesSize(), this.upgrades, this.upgradesTracker);
    }

    public void loadTools() {
        this.loadHandler((DataComponentType<BackpackContainerContents>)((DataComponentType)ModDataComponents.TOOLS_CONTAINER.get()), this.getToolSize(), this.tools);
    }

    public void loadAdditionally(int type) {
        if (this.dataLoad[type] == 0) {
            if (type == 0) {
                this.loadStorage();
            }
            if (type == 1) {
                this.loadUpgrades();
            }
            if (type == 2) {
                this.loadTools();
            }
            this.dataLoad[type] = 1;
        }
    }

    public BackpackContainerContents expandContents(BackpackContainerContents contents, int size, ItemStack backpack, DataComponentType type) {
        if (contents.getItems().size() < size) {
            NonNullList<ItemStack> oldItems = contents.getItems();
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(Collections.nCopies(size, ItemStack.EMPTY));
            for (int i = 0; i < oldItems.size(); ++i) {
                if (((ItemStack)oldItems.get(i)).isEmpty()) continue;
                itemList.set(i, (ItemStack)oldItems.get(i));
            }
            BackpackContainerContents expandedContents = BackpackContainerContents.fromItems(size, itemList);
            backpack.set(type, (Object)expandedContents);
            return expandedContents;
        }
        return contents;
    }

    public void setStarterUpgrade(ItemStack upgrade) {
        if (this.level == null) {
            return;
        }
        if (upgrade.getItem().isEnabled(this.level.enabledFeatures())) {
            for (int i = 0; i < this.upgrades.getSlots(); ++i) {
                if (!this.upgrades.getStackInSlot(i).isEmpty()) continue;
                this.upgrades.setStackInSlot(i, upgrade);
                this.upgradesTracker.setStackInSlot(i, upgrade);
                if (!(upgrade.getItem() instanceof TanksUpgradeItem)) break;
                this.setRenderInfo(TanksUpgradeItem.writeToRenderData().compoundTag());
                break;
            }
        }
    }

    public int getStorageSize() {
        return (Integer)this.stack.getOrDefault(ModDataComponents.STORAGE_SLOTS, (Object)Tiers.LEATHER.getStorageSlots());
    }

    public int getUpgradesSize() {
        return (Integer)this.stack.getOrDefault(ModDataComponents.UPGRADE_SLOTS, (Object)Tiers.LEATHER.getUpgradeSlots());
    }

    public int getToolSize() {
        return (Integer)this.stack.getOrDefault(ModDataComponents.TOOL_SLOTS, (Object)Tiers.LEATHER.getToolSlots());
    }

    public ItemStackHandler getStorage() {
        return this.inventory;
    }

    public ItemStackHandler getUpgrades() {
        return this.upgrades;
    }

    public ItemStackHandler getTools() {
        return this.tools;
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public HolderLookup.Provider getRegistriesAccess() {
        return this.registriesAccess;
    }

    public List<Integer> getUnsortableSlots() {
        return ((Slots)this.stack.getOrDefault(ModDataComponents.SLOTS, (Object)Slots.EMPTY)).unsortables();
    }

    public List<Pair<Integer, Pair<ItemStack, Boolean>>> getMemorySlots() {
        return ((Slots)this.stack.getOrDefault(ModDataComponents.SLOTS, (Object)Slots.EMPTY)).memory();
    }

    public int getScreenID() {
        return this.screenID;
    }

    public Component getBackpackScreenTitle() {
        return this.stack.has(DataComponents.CUSTOM_NAME) ? (Component)this.stack.get(DataComponents.CUSTOM_NAME) : Component.translatable((String)"screen.travelersbackpack.title");
    }

    public void setUnsortableSlots(List<Integer> unsortables) {
        Slots old = (Slots)this.stack.getOrDefault(ModDataComponents.SLOTS, (Object)Slots.EMPTY);
        this.setData((DataComponentType)ModDataComponents.SLOTS.get(), Slots.updateUnsortables(old, unsortables));
    }

    public void setMemorySlots(List<Pair<Integer, Pair<ItemStack, Boolean>>> memory) {
        Slots old = (Slots)this.stack.getOrDefault(ModDataComponents.SLOTS, (Object)Slots.EMPTY);
        this.setData((DataComponentType)ModDataComponents.SLOTS.get(), Slots.updateMemory(old, memory));
    }

    public <T> void setDataAndSync(DataComponentType<T> dataComponentType, T value) {
        this.setData(dataComponentType, value);
        this.sendDataToClients(dataComponentType);
    }

    public <T> void setData(DataComponentType<T> dataComponentType, T value) {
        this.stack.set(dataComponentType, value);
        this.saveHandler.run();
        if (dataComponentType == ModDataComponents.ABILITY_ENABLED) {
            this.abilityHandler.run();
        }
    }

    public boolean showToolSlots() {
        return (Boolean)this.stack.getOrDefault(ModDataComponents.SHOW_TOOL_SLOTS, (Object)false);
    }

    public boolean showMoreButtons() {
        return (Boolean)this.stack.getOrDefault(ModDataComponents.SHOW_MORE_BUTTONS, (Object)false);
    }

    public boolean tanksVisible() {
        if (this.stack.has(ModDataComponents.RENDER_INFO)) {
            return ((RenderInfo)this.stack.get(ModDataComponents.RENDER_INFO)).hasTanks();
        }
        return this.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent();
    }

    public int getBackpackTankCapacity() {
        return this.tanksCapacity;
    }

    public void setBackpackPos(BlockPos pos) {
        this.backpackPos = pos;
    }

    public BlockPos getBackpackPos() {
        return this.backpackPos;
    }

    public void setBackpackTankCapacity() {
        int rows = this.getRows() + (this.isExtended() ? 2 : 0);
        this.tanksCapacity = Tiers.of((Integer)this.stack.getOrDefault(ModDataComponents.TIER, (Object)0)).getTankCapacityPerRow() * rows;
    }

    public RenderInfo getRenderInfo() {
        return (RenderInfo)this.stack.getOrDefault(ModDataComponents.RENDER_INFO, (Object)RenderInfo.EMPTY);
    }

    public void setRenderInfo(CompoundTag compound) {
        this.setDataAndSync((DataComponentType)ModDataComponents.RENDER_INFO.get(), new RenderInfo(compound));
    }

    public void removeRenderInfo() {
        this.setRenderInfo(new CompoundTag());
    }

    public boolean isAbilityEnabled() {
        return (Boolean)this.stack.getOrDefault(ModDataComponents.ABILITY_ENABLED, (Object)((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.forceAbilityEnabled.get()));
    }

    public boolean hasSleepingBag() {
        return this.stack.has(ModDataComponents.SLEEPING_BAG_COLOR);
    }

    public int getSleepingBagColor() {
        return (Integer)this.stack.getOrDefault(ModDataComponents.SLEEPING_BAG_COLOR, (Object)-1);
    }

    public void setSleepingBagColor(int colorId) {
        this.setData((DataComponentType)ModDataComponents.SLEEPING_BAG_COLOR.get(), colorId);
    }

    public boolean isOwner(Player player) {
        if (this.getBackpackOwner() != null) {
            return this.getBackpackOwner().getId() == player.getId();
        }
        return true;
    }

    public boolean isDyed() {
        return this.stack.has(DataComponents.DYED_COLOR);
    }

    public int getDyeColor() {
        return ((DyedItemColor)this.stack.getOrDefault(DataComponents.DYED_COLOR, (Object)new DyedItemColor(-1, false))).rgb();
    }

    public int getCooldown() {
        return (Integer)this.stack.getOrDefault(ModDataComponents.COOLDOWN, (Object)0);
    }

    public void setCooldown(int cooldownInSeconds) {
        this.setDataAndSync((DataComponentType)ModDataComponents.COOLDOWN.get(), cooldownInSeconds);
    }

    public void decreaseCooldown() {
        if (this.getCooldown() > 0) {
            this.stack.update(ModDataComponents.COOLDOWN, (Object)0, currentCooldown -> currentCooldown - 1);
            this.saveHandler.run();
        }
    }

    public boolean canUpgradeTick() {
        return this.stack.has(ModDataComponents.UPGRADE_TICK_INTERVAL);
    }

    public boolean hasTickingUpgrade() {
        return this.upgradeManager.hasTickingUpgrade();
    }

    public int getUpgradeTickInterval() {
        return (Integer)this.stack.getOrDefault(ModDataComponents.UPGRADE_TICK_INTERVAL, (Object)100);
    }

    public void setUpgradeTickInterval(int ticks) {
        this.setDataAndSync((DataComponentType)ModDataComponents.UPGRADE_TICK_INTERVAL.get(), ticks);
    }

    public void removeUpgradeTickInterval() {
        this.stack.remove(ModDataComponents.UPGRADE_TICK_INTERVAL);
    }

    public boolean isExtended() {
        return this.getStorageSize() > 81;
    }

    public int getSlotsInRow() {
        if (this.isExtended()) {
            return 11;
        }
        return 9;
    }

    public int getRows() {
        return (int)Math.ceil((double)this.getStorageSize() / (double)this.getSlotsInRow());
    }

    public void sendDataToClients(DataComponentType ... dataComponentTypes) {
        if (this.getScreenID() == 3) {
            return;
        }
        if (this.getScreenID() == 1 && !this.getPlayersUsing().stream().filter(p -> !p.level().isClientSide).toList().isEmpty()) {
            int slotIndex = this.index == -1 ? this.getPlayersUsing().get((int)0).getInventory().selected : this.index;
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.getPlayersUsing().get(0)), (CustomPacketPayload)new ClientboundSyncItemStackPacket(this.getPlayersUsing().get(0).getId(), slotIndex, this.getBackpackStack(), ItemStackUtils.createDataComponentMap(this.getBackpackStack(), dataComponentTypes)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        if (TravelersBackpack.enableIntegration()) {
            if (this.getScreenID() == 2 && !this.getPlayersUsing().stream().filter(p -> !p.level().isClientSide).toList().isEmpty()) {
                for (Player player : this.getPlayersUsing()) {
                    if (((ServerPlayer)player).connection == null) continue;
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ClientboundSyncItemStackPacket(player.getId(), -1, this.getBackpackStack(), ItemStackUtils.createDataComponentMap(this.getBackpackStack(), dataComponentTypes)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            return;
        }
        if (this.getBackpackOwner() != null) {
            DataComponentMap.Builder mapBuilder = DataComponentMap.builder();
            ItemStack serverDataHolder = AttachmentUtils.getWearingBackpack(this.getBackpackOwner()).copy();
            for (DataComponentType type : dataComponentTypes) {
                ItemStack serverDataHolderCopy = ItemStackUtils.reduceSize(serverDataHolder);
                if (!serverDataHolderCopy.has(type)) continue;
                mapBuilder.set(type, serverDataHolderCopy.get(type));
            }
            Player player = this.getBackpackOwner();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (serverPlayer.connection == null) {
                    return;
                }
            }
            AttachmentUtils.getAttachment(this.getBackpackOwner()).ifPresent(data -> data.synchronise(mapBuilder.build()));
        }
    }

    public Optional<Pair<Integer, Pair<ItemStack, Boolean>>> getMemorizedSlot(int slot) {
        return this.getMemorySlots().stream().filter(pair -> (Integer)pair.getFirst() == slot).findFirst();
    }

    private ItemStackHandler createHandler(int size, final int dataId) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                BackpackWrapper.this.setSlotChanged(slot, this.getStackInSlot(slot), dataId);
                if (dataId == 2) {
                    BackpackWrapper.this.sendDataToClients((DataComponentType)ModDataComponents.TOOLS_CONTAINER.get());
                }
                BackpackWrapper.this.saveHandler.run();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (dataId == 2) {
                    return ToolSlotItemHandler.isValid(stack);
                }
                return BackpackSlotItemHandler.isItemValid(stack);
            }

            public int getSlotLimit(int slot) {
                return 8192;
            }
        };
    }

    public void setSlotChanged(int index, ItemStack stack, int dataId) {
        switch (dataId) {
            case 0: {
                this.stack.update(ModDataComponents.BACKPACK_CONTAINER, (Object)new BackpackContainerContents(this.getStorage().getSlots()), (Object)new BackpackContainerContents.Slot(index, stack), BackpackContainerContents::updateSlot);
                break;
            }
            case 1: {
                this.stack.update(ModDataComponents.UPGRADES, (Object)new BackpackContainerContents(this.getUpgrades().getSlots()), (Object)new BackpackContainerContents.Slot(index, stack), BackpackContainerContents::updateSlot);
                break;
            }
            case 2: {
                this.stack.update(ModDataComponents.TOOLS_CONTAINER, (Object)new BackpackContainerContents(this.getTools().getSlots()), (Object)new BackpackContainerContents.Slot(index, stack), BackpackContainerContents::updateSlot);
            }
        }
    }

    public void applyLowestTickInterval() {
        int minimalTickInterval = 100;
        for (int i = 0; i < this.upgrades.getSlots(); ++i) {
            ItemStack upgrade = this.upgrades.getStackInSlot(i);
            if (upgrade.isEmpty() || !((Boolean)upgrade.getOrDefault(ModDataComponents.UPGRADE_ENABLED, (Object)true)).booleanValue() || !upgrade.has(ModDataComponents.COOLDOWN)) continue;
            minimalTickInterval = Math.min(minimalTickInterval, (Integer)upgrade.get(ModDataComponents.COOLDOWN));
        }
        if (!this.canUpgradeTick() || minimalTickInterval != this.getUpgradeTickInterval()) {
            this.setUpgradeTickInterval(minimalTickInterval);
        }
    }

    public void updateMinimalTickInterval(ItemStack newStack) {
        if (this.level != null && this.level.isClientSide) {
            return;
        }
        boolean applyLowestTickInterval = false;
        Item item = newStack.getItem();
        if (item instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)item;
            if (upgradeItem.isTickingUpgrade()) {
                if (((Boolean)newStack.getOrDefault(ModDataComponents.UPGRADE_ENABLED, (Object)true)).booleanValue()) {
                    int tickInterval = this.getUpgradeTickInterval();
                    if (newStack.has(ModDataComponents.COOLDOWN)) {
                        tickInterval = (Integer)newStack.get(ModDataComponents.COOLDOWN);
                    }
                    if (!this.canUpgradeTick() || tickInterval < this.getUpgradeTickInterval()) {
                        this.setUpgradeTickInterval(tickInterval);
                    } else if (tickInterval > this.getUpgradeTickInterval()) {
                        applyLowestTickInterval = true;
                    }
                } else {
                    applyLowestTickInterval = true;
                }
            }
        } else {
            applyLowestTickInterval = true;
        }
        if (this.canUpgradeTick()) {
            if (!this.hasTickingUpgrade()) {
                this.removeUpgradeTickInterval();
            } else if (applyLowestTickInterval) {
                this.applyLowestTickInterval();
            }
        }
    }

    private ItemStackHandler createUpgradeHandler(int size, final int dataId) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                BackpackWrapper.this.setSlotChanged(slot, this.getStackInSlot(slot), dataId);
                if (!BackpackWrapper.this.getPlayersUsing().isEmpty()) {
                    BackpackWrapper.this.getUpgradeManager().detectedChange(BackpackWrapper.this.upgradesTracker, slot);
                }
                BackpackWrapper.this.updateMinimalTickInterval(this.getStackInSlot(slot));
                BackpackWrapper.this.saveHandler.run();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                boolean isValid = true;
                for (int i = 0; i < this.getSlots(); ++i) {
                    if (this.getStackInSlot(i).getItem() != stack.getItem()) continue;
                    isValid = false;
                    break;
                }
                if (!isValid) {
                    return false;
                }
                if (stack.getItem() instanceof TanksUpgradeItem) {
                    isValid = TanksUpgradeItem.canBePutInBackpack(BackpackWrapper.this.getBackpackTankCapacity(), stack);
                }
                if (!this.checkIfUpgradeValid(stack)) {
                    isValid = false;
                }
                return isValid;
            }

            public boolean checkIfUpgradeValid(ItemStack upgradeStack) {
                Item item = upgradeStack.getItem();
                if (item instanceof UpgradeItem) {
                    Player player;
                    UpgradeItem upgradeItem = (UpgradeItem)item;
                    Player player2 = player = BackpackWrapper.this.getPlayersUsing().isEmpty() ? null : BackpackWrapper.this.getPlayersUsing().getFirst();
                    if (player == null) {
                        return false;
                    }
                    return upgradeItem.isEnabled(player.level().enabledFeatures());
                }
                return false;
            }
        };
    }

    public static boolean isSizeInitialized(ItemStack stack) {
        return stack.has(ModDataComponents.STORAGE_SLOTS) && stack.has(ModDataComponents.UPGRADE_SLOTS) && stack.has(ModDataComponents.TOOL_SLOTS);
    }

    public static void initializeSize(ItemStack stack) {
        Tiers.Tier tier = Tiers.LEATHER;
        if (stack.has(ModDataComponents.TIER)) {
            tier = Tiers.of((Integer)stack.get(ModDataComponents.TIER));
        }
        if (!stack.has(ModDataComponents.STORAGE_SLOTS)) {
            stack.set((DataComponentType)ModDataComponents.STORAGE_SLOTS.get(), (Object)tier.getStorageSlots());
        }
        if (!stack.has(ModDataComponents.UPGRADE_SLOTS)) {
            stack.set((DataComponentType)ModDataComponents.UPGRADE_SLOTS.get(), (Object)tier.getUpgradeSlots());
        }
        if (!stack.has(ModDataComponents.TOOL_SLOTS)) {
            stack.set((DataComponentType)ModDataComponents.TOOL_SLOTS.get(), (Object)tier.getToolSlots());
        }
    }

    public void requestMenuAndScreenUpdate() {
        this.requestMenuUpdate();
        this.requestScreenUpdate();
    }

    public void requestMenuUpdate() {
        if (!this.getPlayersUsing().isEmpty()) {
            this.getPlayersUsing().stream().filter(player -> player.containerMenu instanceof BackpackBaseMenu).forEach(player -> ((BackpackBaseMenu)player.containerMenu).updateModifiableSlots());
        }
    }

    public void requestScreenUpdate() {
        Screen screen;
        if (!this.getPlayersUsing().isEmpty() && !this.getPlayersUsing().stream().filter(player -> player.level().isClientSide).toList().isEmpty() && (screen = Minecraft.getInstance().screen) instanceof BackpackScreen) {
            BackpackScreen screen2 = (BackpackScreen)screen;
            screen2.updateScreen(false);
        }
    }

    public static void tickForBlockEntity(BackpackBlockEntity backpackBlockEntity) {
        BackpackWrapper wrapper = backpackBlockEntity.getWrapper();
        if (wrapper != DUMMY && wrapper.isAbilityEnabled() && BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, wrapper.getBackpackStack())) {
            boolean decreaseCooldown = BackpackAbilities.ABILITIES.abilityTickBlock(backpackBlockEntity);
            if (wrapper.getCooldown() > 0 && decreaseCooldown) {
                wrapper.decreaseCooldown();
            }
        }
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(Player player, ItemStack backpack, int[] dataLoad) {
        if (AttachmentUtils.isWearingBackpack(player)) {
            BackpackItemMenu menu;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof BackpackItemMenu && (menu = (BackpackItemMenu)abstractContainerMenu).getWrapper().getScreenID() == 2) {
                return menu.getWrapper();
            }
            for (Player otherPlayer : player.level().players()) {
                BackpackItemMenu menu2;
                AbstractContainerMenu abstractContainerMenu2 = otherPlayer.containerMenu;
                if (!(abstractContainerMenu2 instanceof BackpackItemMenu) || !(menu2 = (BackpackItemMenu)abstractContainerMenu2).getWrapper().isOwner(player) || menu2.getWrapper().getScreenID() != 2) continue;
                return menu2.getWrapper();
            }
            return new BackpackWrapper(backpack, 2, (HolderLookup.Provider)player.level().registryAccess(), player, player.level(), dataLoad);
        }
        return null;
    }

    public static void tick(ItemStack stack, Player player, boolean integration) {
        if (!integration && TravelersBackpack.enableIntegration()) {
            return;
        }
        if (player.isAlive() && AttachmentUtils.isWearingBackpack(player)) {
            BackpackWrapper wrapper;
            int ticks = (int)player.level().getGameTime();
            if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, AttachmentUtils.getWearingBackpack(player))) {
                if (BackpackAbilities.isAbilityEnabledInConfig(stack)) {
                    if (((Boolean)stack.getOrDefault(ModDataComponents.ABILITY_ENABLED, (Object)((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.forceAbilityEnabled.get()))).booleanValue()) {
                        boolean decreaseCooldown = BackpackAbilities.ABILITIES.abilityTick(stack, player);
                        if ((Integer)stack.getOrDefault(ModDataComponents.COOLDOWN, (Object)0) > 0 && ticks % 100 == 0 && decreaseCooldown) {
                            wrapper = AttachmentUtils.getBackpackWrapper(player, stack, AttachmentUtils.NO_ITEMS);
                            int cooldown = wrapper.getCooldown();
                            if (player.level().isClientSide) {
                                return;
                            }
                            if (cooldown - 100 < 0) {
                                wrapper.setCooldown(0);
                            } else {
                                wrapper.setCooldown(cooldown - 100);
                            }
                        }
                    } else if ((Integer)stack.getOrDefault((DataComponentType)ModDataComponents.COOLDOWN.get(), (Object)0) > 0 && ticks % 100 == 0) {
                        BackpackWrapper wrapper2 = AttachmentUtils.getBackpackWrapper(player, stack, AttachmentUtils.NO_ITEMS);
                        int cooldown = wrapper2.getCooldown();
                        if (player.level().isClientSide) {
                            return;
                        }
                        if (cooldown - 100 < 0) {
                            wrapper2.setCooldown(0);
                        } else {
                            wrapper2.setCooldown(cooldown - 100);
                        }
                    }
                }
            } else if (((Boolean)stack.getOrDefault(ModDataComponents.ABILITY_ENABLED, (Object)false)).booleanValue()) {
                stack.set(ModDataComponents.ABILITY_ENABLED, (Object)false);
            }
            if (stack.has(ModDataComponents.UPGRADE_TICK_INTERVAL)) {
                int upgradeTicks = (Integer)stack.get(ModDataComponents.UPGRADE_TICK_INTERVAL);
                if (upgradeTicks == 0) {
                    return;
                }
                if (ticks % upgradeTicks == 0) {
                    wrapper = AttachmentUtils.getBackpackWrapper(player, stack, AttachmentUtils.UPGRADES_ONLY);
                    wrapper.getUpgradeManager().upgrades.forEach(upgradeBase -> {
                        if (upgradeBase instanceof ITickableUpgrade) {
                            ITickableUpgrade tickable = (ITickableUpgrade)((Object)upgradeBase);
                            boolean tick = true;
                            if (upgradeBase instanceof IEnable) {
                                IEnable enable = (IEnable)((Object)upgradeBase);
                                tick = enable.isEnabled((UpgradeBase<?>)upgradeBase);
                            }
                            if (tick) {
                                tickable.tick(player, player.level(), player.blockPosition(), ticks);
                            }
                        }
                    });
                }
            }
        }
    }
}

