/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.feeding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.FilterUpgradeWidgetBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.feeding.FeedingUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.ButtonStates;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterButton;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class FeedingWidget
extends FilterUpgradeWidgetBase<FeedingWidget, FeedingUpgrade> {
    private static final List<Component> WHITELIST_TOOLTIPS = List.of(Component.translatable((String)"screen.travelersbackpack.filter_allow"), Component.translatable((String)"screen.travelersbackpack.filter_block"));
    private static final List<Component> HUNGER_MODE_TOOLTIPS = List.of(Component.translatable((String)"screen.travelersbackpack.filter_always_eat"), Component.translatable((String)"screen.travelersbackpack.filter_half_nutrition"), Component.translatable((String)"screen.travelersbackpack.filter_full_nutrition"));
    private static final List<Component> IGNORE_MODE_TOOLTIPS = List.of(Component.translatable((String)"screen.travelersbackpack.filter_block_bad_effects"), Component.translatable((String)"screen.travelersbackpack.filter_allow_bad_effects"));

    public FeedingWidget(BackpackScreen screen, FeedingUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(137, 0), "screen.travelersbackpack.feeding_upgrade");
        FilterButton<FeedingWidget> whitelistButton = new FilterButton<FeedingWidget>(this, upgrade.getFilter().get(0), ButtonStates.ALLOW_FEEDING, new Point(pos.x() + 6, pos.y() + 22));
        FilterButton<FeedingWidget> hungerModeButton = new FilterButton<FeedingWidget>(this, upgrade.getFilter().get(1), ButtonStates.HUNGER_MODE, new Point(pos.x() + 6 + 18, pos.y() + 22));
        FilterButton<FeedingWidget> ignoreEffectModeButton = new FilterButton<FeedingWidget>(this, upgrade.getFilter().get(2), ButtonStates.IGNORE_EFFECT_MODE, new Point(pos.x() + 6 + 36, pos.y() + 22));
        this.addFilterButton(whitelistButton);
        this.addFilterButton(hungerModeButton);
        this.addFilterButton(ignoreEffectModeButton);
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isTabOpened()) {
            if (this.getFilterButton(ButtonStates.ALLOW_FEEDING).isMouseOver(mouseX, mouseY)) {
                guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), WHITELIST_TOOLTIPS.get(this.getFilterButton(ButtonStates.ALLOW_FEEDING).getCurrentState()), mouseX, mouseY);
            }
            if (this.getFilterButton(ButtonStates.HUNGER_MODE).isMouseOver(mouseX, mouseY)) {
                guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), HUNGER_MODE_TOOLTIPS.get(this.getFilterButton(ButtonStates.HUNGER_MODE).getCurrentState()), mouseX, mouseY);
            }
            if (this.getFilterButton(ButtonStates.IGNORE_EFFECT_MODE).isMouseOver(mouseX, mouseY)) {
                guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), IGNORE_MODE_TOOLTIPS.get(this.getFilterButton(ButtonStates.IGNORE_EFFECT_MODE).getCurrentState()), mouseX, mouseY);
            }
        }
    }
}

