/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.components.Slots;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClientboundSyncAttachmentPacket(int entityID, ItemStack backpack, boolean removeData) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"sync_attachment");
    public static final CustomPacketPayload.Type<ClientboundSyncAttachmentPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundSyncAttachmentPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ClientboundSyncAttachmentPacket::entityID, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, ClientboundSyncAttachmentPacket::backpack, (StreamCodec)ByteBufCodecs.BOOL, ClientboundSyncAttachmentPacket::removeData, ClientboundSyncAttachmentPacket::new);

    public ClientboundSyncAttachmentPacket(int entityID, ItemStack serverBackpack) {
        this(entityID, serverBackpack, false);
    }

    public ClientboundSyncAttachmentPacket(int entityID, ItemStack backpack, boolean removeData) {
        this.entityID = entityID;
        ItemStack backpackCopy = backpack.copy();
        if (backpackCopy.has((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get())) {
            backpackCopy.remove((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get());
        }
        if (backpackCopy.has(ModDataComponents.SLOTS)) {
            Slots slots = (Slots)backpackCopy.get(ModDataComponents.SLOTS);
            List<Pair<Integer, Pair<ItemStack, Boolean>>> memorizedStacksHeavy = slots.memory();
            ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>> reduced = new ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>>();
            for (Pair<Integer, Pair<ItemStack, Boolean>> outerPair : memorizedStacksHeavy) {
                int index = (Integer)outerPair.getFirst();
                ItemStack innerStack = ((ItemStack)((Pair)outerPair.getSecond()).getFirst()).copy();
                boolean matchComponents = (Boolean)((Pair)outerPair.getSecond()).getSecond();
                if (matchComponents) {
                    innerStack = new ItemStack((ItemLike)innerStack.getItem(), innerStack.getCount());
                }
                if (innerStack.isEmpty()) continue;
                reduced.add((Pair<Integer, Pair<ItemStack, Boolean>>)Pair.of((Object)index, (Object)Pair.of((Object)innerStack, (Object)matchComponents)));
            }
            backpackCopy.set(ModDataComponents.SLOTS, (Object)new Slots(slots.unsortables(), reduced));
        }
        this.backpack = backpackCopy;
        this.removeData = removeData;
    }

    public static void handle(ClientboundSyncAttachmentPacket message, IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            ctx.enqueueWork(() -> {
                Player playerEntity = (Player)Minecraft.getInstance().level.getEntity(message.entityID());
                Optional<ITravelersBackpack> data = AttachmentUtils.getAttachment(playerEntity);
                if (data.isPresent()) {
                    if (message.removeData()) {
                        data.get().remove();
                    } else {
                        data.get().updateBackpack(message.backpack());
                    }
                }
            });
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

