/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.mojang.serialization.Codec;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClientboundSyncComponentsPacket(int entityID, DataComponentMap map) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"sync_components");
    public static final CustomPacketPayload.Type<ClientboundSyncComponentsPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundSyncComponentsPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ClientboundSyncComponentsPacket::entityID, (StreamCodec)ByteBufCodecs.fromCodecWithRegistries((Codec)DataComponentMap.CODEC), ClientboundSyncComponentsPacket::map, ClientboundSyncComponentsPacket::new);

    public static void handle(ClientboundSyncComponentsPacket message, IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            ctx.enqueueWork(() -> {
                Player playerEntity = (Player)Minecraft.getInstance().player.level().getEntity(message.entityID);
                ITravelersBackpack data = AttachmentUtils.getAttachment(playerEntity).orElseThrow(() -> new RuntimeException("No player attachment data found!"));
                if (data != null) {
                    data.applyComponents(message.map());
                }
            });
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

