/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterSettingsBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundFilterTagsPacket(int slot, List<String> tags) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundFilterTagsPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"filter_tags"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundFilterTagsPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ServerboundFilterTagsPacket::slot, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), ServerboundFilterTagsPacket::tags, ServerboundFilterTagsPacket::new);

    public static void handle(ServerboundFilterTagsPacket message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                BackpackBaseMenu menu;
                BackpackWrapper wrapper;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AbstractContainerMenu patt0$temp = serverPlayer.containerMenu;
                if (patt0$temp instanceof BackpackBaseMenu && !(wrapper = (menu = (BackpackBaseMenu)patt0$temp).getWrapper()).getUpgrades().getStackInSlot(message.slot).isEmpty()) {
                    Object patt1$temp;
                    ItemStack upgradeStack = wrapper.getUpgrades().getStackInSlot(message.slot).copy();
                    upgradeStack.set(ModDataComponents.FILTER_TAGS, message.tags);
                    wrapper.getUpgrades().setStackInSlot(message.slot, upgradeStack);
                    if (((Optional)wrapper.getUpgradeManager().mappedUpgrades.get((Object)message.slot)).isPresent() && (patt1$temp = ((Optional)wrapper.getUpgradeManager().mappedUpgrades.get((Object)message.slot)).get()) instanceof FilterUpgradeBase) {
                        FilterUpgradeBase filterUpgrade = (FilterUpgradeBase)patt1$temp;
                        ((FilterSettingsBase)filterUpgrade.getFilterSettings()).updateFilterTags(message.tags);
                    }
                    menu.getWrapper().saveHandler.run();
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

