/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.common.BackpackManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundRetrieveBackpackPacket(ItemStack backpackHolder) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundRetrieveBackpackPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"retrieve_backpack"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundRetrieveBackpackPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, ServerboundRetrieveBackpackPacket::backpackHolder, ServerboundRetrieveBackpackPacket::new);

    public static void handle(ServerboundRetrieveBackpackPacket message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                InventoryMenu menu;
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                AbstractContainerMenu patt1$temp = ctx.player().containerMenu;
                if (patt1$temp instanceof InventoryMenu && (menu = (InventoryMenu)patt1$temp).getCarried().isEmpty() && AttachmentUtils.getAttachment(ctx.player()).get().hasBackpack()) {
                    ItemStack backpack = AttachmentUtils.getAttachment(ctx.player()).get().getBackpack().copy();
                    AttachmentUtils.getAttachment(ctx.player()).ifPresent(attachment -> {
                        BackpackManager.addBackpack(serverPlayer, backpack);
                        attachment.equipBackpack(new ItemStack((ItemLike)Items.AIR, 0));
                        attachment.synchronise();
                    });
                    menu.setCarried(backpack);
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

