/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.env.param;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.sinytra.adapter.patch.util.AdapterUtil;

public class MethodParameters {
    private final Map<ParamGroup, List<Type>> groups;
    private final List<ParamGroup> order;

    private MethodParameters(Map<ParamGroup, List<Type>> groups, List<ParamGroup> order) {
        this.groups = new HashMap<ParamGroup, List<Type>>(groups);
        this.order = order;
    }

    public List<Type> get(ParamGroup group) {
        return Objects.requireNonNull(this.groups.get(group), "Group %s is not available".formatted(group.name()));
    }

    public void set(ParamGroup group, List<Type> params) {
        if (!this.groups.containsKey(group)) {
            throw new IllegalArgumentException("Group %s is not available".formatted(group.name()));
        }
        this.groups.put(group, params);
    }

    public List<Type> merge() {
        ArrayList<Type> result = new ArrayList<Type>();
        for (ParamGroup group : this.order) {
            result.addAll((Collection<Type>)this.groups.get(group));
        }
        return result;
    }

    public static List<Type> getParameterTypes(String desc) {
        return Arrays.asList(Type.getArgumentTypes((String)desc));
    }

    public static MethodParameters create(String desc, List<ParamGroup> groups) {
        return MethodParameters.create(MethodParameters.getParameterTypes(desc), groups);
    }

    public static MethodParameters create(List<Type> params, List<ParamGroup> types) {
        HashMap<ParamGroup, List<Type>> groups = new HashMap<ParamGroup, List<Type>>();
        for (ParamGroup type : types) {
            groups.put(type, new ArrayList());
        }
        int paramsIndex = 0;
        block1: for (int i = 0; i < types.size(); ++i) {
            ParamGroup next;
            ParamGroup group = types.get(i);
            ParamGroup paramGroup = next = i < types.size() - 1 ? types.get(i + 1) : null;
            if (group instanceof ParamGroup.Variable && next instanceof ParamGroup.Variable) {
                throw new IllegalStateException("Cannot follow VARIABLE group with another VARIABLE group");
            }
            List output = (List)groups.get(group);
            while (paramsIndex < params.size()) {
                ParamGroup.Single single;
                Type param = params.get(paramsIndex);
                if (group instanceof ParamGroup.Single) {
                    single = (ParamGroup.Single)group;
                    if (!single.predicate.test(param)) {
                        throw new IllegalStateException("Unexpected single parameter: " + String.valueOf(param));
                    }
                    output.add(param);
                    ++paramsIndex;
                    continue block1;
                }
                if (next instanceof ParamGroup.Single) {
                    single = (ParamGroup.Single)next;
                    if (single.predicate.test(param)) continue block1;
                }
                output.add(param);
                ++paramsIndex;
            }
        }
        return new MethodParameters(groups, types);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static sealed interface ParamGroup {
        public static final ParamGroup METHOD_PARAMS = new Variable("method_params");
        public static final ParamGroup CAPTURED_PARAMS = new Variable("captured_params");
        public static final ParamGroup SINGLE_ANY = new Single("single_any", t -> true);
        public static final ParamGroup CI_CIR = new Single("ci_cir", t -> t.equals((Object)AdapterUtil.CI_TYPE) || t.equals((Object)AdapterUtil.CIR_TYPE));
        public static final ParamGroup OPERATION = new Single("operation", t -> t.equals((Object)AdapterUtil.OPERATION_TYPE));
        public static final ParamGroup LOCALS = new Variable("locals");

        public String name();

        public record Variable(String name) implements ParamGroup
        {
            @Override
            @NotNull
            public String toString() {
                return "Variable[%s]".formatted(this.name);
            }
        }

        public record Single(String name, Predicate<Type> predicate) implements ParamGroup
        {
            @Override
            @NotNull
            public String toString() {
                return "Single[%s]".formatted(this.name);
            }
        }
    }

    public static class Builder {
        private final Map<ParamGroup, List<Type>> groups = new HashMap<ParamGroup, List<Type>>();
        private final List<ParamGroup> order = new ArrayList<ParamGroup>();

        public Builder put(ParamGroup group, Type param) {
            return this.put(group, List.of(param));
        }

        public Builder put(ParamGroup group, List<Type> params) {
            if (this.order.contains(group)) {
                throw new IllegalStateException("Duplicate group " + String.valueOf(group));
            }
            this.groups.put(group, new ArrayList<Type>(params));
            this.order.add(group);
            return this;
        }

        public MethodParameters build() {
            return new MethodParameters(this.groups, this.order);
        }
    }
}

