/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.MethodContextImpl;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.analysis.selector.FieldMatcher;
import org.sinytra.adapter.patch.api.ClassTransform;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchEnvironment;
import org.sinytra.adapter.patch.transformer.serialization.MethodTransformSerialization;
import org.sinytra.adapter.patch.util.AdapterUtil;

public final class InterfacePatchInstance
extends PatchInstance {
    public static final Collection<String> KNOWN_INTERFACE_MIXIN_TYPES = Set.of("Lorg/spongepowered/asm/mixin/gen/Accessor;");
    public static final Codec<InterfacePatchInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().optionalFieldOf("targetClasses", List.of()).forGetter(p -> p.targetClasses), (App)FieldMatcher.CODEC.listOf().optionalFieldOf("targetFields", List.of()).forGetter(p -> p.targetFields), (App)Codec.STRING.listOf().optionalFieldOf("targetAnnotations", List.of()).forGetter(p -> p.targetAnnotations), (App)MethodTransformSerialization.METHOD_TRANSFORM_CODEC.listOf().fieldOf("transforms").forGetter(p -> p.transforms)).apply((Applicative)instance, InterfacePatchInstance::new)).flatComapMap(Function.identity(), obj -> obj.targetAnnotationValues != null ? DataResult.error(() -> "Cannot serialize targetAnnotationValues") : DataResult.success((Object)obj));
    private final List<FieldMatcher> targetFields;

    private InterfacePatchInstance(List<String> targetClasses, List<FieldMatcher> targetFields, List<String> targetAnnotations, List<MethodTransform> transforms) {
        this(targetClasses, targetFields, targetAnnotations, map -> true, List.of(), transforms);
    }

    private InterfacePatchInstance(List<String> targetClasses, List<FieldMatcher> targetFields, List<String> targetAnnotations, Predicate<AnnotationHandle> targetAnnotationValues, List<ClassTransform> classTransforms, List<MethodTransform> transforms) {
        super(targetClasses, targetAnnotations, targetAnnotationValues, classTransforms, transforms);
        this.targetFields = targetFields;
    }

    @Override
    public Codec<? extends PatchInstance> codec() {
        return CODEC;
    }

    @Override
    public Patch.Result apply(ClassNode classNode, PatchEnvironment environment) {
        if ((classNode.access & 0x200) == 0) {
            return Patch.Result.PASS;
        }
        return super.apply(classNode, environment);
    }

    @Override
    protected boolean checkAnnotation(String owner, MethodNode method, AnnotationHandle methodAnnotation, PatchEnvironment environment, MethodContextImpl.Builder builder) {
        FieldMatcher matcher;
        if (KNOWN_INTERFACE_MIXIN_TYPES.contains(methodAnnotation.getDesc()) && methodAnnotation.matchesDesc("Lorg/spongepowered/asm/mixin/gen/Accessor;") && (matcher = (FieldMatcher)AdapterUtil.getAccessorTargetFieldName(owner, method, methodAnnotation, environment).map(FieldMatcher::new).orElse(null)) != null && (this.targetFields.isEmpty() || this.targetFields.stream().anyMatch(m -> m.matches(matcher)))) {
            builder.methodNode(method);
            builder.methodAnnotation(methodAnnotation);
            return true;
        }
        return false;
    }

    public static class InterfaceClassPatchBuilderImpl
    extends PatchInstance.BaseBuilder<Patch.InterfacePatchBuilder>
    implements Patch.InterfacePatchBuilder {
        private final Set<FieldMatcher> targetFields = new HashSet<FieldMatcher>();

        @Override
        public Patch.InterfacePatchBuilder targetField(String ... targets) {
            for (String target : targets) {
                this.targetFields.add(new FieldMatcher(target));
            }
            return this;
        }

        @Override
        public PatchInstance build() {
            return new InterfacePatchInstance(List.copyOf(this.targetClasses), List.copyOf(this.targetFields), List.copyOf(this.targetAnnotations), this.targetAnnotationValues, List.copyOf(this.classTransforms), List.copyOf(this.transforms));
        }
    }
}

