/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynfix;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.InstructionMatcher;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.sinytra.adapter.patch.transformer.dynfix.DynamicFixer;
import org.sinytra.adapter.patch.transformer.dynfix.SplitMethodCancellationHelper;
import org.sinytra.adapter.patch.transformer.operation.unit.ModifyInjectionTarget;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.OpcodeUtil;

public class DynFixSplitMethod
implements DynamicFixer<DynamicFixer.EmptyData> {
    private static final String DEPRECATED = "Ljava/lang/Deprecated;";

    @Override
    @Nullable
    public DynamicFixer.EmptyData prepare(MethodContext methodContext) {
        if (methodContext.hasInjectionPointValue("INVOKE") && methodContext.findCleanInjectionTarget() != null && methodContext.findDirtyInjectionTarget() != null) {
            return DynamicFixer.EmptyData.INSTANCE;
        }
        return null;
    }

    @Override
    @Nullable
    public DynamicFixer.FixResult apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchAuditTrail auditTrail, DynamicFixer.EmptyData data) {
        List<CandidateMethod> candidates = DynFixSplitMethod.disambiguate(DynFixSplitMethod.locateCandidates(methodContext), methodContext);
        if (candidates.size() == 1) {
            MethodNode method = candidates.getFirst().method();
            String newTarget = method.name + method.desc;
            methodContext.recordAudit(this, "Adjusting split method target to %s", newTarget);
            if (methodContext.isCancellable()) {
                SplitMethodCancellationHelper.handle(this, methodContext, method);
            }
            return DynamicFixer.FixResult.of(new ModifyInjectionTarget(List.of(newTarget)).apply(methodContext), PatchAuditTrail.Match.FULL);
        }
        return null;
    }

    public static boolean isDirtyDeprecatedMethod(MethodNode clean, MethodNode dirty) {
        return !AdapterUtil.hasAnnotation(clean.visibleAnnotations, DEPRECATED) && AdapterUtil.hasAnnotation(dirty.visibleAnnotations, DEPRECATED);
    }

    @Nullable
    public static List<MethodNode> collectMethodInvocations(ClassNode cls, MethodNode mtd) {
        ArrayList<MethodNode> invocations = new ArrayList<MethodNode>();
        for (int i = 1; i < mtd.instructions.size() - 1; ++i) {
            AbstractInsnNode insn = mtd.instructions.get(i);
            if (!(insn instanceof LabelNode)) continue;
            AbstractInsnNode previous = insn.getPrevious();
            if (previous instanceof MethodInsnNode) {
                MethodInsnNode methodInsn = (MethodInsnNode)previous;
                if (methodInsn.owner.equals(cls.name)) {
                    MethodNode method = cls.methods.stream().filter(m -> m.name.equals(methodInsn.name) && m.desc.equals(methodInsn.desc)).findFirst().orElseThrow();
                    invocations.add(method);
                    continue;
                }
            }
            if (previous != null && OpcodeUtil.isReturnOpcode(previous.getOpcode())) continue;
            return null;
        }
        return invocations;
    }

    private static List<CandidateMethod> locateCandidates(MethodContext methodContext) {
        MethodNode cleanTargetMethod = methodContext.findCleanInjectionTarget().methodNode();
        ClassNode dirtyTargetClass = methodContext.findDirtyInjectionTarget().classNode();
        MethodNode dirtyTargetMethod = methodContext.findDirtyInjectionTarget().methodNode();
        if (!DynFixSplitMethod.isDirtyDeprecatedMethod(cleanTargetMethod, dirtyTargetMethod)) {
            return DynFixSplitMethod.tryFindPartialCandidates(cleanTargetMethod, dirtyTargetClass, dirtyTargetMethod, methodContext);
        }
        List<MethodNode> invocations = DynFixSplitMethod.collectMethodInvocations(dirtyTargetClass, dirtyTargetMethod);
        if (invocations == null) {
            return null;
        }
        List<CandidateMethod> candidates = DynFixSplitMethod.findInsnsCalls(invocations, methodContext);
        if (candidates.isEmpty()) {
            List<MethodNode> nestedLambdas = invocations.stream().flatMap(m -> MethodCallAnalyzer.findLambdasInMethod(dirtyTargetClass, m, null).stream()).flatMap(s -> MethodCallAnalyzer.findMethodByUniqueName(dirtyTargetClass, s).stream()).toList();
            return DynFixSplitMethod.findInsnsCalls(nestedLambdas, methodContext);
        }
        return candidates;
    }

    private static List<CandidateMethod> tryFindPartialCandidates(MethodNode cleanTargetMethod, ClassNode dirtyTargetClass, MethodNode dirtyTargetMethod, MethodContext methodContext) {
        Multimap<String, MethodInsnNode> cleanMethodCalls = MethodCallAnalyzer.getMethodCalls(cleanTargetMethod, new ArrayList<String>());
        Multimap<String, MethodInsnNode> dirtyMethodCalls = MethodCallAnalyzer.getMethodCalls(dirtyTargetMethod, new ArrayList<String>());
        List<MethodNode> dirtyOnlyCalls = dirtyMethodCalls.entries().stream().filter(e -> !cleanMethodCalls.containsKey(e.getKey()) && ((MethodInsnNode)e.getValue()).owner.equals(dirtyTargetClass.name)).map(Map.Entry::getValue).flatMap(i -> MethodCallAnalyzer.findMethodByNameOrThrow(dirtyTargetClass, i.name, i.desc).stream()).toList();
        return DynFixSplitMethod.findInsnsCalls(dirtyOnlyCalls, methodContext);
    }

    private static List<CandidateMethod> disambiguate(List<CandidateMethod> candidates, MethodContext methodContext) {
        if (candidates.size() <= 1) {
            return candidates;
        }
        List<AbstractInsnNode> cleanInsns = methodContext.findInjectionTargetInsns(methodContext.findCleanInjectionTarget());
        if (cleanInsns.size() != 1) {
            return candidates;
        }
        InstructionMatcher cleanMatcher = MethodCallAnalyzer.findSurroundingInstructions(cleanInsns.getFirst(), 5);
        List<CandidateMethod> matchingCandidates = candidates.stream().filter(method -> method.insns().size() == 1).filter(method -> {
            InstructionMatcher matcher = MethodCallAnalyzer.findSurroundingInstructions(method.insns().getFirst(), 5);
            return cleanMatcher.test(matcher, 1);
        }).toList();
        if (matchingCandidates.size() == 1) {
            return matchingCandidates;
        }
        return candidates;
    }

    private static List<CandidateMethod> findInsnsCalls(List<MethodNode> methods, MethodContext methodContext) {
        ClassNode dirtyTargetClass = methodContext.findDirtyInjectionTarget().classNode();
        return methods.stream().map(method -> {
            List<AbstractInsnNode> insns = methodContext.findInjectionTargetInsns(new MethodContext.TargetPair(dirtyTargetClass, (MethodNode)method));
            return !insns.isEmpty() ? new CandidateMethod((MethodNode)method, insns) : null;
        }).filter(Objects::nonNull).toList();
    }

    private record CandidateMethod(MethodNode method, List<AbstractInsnNode> insns) {
    }
}

