/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer.jar;

import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.MappingResolverImpl;
import org.jetbrains.annotations.Nullable;
import org.sinytra.adapter.patch.LVTOffsets;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.sinytra.adapter.patch.api.PatchEnvironment;
import org.sinytra.adapter.patch.api.RefmapHolder;
import org.sinytra.adapter.patch.transformer.serialization.PatchSerialization;
import org.sinytra.adapter.patch.util.provider.ClassLookup;
import org.sinytra.adapter.patch.util.provider.MixinClassLookup;
import org.sinytra.connector.transformer.TransformerEnvironment;
import org.sinytra.connector.transformer.jar.BytecodeFixerUpperFrontend;
import org.sinytra.connector.transformer.jar.IntermediateMapping;
import org.sinytra.connector.transformer.jar.JarTransformer;
import org.sinytra.connector.transformer.patch.ClassAnalysingTransformer;
import org.sinytra.connector.transformer.patch.ClassNodeTransformer;
import org.sinytra.connector.transformer.patch.ConnectorRefmapHolder;
import org.sinytra.connector.transformer.patch.ReflectionRenamingTransformer;
import org.sinytra.connector.transformer.transform.AccessWidenerTransformer;
import org.sinytra.connector.transformer.transform.AccessorRedirectTransformer;
import org.sinytra.connector.transformer.transform.FieldToMethodTransformer;
import org.sinytra.connector.transformer.transform.JarSignatureStripper;
import org.sinytra.connector.transformer.transform.MappingAwareReferenceMapper;
import org.sinytra.connector.transformer.transform.MixinPatchTransformer;
import org.sinytra.connector.transformer.transform.OptimizedRenamingTransformer;
import org.sinytra.connector.transformer.transform.RefmapRemapper;
import org.slf4j.Logger;
import reloc.net.minecraftforge.fart.api.ClassProvider;
import reloc.net.minecraftforge.fart.api.Renamer;
import reloc.net.minecraftforge.fart.internal.EnhancedRemapper;
import reloc.net.minecraftforge.srgutils.IMappingFile;

public class JarTransformInstance {
    private static final String FABRIC_MAPPING_NAMESPACE = "Fabric-Mapping-Namespace";
    private static final Gson GSON = new Gson();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MappingAwareReferenceMapper remapper;
    private final List<? extends Patch> adapterPatches;
    private final LVTOffsets lvtOffsetsData;
    private final BytecodeFixerUpperFrontend bfu;
    private final EnhancedRemapper enhancedRemapper;
    private final ClassLookup cleanClassLookup;
    private final List<Path> libs;
    private final PatchAuditTrail auditTrail;
    private final TransformerEnvironment environment;

    public JarTransformInstance(TransformerEnvironment environment, ClassProvider classProvider, List<Path> libs) {
        JsonElement json;
        BufferedReader reader;
        this.environment = environment;
        MappingResolverImpl resolver = FabricLoaderImpl.INSTANCE.getMappingResolver();
        resolver.getMap("mojang", "intermediary");
        resolver.getMap("intermediary", "mojang");
        this.remapper = new MappingAwareReferenceMapper(resolver.getCurrentMap("intermediary"));
        try {
            URL patchDataPath = this.environment.getAdapterPatchDataURL();
            reader = new BufferedReader(new InputStreamReader(patchDataPath.openStream()));
            try {
                json = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                this.adapterPatches = PatchSerialization.deserialize(json, JsonOps.INSTANCE);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        try {
            URL offsetDataPath = this.environment.getAdapterLVTDataURL();
            reader = new BufferedReader(new InputStreamReader(offsetDataPath.openStream()));
            try {
                json = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                this.lvtOffsetsData = LVTOffsets.fromJson(json);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        IMappingFile mappingFile = FabricLoaderImpl.INSTANCE.getMappingResolver().getCurrentMap("intermediary");
        OptimizedRenamingTransformer.IntermediaryClassProvider intermediaryClassProvider = new OptimizedRenamingTransformer.IntermediaryClassProvider(classProvider, mappingFile, mappingFile.reverse(), s -> {});
        this.enhancedRemapper = new OptimizedRenamingTransformer.MixinAwareEnhancedRemapper(intermediaryClassProvider, mappingFile, IntermediateMapping.get("intermediary"), s -> {});
        this.cleanClassLookup = environment.getCleanClassLookup();
        this.bfu = new BytecodeFixerUpperFrontend(this.cleanClassLookup, MixinClassLookup.INSTANCE, this.environment);
        this.libs = libs;
        this.auditTrail = PatchAuditTrail.create();
        this.environment.completeSetup();
    }

    public BytecodeFixerUpperFrontend getBfu() {
        return this.bfu;
    }

    @Nullable
    public PatchAuditTrail transformJar(File input, Path output, JarTransformer.FabricModFileMetadata metadata) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (metadata.generated()) {
            JarTransformInstance.processGeneratedJar(input, output, stopwatch);
            return null;
        }
        String jarMapping = metadata.manifestAttributes().getValue(FABRIC_MAPPING_NAMESPACE);
        if (jarMapping != null && !jarMapping.equals("intermediary")) {
            LOGGER.error("Found transformable jar with unsupported mapping {}, currently only {} is supported", (Object)jarMapping, (Object)"intermediary");
        }
        MappingResolverImpl resolver = FabricLoaderImpl.INSTANCE.getMappingResolver();
        RefmapRemapper.RefmapFiles refmap = RefmapRemapper.processRefmaps(input.toPath(), metadata.refmaps(), this.remapper, this.libs);
        IMappingFile srgToIntermediary = resolver.getMap("mojang", "intermediary");
        IMappingFile intermediaryToSrg = resolver.getCurrentMap("intermediary");
        AccessorRedirectTransformer accessorRedirectTransformer = new AccessorRedirectTransformer(srgToIntermediary);
        PatchAuditTrail jarTrail = PatchAuditTrail.create();
        List extraPatches = Stream.concat(this.adapterPatches.stream(), AccessorRedirectTransformer.PATCHES.stream()).toList();
        ConnectorRefmapHolder refmapHolder = new ConnectorRefmapHolder(refmap.merged(), refmap.files());
        int fabricLVTCompatibility = this.environment.getFabricMixinCompatibility(metadata.modMetadata());
        PatchEnvironment environment = PatchEnvironment.create((RefmapHolder)refmapHolder, this.cleanClassLookup, this.bfu.unwrap(), fabricLVTCompatibility, jarTrail);
        MixinPatchTransformer patchTransformer = new MixinPatchTransformer(this.environment, this.lvtOffsetsData, environment, extraPatches);
        RefmapRemapper refmapRemapper = new RefmapRemapper(refmap.files());
        Renamer.Builder builder = Renamer.builder().add(new JarSignatureStripper()).add(new ClassNodeTransformer(new FieldToMethodTransformer(metadata.modMetadata().getAccessWidener(), srgToIntermediary), accessorRedirectTransformer, new ReflectionRenamingTransformer(intermediaryToSrg, IntermediateMapping.get("intermediary")))).add(new OptimizedRenamingTransformer(this.enhancedRemapper, false, metadata.refmaps().isEmpty())).add(new ClassNodeTransformer(new ClassAnalysingTransformer())).add(patchTransformer).add(refmapRemapper).logger(s -> LOGGER.trace(JarTransformer.TRANSFORM_MARKER, s)).debug(s -> LOGGER.trace(JarTransformer.TRANSFORM_MARKER, s)).ignoreJarPathPrefix("assets/", "data/");
        if (!metadata.containsAT()) {
            builder.add(new AccessWidenerTransformer(metadata.modMetadata().getAccessWidener(), resolver, IntermediateMapping.get("intermediary")));
        }
        try (Renamer renamer = builder.build();){
            accessorRedirectTransformer.analyze(input, metadata.mixinPackages(), environment);
            renamer.run(input, output.toFile());
            try (FileSystem zipFile = FileSystems.newFileSystem(output);){
                patchTransformer.finalize(zipFile.getPath("/", new String[0]), metadata.mixinConfigs(), refmap.files(), refmapHolder.getDirtyRefmaps());
            }
        }
        catch (Throwable t) {
            LOGGER.error("Encountered error while transforming jar file {}", (Object)input.getAbsolutePath(), (Object)t);
            throw t;
        }
        stopwatch.stop();
        LOGGER.debug(JarTransformer.TRANSFORM_MARKER, "Jar {} transformed in {} ms", (Object)input.getName(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        Set<String> ignore = jarTrail.getFailingMixins().stream().map(c -> c.classNode().name).filter(s -> !metadata.mixinClasses().contains(s)).collect(Collectors.toSet());
        jarTrail.silenceClasses(ignore);
        this.auditTrail.merge(jarTrail);
        return jarTrail;
    }

    private static void processGeneratedJar(File input, Path output, Stopwatch stopwatch) throws IOException {
        Files.copy(input.toPath(), output, new CopyOption[0]);
        stopwatch.stop();
        LOGGER.debug(JarTransformer.TRANSFORM_MARKER, "Skipping transformation of jar {} after {} ms as it contains generated metadata, assuming it's a java library", (Object)input.getName(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public void saveAuditReport() {
        try {
            Path path = this.environment.getAuditReportPath();
            Files.deleteIfExists(path);
            String log = this.auditTrail.getCompleteReport();
            Files.writeString(path, (CharSequence)log, new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Error writing patch audit report", (Throwable)e);
        }
    }
}

