/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.cccbridge.common.create.behaviour;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import dev.kleinbox.cccbridge.common.minecraft.blockEntity.ScrollerBlockEntity;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class LuaScrollValueBehaviour
extends ScrollValueBehaviour {
    private boolean hasMinus;

    public LuaScrollValueBehaviour(ScrollerBlockEntity be, ValueBoxTransform slot) {
        super((Component)Component.translatable((String)"block.cccbridge.scroller_block"), (SmartBlockEntity)be, slot);
        this.withCallback(i -> be.fireUpdateValueEvent());
        this.onlyActiveWhen(() -> be.getLevel() != null && (Boolean)be.getLevel().getBlockState(be.getBlockPos()).getValue((Property)BlockStateProperties.LOCKED) == false);
        this.value = 0;
        this.hasMinus = false;
        this.between(-15, 15);
    }

    public void setValueQuietly(int value) {
        if ((value = Mth.clamp((int)value, (int)(-this.max), (int)this.max)) == this.value) {
            return;
        }
        this.value = value;
        this.blockEntity.setChanged();
        this.blockEntity.sendData();
    }

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        nbt.putInt("ScrollValue", this.value);
        nbt.putBoolean("ScrollMinus", this.hasMinus);
        nbt.putInt("ScrollLimit", this.max);
        super.write(nbt, registries, clientPacket);
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        this.value = nbt.getInt("ScrollValue");
        this.hasMinus = nbt.getBoolean("ScrollMinus");
        int limit = nbt.getInt("ScrollLimit");
        this.between(-limit, limit);
        super.read(nbt, registries, clientPacket);
    }

    public void playFeedbackSound(BlockEntityBehaviour origin) {
        origin.getWorld().playSound(null, origin.getPos(), SoundEvents.COPPER_PLACE, SoundSource.BLOCKS, 0.25f, 2.0f);
        origin.getWorld().playSound(null, origin.getPos(), (SoundEvent)SoundEvents.NOTE_BLOCK_BIT.value(), SoundSource.BLOCKS, 0.05f, 1.25f);
    }

    public void between(int limit) {
        this.between(-limit, limit);
        this.blockEntity.setChanged();
        this.blockEntity.sendData();
    }

    public void setHasMinus(boolean state) {
        this.hasMinus = state;
        this.blockEntity.setChanged();
        this.blockEntity.sendData();
    }

    public int getMax() {
        return this.max;
    }

    public boolean hasMinus() {
        return this.hasMinus;
    }

    public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
        ImmutableList rows = this.hasMinus ? ImmutableList.of((Object)Component.translatable((String)"cccbridge.general.unit.scroller.negative"), (Object)Component.translatable((String)"cccbridge.general.unit.scroller.positive")) : ImmutableList.of((Object)Component.translatable((String)"cccbridge.general.unit.scroller"));
        return new ValueSettingsBoard(this.label, this.max, 5, (List)rows, new ValueSettingsFormatter(ValueSettingsBehaviour.ValueSettings::format));
    }

    public void setValueSettings(Player player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlDown) {
        if (valueSetting.equals((Object)this.getValueSettings())) {
            return;
        }
        this.setValue(this.hasMinus && valueSetting.row() == 0 ? -valueSetting.value() : valueSetting.value());
        this.playFeedbackSound((BlockEntityBehaviour)this);
    }
}

