/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.cccbridge.common.minecraft.block;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import dev.kleinbox.cccbridge.common.CCCRegistries;
import dev.kleinbox.cccbridge.common.assistance.Randomness;
import dev.kleinbox.cccbridge.common.minecraft.blockEntity.RedRouterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class RedRouterBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
IWrenchable {
    public static final BlockBehaviour.Properties REDROUTER_BLOCK_PROPERTIES = BlockBehaviour.Properties.of().strength(1.3f).sound(SoundType.STONE).noOcclusion().isRedstoneConductor((state, view, pos) -> false);
    public static final int FACE_AMOUNT = 16;
    public static final IntegerProperty FACE = IntegerProperty.create((String)"face", (int)0, (int)16);

    public RedRouterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)FACE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return RedRouterBlock.simpleCodec(RedRouterBlock::new);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING}).add(new Property[]{FACE});
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean pIsMoving) {
        if (!level.isClientSide) {
            BlockEntity be = level.getBlockEntity(pos);
            if (!(be instanceof RedRouterBlockEntity)) {
                return;
            }
            RedRouterBlockEntity rbe = (RedRouterBlockEntity)be;
            RedRouterBlockEntity.updateInputs(level, pos, rbe);
            rbe.setChanged();
        }
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new RedRouterBlockEntity(pos, state);
    }

    public boolean isSignalSource(@NotNull BlockState state) {
        return true;
    }

    public int getDirectSignal(@NotNull BlockState state, BlockGetter world, @NotNull BlockPos pos, @NotNull Direction direction) {
        BlockEntity block = world.getBlockEntity(pos);
        if (!(block instanceof RedRouterBlockEntity)) {
            return 0;
        }
        RedRouterBlockEntity redrouter = (RedRouterBlockEntity)block;
        return redrouter.getPower(direction);
    }

    public int getSignal(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return this.getDirectSignal(state, level, pos, direction);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockEntity tileentity = context.getLevel().getBlockEntity(context.getClickedPos());
        if (!(tileentity instanceof RedRouterBlockEntity)) {
            return InteractionResult.FAIL;
        }
        RedRouterBlockEntity redrouter = (RedRouterBlockEntity)tileentity;
        if (context.getClickedFace().get3DDataValue() < 2) {
            int north = redrouter.getPower(Direction.NORTH);
            int east = redrouter.getPower(Direction.EAST);
            int south = redrouter.getPower(Direction.SOUTH);
            int west = redrouter.getPower(Direction.WEST);
            redrouter.setPower("north", west);
            redrouter.setPower("east", north);
            redrouter.setPower("south", east);
            redrouter.setPower("west", south);
        }
        return super.onWrenched(state, context);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return CCCRegistries.REDROUTER_BLOCK_ENTITY.get() == type ? RedRouterBlockEntity::tick : null;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)FACE, (Comparable)Integer.valueOf(ctx.getLevel().isClientSide ? 0 : Randomness.randomFace()));
    }
}

