/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.lootr;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.lootr.LootrPlugin;
import snownee.jade.api.Accessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.theme.IThemeHelper;

public interface LootrInfoProvider<A extends Accessor<?>>
extends StreamServerDataProvider<A, Data> {
    @Nullable
    default public Data streamData(A accessor) {
        Object object = accessor.getTarget();
        if (!(object instanceof ILootrInfoProvider)) {
            return null;
        }
        ILootrInfoProvider infoProvider = (ILootrInfoProvider)object;
        int decayValue = 0;
        if (!LootrAPI.isDecayed((ILootrInfoProvider)infoProvider)) {
            decayValue = LootrAPI.getRemainingDecayValue((ILootrInfoProvider)infoProvider);
        }
        boolean refreshed = LootrAPI.isRefreshed((ILootrInfoProvider)infoProvider);
        int refreshValue = 0;
        if (!refreshed) {
            refreshValue = LootrAPI.getRemainingRefreshValue((ILootrInfoProvider)infoProvider);
        }
        return new Data(decayValue, refreshed, refreshValue);
    }

    default public StreamCodec<RegistryFriendlyByteBuf, Data> streamCodec() {
        return Data.STREAM_CODEC.cast();
    }

    default public void appendTooltip(ITooltip tooltip, A accessor) {
        Data data = this.decodeFromData((Accessor)accessor).orElse(null);
        if (data == null) {
            return;
        }
        IThemeHelper t = IThemeHelper.get();
        if (data.decay() > 0) {
            tooltip.add((Component)Component.translatable((String)"jadeaddons.lootr.decay", (Object[])new Object[]{t.seconds(data.decay(), accessor.tickRate())}));
        }
        if (data.refreshed()) {
            tooltip.add((Component)Component.translatable((String)"jadeaddons.lootr.refreshed"));
        } else if (data.refresh() > 0) {
            tooltip.add((Component)Component.translatable((String)"jadeaddons.lootr.refresh", (Object[])new Object[]{t.seconds(data.refresh(), accessor.tickRate())}));
        }
    }

    default public ResourceLocation getUid() {
        return LootrPlugin.INFO;
    }

    public record Data(int decay, boolean refreshed, int refresh) {
        public static final StreamCodec<ByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Data::decay, (StreamCodec)ByteBufCodecs.BOOL, Data::refreshed, (StreamCodec)ByteBufCodecs.VAR_INT, Data::refresh, Data::new);
    }
}

