/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.api.relics;

import it.hurts.sskirillss.relics.api.relics.AbilityMetricComponent;
import it.hurts.sskirillss.relics.api.relics.AbilityStatisticComponent;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.IRelicTemplateHolder;
import it.hurts.sskirillss.relics.api.relics.LevelingComponent;
import it.hurts.sskirillss.relics.api.relics.LockComponent;
import it.hurts.sskirillss.relics.api.relics.MetricTemplate;
import it.hurts.sskirillss.relics.api.relics.RelicComponent;
import it.hurts.sskirillss.relics.api.relics.RelicMetricComponent;
import it.hurts.sskirillss.relics.api.relics.RelicStatisticComponent;
import it.hurts.sskirillss.relics.api.relics.ResearchComponent;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilitiesComponent;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityComponent;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityExtenderComponent;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatComponent;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatTemplate;
import it.hurts.sskirillss.relics.init.RelicsDataComponents;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public interface IRelicDataHolder {
    default public RelicComponent getRelicComponent(LivingEntity entity, ItemStack stack) {
        return (RelicComponent)stack.getOrDefault(RelicsDataComponents.DATA, (Object)RelicComponent.EMPTY);
    }

    default public void setRelicComponent(LivingEntity entity, ItemStack stack, RelicComponent data) {
        stack.set(RelicsDataComponents.DATA, (Object)data);
    }

    default public LevelingComponent getLevelingData(LivingEntity entity, ItemStack stack) {
        return this.getRelicComponent(entity, stack).getLeveling();
    }

    default public void setLevelingData(LivingEntity entity, ItemStack stack, LevelingComponent data) {
        this.setRelicComponent(entity, stack, this.getRelicComponent(entity, stack).toBuilder().leveling(data).build());
    }

    default public AbilitiesComponent getAbilitiesComponent(LivingEntity entity, ItemStack stack) {
        return this.getRelicComponent(entity, stack).getAbilities();
    }

    default public void setAbilitiesComponent(LivingEntity entity, ItemStack stack, AbilitiesComponent data) {
        this.setRelicComponent(entity, stack, this.getRelicComponent(entity, stack).toBuilder().abilities(data).build());
    }

    @Nullable
    default public AbilityComponent getAbilityComponent(LivingEntity entity, ItemStack stack, String ability) {
        Item item = stack.getItem();
        if (!(item instanceof IRelicTemplateHolder)) {
            return null;
        }
        IRelicTemplateHolder templateHolder = (IRelicTemplateHolder)item;
        AbilitiesComponent abilitiesComponent = this.getAbilitiesComponent(entity, stack);
        AbilityComponent abilityComponent = abilitiesComponent.getAbilities().get(ability);
        AbilityTemplate abilityTemplate = templateHolder.getAbilityTemplate(entity, stack, ability);
        if (abilityComponent != null) {
            return abilityComponent;
        }
        if (abilityTemplate != null) {
            abilityComponent = AbilityComponent.EMPTY;
            if (abilityTemplate.getRequiredLevel() <= 0) {
                abilityComponent = abilityComponent.toBuilder().lock(LockComponent.builder().unlocks(this.getMaxLockUnlocks()).build()).build();
            }
            this.setAbilitiesComponent(entity, stack, abilitiesComponent.toBuilder().ability(ability, abilityComponent).build());
            return abilityComponent;
        }
        return null;
    }

    default public void setAbilityComponent(LivingEntity entity, ItemStack stack, String ability, AbilityComponent component) {
        this.setAbilitiesComponent(entity, stack, this.getAbilitiesComponent(entity, stack).toBuilder().ability(ability, component).build());
    }

    @Nullable
    default public StatComponent getStatComponent(LivingEntity entity, ItemStack stack, String ability, String stat) {
        Item item = stack.getItem();
        if (!(item instanceof IRelicTemplateHolder)) {
            return null;
        }
        IRelicTemplateHolder templateHolder = (IRelicTemplateHolder)item;
        AbilityComponent abilityComponent = this.getAbilityComponent(entity, stack, ability);
        StatComponent statComponent = abilityComponent.getStats().get(stat);
        StatTemplate statData = templateHolder.getStatTemplate(entity, stack, ability, stat);
        if (statComponent != null) {
            return statComponent;
        }
        if (statData != null) {
            statComponent = StatComponent.EMPTY;
            statComponent = statComponent.toBuilder().initialQuality(new Random().nextInt(11)).build();
            this.setAbilityComponent(entity, stack, ability, abilityComponent.toBuilder().stat(stat, statComponent).build());
            return statComponent;
        }
        return null;
    }

    default public void setStatComponent(LivingEntity entity, ItemStack stack, String ability, String stat, StatComponent component) {
        this.setAbilityComponent(entity, stack, ability, this.getAbilityComponent(entity, stack, ability).toBuilder().stat(stat, component).build());
    }

    default public int getStatInitialQuality(LivingEntity entity, ItemStack stack, String ability, String stat) {
        return this.getStatComponent(entity, stack, ability, stat).getInitialQuality();
    }

    default public void setStatInitialQuality(LivingEntity entity, ItemStack stack, String ability, String stat, int quality) {
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        this.setStatComponent(entity, stack, ability, stat, this.getStatComponent(entity, stack, ability, stat).toBuilder().initialQuality(Math.clamp((long)quality, 0, relic.getStatMaxQuality(entity, stack, ability, stat))).build());
    }

    default public void addStatInitialQuality(LivingEntity entity, ItemStack stack, String ability, String stat, int quality) {
        this.setStatInitialQuality(entity, stack, ability, stat, this.getStatInitialQuality(entity, stack, ability, stat) + quality);
    }

    default public Optional<Double> getStatOverrideValue(LivingEntity entity, ItemStack stack, String ability, String stat) {
        return this.getStatComponent(entity, stack, ability, stat).getOverrideValue();
    }

    default public void setStatOverrideValue(LivingEntity entity, ItemStack stack, String ability, String stat, @Nullable Double value) {
        this.setStatComponent(entity, stack, ability, stat, this.getStatComponent(entity, stack, ability, stat).toBuilder().overrideValue(value == null ? Optional.empty() : Optional.of(value)).build());
    }

    default public void addStatOverrideValue(LivingEntity entity, ItemStack stack, String ability, String stat, double value) {
        this.setStatOverrideValue(entity, stack, ability, stat, this.getStatOverrideValue(entity, stack, ability, stat).orElse(0.0) + value);
    }

    default public AbilityExtenderComponent getAbilityExtenderComponent(LivingEntity entity, ItemStack stack, String ability) {
        return this.getAbilityComponent(entity, stack, ability).getExtender();
    }

    default public void setAbilityExtenderComponent(LivingEntity entity, ItemStack stack, String ability, AbilityExtenderComponent component) {
        this.setAbilityComponent(entity, stack, ability, this.getAbilityComponent(entity, stack, ability).toBuilder().extender(component).build());
    }

    default public LockComponent getLockComponent(LivingEntity entity, ItemStack stack, String ability) {
        return this.getAbilityComponent(entity, stack, ability).getLock();
    }

    default public void setLockComponent(LivingEntity entity, ItemStack stack, String ability, LockComponent component) {
        this.setAbilityComponent(entity, stack, ability, this.getAbilityComponent(entity, stack, ability).toBuilder().lock(component).build());
    }

    default public int getMaxLockUnlocks() {
        return 5;
    }

    default public int getLockUnlocks(LivingEntity entity, ItemStack stack, String ability) {
        return this.getLockComponent(entity, stack, ability).getUnlocks();
    }

    default public void setLockUnlocks(LivingEntity entity, ItemStack stack, String ability, int unlocks) {
        this.setLockComponent(entity, stack, ability, this.getLockComponent(entity, stack, ability).toBuilder().unlocks(Mth.clamp((int)unlocks, (int)0, (int)this.getMaxLockUnlocks())).build());
    }

    default public void addLockUnlocks(LivingEntity entity, ItemStack stack, String ability, int unlocks) {
        this.setLockUnlocks(entity, stack, ability, this.getLockUnlocks(entity, stack, ability) + unlocks);
    }

    default public boolean isLockUnlocked(LivingEntity entity, ItemStack stack, String ability) {
        return this.getLockUnlocks(entity, stack, ability) >= this.getMaxLockUnlocks();
    }

    default public ResearchComponent getResearchComponent(LivingEntity entity, ItemStack stack, String ability) {
        return this.getAbilityComponent(entity, stack, ability).getResearch();
    }

    default public RelicStatisticComponent getRelicStatisticComponent(LivingEntity entity, ItemStack stack) {
        return this.getRelicComponent(entity, stack).getStatistic();
    }

    default public void setRelicStatisticComponent(LivingEntity entity, ItemStack stack, RelicStatisticComponent component) {
        this.setRelicComponent(entity, stack, this.getRelicComponent(entity, stack).toBuilder().statistic(component).build());
    }

    default public RelicMetricComponent getRelicMetricComponent(LivingEntity entity, ItemStack stack, String metric) {
        Item item = stack.getItem();
        if (!(item instanceof IRelicTemplateHolder)) {
            return null;
        }
        IRelicTemplateHolder templateHolder = (IRelicTemplateHolder)item;
        RelicStatisticComponent statisticComponent = this.getRelicStatisticComponent(entity, stack);
        RelicMetricComponent metricComponent = statisticComponent.getMetrics().get(metric);
        MetricTemplate metricTemplate = templateHolder.getRelicMetricTemplate(entity, stack, metric);
        if (metricComponent != null) {
            return metricComponent;
        }
        if (metricTemplate != null) {
            metricComponent = RelicMetricComponent.EMPTY;
            this.setRelicStatisticComponent(entity, stack, statisticComponent.toBuilder().metric(metric, metricComponent).build());
            return metricComponent;
        }
        return null;
    }

    default public void setRelicMetricComponent(LivingEntity entity, ItemStack stack, String metric, RelicMetricComponent component) {
        this.setRelicStatisticComponent(entity, stack, this.getRelicStatisticComponent(entity, stack).toBuilder().metric(metric, component).build());
    }

    default public double getRelicMetricValue(LivingEntity entity, ItemStack stack, String metric) {
        return this.getRelicMetricComponent(entity, stack, metric).getValue();
    }

    default public void setRelicMetricValue(LivingEntity entity, ItemStack stack, String metric, double value) {
        this.setRelicMetricComponent(entity, stack, metric, this.getRelicMetricComponent(entity, stack, metric).toBuilder().value(value).build());
    }

    default public void addRelicMetricValue(LivingEntity entity, ItemStack stack, String metric, double value) {
        this.setRelicMetricValue(entity, stack, metric, this.getRelicMetricValue(entity, stack, metric) + value);
    }

    default public AbilityStatisticComponent getAbilityStatisticComponent(LivingEntity entity, ItemStack stack, String ability) {
        return this.getAbilityComponent(entity, stack, ability).getStatistic();
    }

    default public void setAbilityStatisticComponent(LivingEntity entity, ItemStack stack, String ability, AbilityStatisticComponent component) {
        this.setAbilityComponent(entity, stack, ability, this.getAbilityComponent(entity, stack, ability).toBuilder().statistic(component).build());
    }

    default public AbilityMetricComponent getAbilityMetricComponent(LivingEntity entity, ItemStack stack, String ability, String metric) {
        Item item = stack.getItem();
        if (!(item instanceof IRelicTemplateHolder)) {
            return null;
        }
        IRelicTemplateHolder templateHolder = (IRelicTemplateHolder)item;
        AbilityStatisticComponent statisticComponent = this.getAbilityStatisticComponent(entity, stack, ability);
        AbilityMetricComponent metricComponent = statisticComponent.getMetrics().get(metric);
        MetricTemplate metricTemplate = templateHolder.getAbilityMetricTemplate(entity, stack, ability, metric);
        if (metricComponent != null) {
            return metricComponent;
        }
        if (metricTemplate != null) {
            metricComponent = AbilityMetricComponent.EMPTY;
            this.setAbilityStatisticComponent(entity, stack, ability, statisticComponent.toBuilder().metric(metric, metricComponent).build());
            return metricComponent;
        }
        return null;
    }

    default public void setAbilityMetricComponent(LivingEntity entity, ItemStack stack, String ability, String metric, AbilityMetricComponent component) {
        this.setAbilityStatisticComponent(entity, stack, ability, this.getAbilityStatisticComponent(entity, stack, ability).toBuilder().metric(metric, component).build());
    }

    default public double getAbilityMetricValue(LivingEntity entity, ItemStack stack, String ability, String metric) {
        return this.getAbilityMetricComponent(entity, stack, ability, metric).getValue();
    }

    default public void setAbilityMetricValue(LivingEntity entity, ItemStack stack, String ability, String metric, double value) {
        this.setAbilityMetricComponent(entity, stack, ability, metric, this.getAbilityMetricComponent(entity, stack, ability, metric).toBuilder().value(value).build());
    }

    default public void addAbilityMetricValue(LivingEntity entity, ItemStack stack, String ability, String metric, double value) {
        this.setAbilityMetricValue(entity, stack, ability, metric, this.getAbilityMetricValue(entity, stack, ability, metric) + value);
    }
}

