/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.api.relics;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import it.hurts.sskirillss.relics.api.relics.IRelicDataHolder;
import it.hurts.sskirillss.relics.api.relics.IRelicTemplateHolder;
import it.hurts.sskirillss.relics.api.relics.IRelicUtilities;
import it.hurts.sskirillss.relics.api.relics.RelicTemplate;
import it.hurts.sskirillss.relics.api.relics.ResearchComponent;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilitiesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatTemplate;
import it.hurts.sskirillss.relics.api.relics.events.RelicExperienceChangeEvent;
import it.hurts.sskirillss.relics.api.relics.events.RelicLevelChangeEvent;
import it.hurts.sskirillss.relics.api.relics.events.RelicLevelingPointsChangeEvent;
import it.hurts.sskirillss.relics.config.data.RelicConfigData;
import it.hurts.sskirillss.relics.init.RelicsRegistries;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicSlotModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.PredicateType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootTemplate;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface IRelicItem
extends IRelicTemplateHolder,
IRelicDataHolder,
IRelicUtilities {
    default public Item getItem() {
        IRelicItem iRelicItem = this;
        if (iRelicItem instanceof Item) {
            Item item = (Item)iRelicItem;
            return item;
        }
        throw new IllegalStateException("Relic interface is not associated with an Item class");
    }

    default public double getRelicExperience(LivingEntity entity, ItemStack stack) {
        return this.getLevelingData(entity, stack).getExperience();
    }

    default public void setRelicExperience(LivingEntity entity, ItemStack stack, double experience) {
        this.setLevelingData(entity, stack, this.getLevelingData(entity, stack).toBuilder().experience(Math.clamp(experience, 0.0, this.getTotalRelicExperienceForLevel(entity, stack, this.getRelicLevel(entity, stack) + 1))).build());
    }

    default public boolean addRelicExperience(LivingEntity entity, ItemStack stack, String ability, String experienceSource, double amount) {
        RelicExperienceChangeEvent event = (RelicExperienceChangeEvent)NeoForge.EVENT_BUS.post((Event)new RelicExperienceChangeEvent(entity, stack, ability, experienceSource, amount));
        double delta = event.getDelta();
        if (event.isCanceled() || delta == 0.0) {
            return false;
        }
        this.addRelicExperience(event.getBearer(), event.getStack(), delta);
        return true;
    }

    default public int getRelicLevel(LivingEntity entity, ItemStack stack) {
        return this.getLevelingData(entity, stack).getLevel();
    }

    default public void setRelicLevel(LivingEntity entity, ItemStack stack, int level) {
        this.setLevelingData(entity, stack, this.getLevelingData(entity, stack).toBuilder().level(Math.max(0, level)).build());
    }

    default public boolean addRelicLevel(LivingEntity entity, ItemStack stack, int level) {
        int allowedDelta;
        int currentLevel = this.getRelicLevel(entity, stack);
        int maxLevel = this.calculateRelicMaxLevel(entity, stack);
        int n = level > 0 ? Math.min(level, maxLevel - currentLevel) : (allowedDelta = level < 0 ? Math.max(level, -currentLevel) : 0);
        if (allowedDelta == 0) {
            return false;
        }
        RelicLevelChangeEvent event = new RelicLevelChangeEvent(entity, stack, allowedDelta);
        if (((RelicLevelChangeEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled() || event.getDelta() == 0) {
            return false;
        }
        int delta = event.getDelta();
        int newLevel = currentLevel + delta;
        this.setRelicLevel(entity, stack, newLevel);
        this.addRelicLevelingPoints(entity, stack, delta);
        return true;
    }

    default public int getRelicLevelingPoints(LivingEntity entity, ItemStack stack) {
        return this.getLevelingData(entity, stack).getPoints();
    }

    default public void setRelicLevelingPoints(LivingEntity entity, ItemStack stack, int amount) {
        this.setLevelingData(entity, stack, this.getLevelingData(entity, stack).toBuilder().points(Math.max(0, amount)).build());
    }

    default public boolean addRelicLevelingPoints(LivingEntity entity, ItemStack stack, int amount) {
        RelicLevelingPointsChangeEvent event = new RelicLevelingPointsChangeEvent(entity, stack, amount);
        if (((RelicLevelingPointsChangeEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            return false;
        }
        int delta = event.getDelta();
        int currentPoints = this.getRelicLevelingPoints(entity, stack);
        int maxLevel = this.calculateRelicMaxLevel(entity, stack);
        int newPoints = currentPoints + delta;
        if (newPoints < 0) {
            int deficit = -newPoints;
            List<String> abilities = this.getAbilitiesTemplate(entity, stack).getAbilities().keySet().stream().filter(ability -> this.getAbilityLevel(entity, stack, (String)ability) > 0).toList();
            Comparator<String> comparator = Comparator.comparingInt(ability -> this.getAbilityTemplate(entity, stack, (String)ability).getRequiredPoints());
            List<String> sortedAbilities = deficit == 1 ? abilities.stream().sorted(comparator).toList() : abilities.stream().sorted(comparator.reversed()).toList();
            for (String ability2 : sortedAbilities) {
                while (deficit > 0 && this.getAbilityLevel(entity, stack, ability2) > 0) {
                    int cost = this.getAbilityTemplate(entity, stack, ability2).getRequiredPoints();
                    this.addAbilityLevel(entity, stack, ability2, -1);
                    deficit -= cost;
                }
                if (deficit > 0) continue;
                break;
            }
            newPoints = deficit < 0 ? -deficit : 0;
        }
        this.setRelicLevelingPoints(entity, stack, Math.clamp((long)newPoints, 0, maxLevel));
        return true;
    }

    default public int getRelicRank(LivingEntity entity, ItemStack stack) {
        return this.getLevelingData(entity, stack).getRank();
    }

    default public void setRelicRank(LivingEntity entity, ItemStack stack, int amount) {
        this.setLevelingData(entity, stack, this.getLevelingData(entity, stack).toBuilder().rank(Math.max(0, amount)).build());
    }

    default public void addRelicRank(LivingEntity entity, ItemStack stack, int amount) {
        this.setRelicRank(entity, stack, this.getRelicRank(entity, stack) + amount);
    }

    @ApiStatus.Experimental
    default public String getAbilityMode(LivingEntity entity, ItemStack stack, String ability) {
        String mode = this.getAbilityComponent(entity, stack, ability).getMode();
        return mode.isEmpty() ? this.getAbilityTemplate(entity, stack, ability).getModes().getFirst() : mode;
    }

    @ApiStatus.Experimental
    default public void setAbilityMode(LivingEntity entity, ItemStack stack, String ability, String mode) {
        this.setAbilityComponent(entity, stack, ability, this.getAbilityComponent(entity, stack, ability).toBuilder().mode(mode).build());
    }

    @ApiStatus.Experimental
    default public boolean isAbilityRankModifierUnlocked(LivingEntity entity, ItemStack stack, String ability, String rankModifier) {
        HashMultimap modifiers = (HashMultimap)Multimaps.invertFrom(this.getAbilityTemplate(entity, stack, ability).getRankModifiers(), (Multimap)HashMultimap.create());
        return this.getRelicRank(entity, stack) >= (Integer)Collections.max(modifiers.get((Object)rankModifier));
    }

    @Override
    default public RelicTemplate getRelicTemplate(LivingEntity entity, ItemStack stack) {
        RelicTemplate base = IRelicTemplateHolder.super.getRelicTemplate(entity, stack);
        int rank = this.getRelicRank(entity, stack);
        AbilitiesTemplate abilities = base.getAbilities();
        Map<String, AbilityTemplate> updatedAbilitiesMap = abilities.getAbilities().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            AbilityTemplate template = (AbilityTemplate)entry.getValue();
            int updatedMax = IntStream.range(0, rank).reduce(template.getInitialMaxLevel(), (level, i) -> level + (int)Math.ceil((double)level * template.getMaxLevelRankModifier()));
            return template.toBuilder().initialMaxLevel(updatedMax).build();
        }));
        AbilitiesTemplate.AbilitiesTemplateBuilder abilitiesBuilder = abilities.toBuilder();
        updatedAbilitiesMap.forEach((key, template) -> abilitiesBuilder.ability(template.toBuilder().initialMaxLevel(template.getInitialMaxLevel()).build()));
        return base.toBuilder().abilities(abilitiesBuilder.build()).build();
    }

    default public int calculateRelicMaxLevel(LivingEntity entity, ItemStack stack) {
        return this.getRelicTemplate(entity, stack).getAbilities().getAbilities().values().stream().mapToInt(template -> template.getInitialMaxLevel() * template.getRequiredPoints()).sum();
    }

    @Deprecated(forRemoval=true)
    public String getConfigRoute();

    @Nullable
    default public RelicConfigData constructDefaultConfigData(@NotNull RelicConfigData config) {
        return config;
    }

    default public double getStatValue(LivingEntity entity, ItemStack stack, String ability, String stat) {
        return this.getStatValueForLevel(entity, stack, ability, stat, this.getAbilityLevel(entity, stack, ability));
    }

    default public int getStatMaxQuality(LivingEntity entity, ItemStack stack, String ability, String stat) {
        return 10;
    }

    default public int getAbilityMaxQuality(LivingEntity entity, ItemStack stack, String ability) {
        return 10;
    }

    default public int calculateAbilityQuality(LivingEntity entity, ItemStack stack, String ability) {
        Map<String, StatTemplate> stats = this.getAbilityTemplate(entity, stack, ability).getStats();
        if (stats.isEmpty()) {
            return this.getAbilityMaxQuality(entity, stack, ability);
        }
        double avg = stats.keySet().stream().mapToInt(stat -> this.getOrCalculateStatQuality(entity, stack, ability, (String)stat)).average().orElse(0.0);
        int min = 0;
        int max = this.getAbilityMaxQuality(entity, stack, ability);
        if (avg == (double)min) {
            return min;
        }
        if (avg == (double)max) {
            return max;
        }
        return (int)Mth.clamp((double)Math.floor(avg), (double)(min + 1), (double)(max - 1));
    }

    default public int getRelicMaxQuality(LivingEntity entity, ItemStack stack) {
        return 10;
    }

    default public int calculateRelicQuality(LivingEntity entity, ItemStack stack) {
        Map<String, AbilityTemplate> abilities = this.getAbilitiesTemplate(entity, stack).getAbilities();
        if (abilities.isEmpty()) {
            return 0;
        }
        int[] filtered = abilities.keySet().stream().filter(abilityTemplate -> this.canBeUpgraded(entity, stack, (String)abilityTemplate) && this.isAbilityUnlocked(entity, stack, (String)abilityTemplate)).mapToInt(abilityTemplate -> this.calculateAbilityQuality(entity, stack, (String)abilityTemplate)).toArray();
        if (filtered.length == 0) {
            return 0;
        }
        double avg = Arrays.stream(filtered).average().orElse(0.0);
        int min = 0;
        int max = this.getRelicMaxQuality(entity, stack);
        if (avg == (double)min) {
            return min;
        }
        if (avg == (double)max) {
            return max;
        }
        return (int)Mth.clamp((double)Math.floor(avg), (double)(min + 1), (double)(max - 1));
    }

    default public double calculateRelicProgress(LivingEntity entity, ItemStack stack) {
        int unspentPoints = this.getRelicLevelingPoints(entity, stack);
        LevelingTemplate template = this.getLevelingTemplate(entity, stack);
        int rank = this.getRelicRank(entity, stack);
        int maxRank = template.getMaxRank();
        int level = this.getRelicLevel(entity, stack);
        int maxLevel = this.calculateRelicMaxLevel(entity, stack);
        int quality = this.calculateRelicQuality(entity, stack);
        int maxQuality = this.getRelicMaxQuality(entity, stack);
        double adjustedUnits = Math.max(0.0, Math.min((double)level - (double)unspentPoints * 0.5, (double)maxLevel));
        double levelFraction = maxLevel > 0 ? adjustedUnits / (double)maxLevel : 0.0;
        int totalSegments = Math.max(1, maxRank + 1);
        int completedSegments = Math.max(0, Math.min(rank, maxRank));
        double baseProgress = ((double)completedSegments + levelFraction) / (double)totalSegments;
        double qualityRatio = maxQuality > 0 ? (double)quality / (double)maxQuality : 0.0;
        double maxQualityWeight = 0.2;
        double qualityContribution = qualityRatio * maxQualityWeight * (1.0 - baseProgress);
        double progress = baseProgress + qualityContribution;
        return Math.min(1.0, Math.max(0.0, progress));
    }

    default public void castActiveAbility(Player player, ItemStack stack, String ability, CastType type, CastStage stage) {
    }

    default public void tickActiveAbilitySelection(ItemStack stack, Player player, String ability) {
    }

    @Nullable
    @ApiStatus.Internal
    default public RelicAttributeModifier getRelicAttributeModifiers(LivingEntity entity, ItemStack stack) {
        return RelicAttributeModifier.builder().build();
    }

    @Nullable
    @ApiStatus.Internal
    default public RelicSlotModifier getSlotModifiers(LivingEntity entity, ItemStack stack) {
        return RelicSlotModifier.builder().build();
    }

    default public LootTemplate getLootTemplate(LivingEntity entity, ItemStack stack) {
        return this.getRelicTemplate(entity, stack).getLoot();
    }

    default public void spreadRelicExperience(@Nullable LivingEntity entity, ItemStack stack, int experience) {
        this.spreadRelicExperience(entity, stack, experience, 0.25);
    }

    default public void spreadRelicExperience(@Nullable LivingEntity entity, ItemStack stack, int experience, double percentage) {
        double toSpread;
        boolean isMaxLevel = this.isRelicMaxLevel(entity, stack);
        double d = toSpread = isMaxLevel ? 0.0 : (double)experience * percentage;
        if (!isMaxLevel) {
            this.addRelicExperience(entity, stack, experience);
        }
        if (toSpread <= 0.0 || entity == null) {
            return;
        }
        List<ItemStack> relics = RelicsRegistries.RELIC_CONTAINER_REGISTRY.entrySet().stream().map(Map.Entry::getValue).flatMap(source -> source.gatherRelics().apply(entity).stream()).filter(entry -> {
            IRelicItem relic;
            Item patt0$temp = entry.getItem();
            return patt0$temp instanceof IRelicItem && !(relic = (IRelicItem)patt0$temp).isRelicMaxLevel(entity, (ItemStack)entry) && !stack.equals(entry);
        }).toList();
        if (relics.isEmpty()) {
            return;
        }
        ItemStack relicStack = relics.get(entity.level().getRandom().nextInt(relics.size()));
        Item item = relicStack.getItem();
        if (item instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            relic.addRelicExperience(entity, relicStack, toSpread);
        }
    }

    default public CastData getAbilityCastData(LivingEntity entity, ItemStack stack, String ability) {
        return this.getAbilityTemplate(entity, stack, ability).getCastData();
    }

    default public Map<String, Pair<PredicateType, BiFunction<Player, ItemStack, Boolean>>> getAbilityPredicates(LivingEntity entity, ItemStack stack, String ability) {
        return this.getAbilityCastData(entity, stack, ability).getPredicates();
    }

    default public Map<String, BiFunction<Player, ItemStack, Boolean>> getAbilityPredicates(LivingEntity entity, ItemStack stack, String ability, PredicateType type) {
        return this.getAbilityPredicates(entity, stack, ability).entrySet().stream().filter(entry -> ((Pair)entry.getValue()).getKey() == type).collect(Collectors.toMap(Map.Entry::getKey, entry -> (BiFunction)((Pair)entry.getValue()).getValue()));
    }

    default public boolean testAbilityPredicate(Player player, ItemStack stack, String ability, String predicate) {
        return (Boolean)((BiFunction)this.getAbilityPredicates((LivingEntity)player, stack, ability).get(predicate).getValue()).apply(player, stack);
    }

    default public boolean testAbilityPredicates(Player player, ItemStack stack, String ability, PredicateType type) {
        for (Map.Entry<String, BiFunction<Player, ItemStack, Boolean>> entry : this.getAbilityPredicates((LivingEntity)player, stack, ability, type).entrySet()) {
            if (this.testAbilityPredicate(player, stack, ability, entry.getKey())) continue;
            return false;
        }
        return true;
    }

    default public void setResearchComponent(LivingEntity entity, ItemStack stack, String ability, ResearchComponent component) {
        this.setAbilityComponent(entity, stack, ability, this.getAbilityComponent(entity, stack, ability).toBuilder().research(component).build());
    }

    default public Multimap<Integer, Integer> getResearchLinks(LivingEntity entity, ItemStack stack, String ability) {
        return (Multimap)this.getResearchComponent(entity, stack, ability).getLinks().entrySet().stream().collect(() -> ((MultimapBuilder.ListMultimapBuilder)MultimapBuilder.hashKeys().arrayListValues()).build(), (multimap, entry) -> multimap.putAll((Object)Integer.parseInt((String)entry.getKey()), (Iterable)entry.getValue()), Multimap::putAll);
    }

    default public void setResearchLinks(LivingEntity entity, ItemStack stack, String ability, Map<String, List<Integer>> links) {
        this.setResearchComponent(entity, stack, ability, this.getResearchComponent(entity, stack, ability).toBuilder().links(links).build());
    }

    default public void addResearchLink(LivingEntity entity, ItemStack stack, String ability, int from, int to) {
        Multimap<Integer, Integer> links = this.getResearchLinks(entity, stack, ability);
        links.put((Object)from, (Object)to);
        this.setResearchLinks(entity, stack, ability, links.asMap().entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), entry -> new ArrayList((Collection)entry.getValue()))));
    }

    default public void removeResearchLink(LivingEntity entity, ItemStack stack, String ability, int from, int to) {
        Multimap<Integer, Integer> links = this.getResearchLinks(entity, stack, ability);
        links.remove((Object)from, (Object)to);
        this.setResearchComponent(entity, stack, ability, this.getResearchComponent(entity, stack, ability).toBuilder().links(links.asMap().entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), entry -> new ArrayList((Collection)entry.getValue())))).build());
    }

    default public boolean isAbilityResearched(LivingEntity entity, ItemStack stack, String ability) {
        return this.getResearchTemplate(entity, stack, ability).getStars().isEmpty() || this.getResearchComponent(entity, stack, ability).isResearched();
    }

    default public void setAbilityResearched(LivingEntity entity, ItemStack stack, String ability, boolean researched) {
        this.setResearchComponent(entity, stack, ability, this.getResearchComponent(entity, stack, ability).toBuilder().researched(researched).build());
    }

    default public Multimap<Integer, Integer> getCorrectResearchLinks(LivingEntity entity, ItemStack stack, String ability) {
        Multimap<Integer, Integer> schema = this.getResearchTemplate(entity, stack, ability).getLinks();
        Multimap<Integer, Integer> links = this.getResearchLinks(entity, stack, ability);
        if (schema.isEmpty()) {
            return LinkedHashMultimap.create();
        }
        Set bidirectionalSchema = schema.entries().stream().flatMap(entry -> Stream.of(Pair.of((Object)((Integer)entry.getKey()), (Object)((Integer)entry.getValue())), Pair.of((Object)((Integer)entry.getValue()), (Object)((Integer)entry.getKey())))).collect(Collectors.toSet());
        return (Multimap)links.entries().stream().filter(entry -> bidirectionalSchema.contains(Pair.of((Object)((Integer)entry.getKey()), (Object)((Integer)entry.getValue()))) || bidirectionalSchema.contains(Pair.of((Object)((Integer)entry.getValue()), (Object)((Integer)entry.getKey())))).collect(LinkedHashMultimap::create, (map, entry) -> map.put((Object)((Integer)entry.getKey()), (Object)((Integer)entry.getValue())), Multimap::putAll);
    }

    default public Multimap<Integer, Integer> getIncorrectResearchLinks(LivingEntity entity, ItemStack stack, String ability) {
        Multimap<Integer, Integer> schema = this.getResearchTemplate(entity, stack, ability).getLinks();
        Multimap<Integer, Integer> links = this.getResearchLinks(entity, stack, ability);
        if (schema.isEmpty()) {
            return LinkedHashMultimap.create();
        }
        Set bidirectionalSchema = schema.entries().stream().flatMap(entry -> Stream.of(Pair.of((Object)((Integer)entry.getKey()), (Object)((Integer)entry.getValue())), Pair.of((Object)((Integer)entry.getValue()), (Object)((Integer)entry.getKey())))).collect(Collectors.toSet());
        return (Multimap)links.entries().stream().filter(entry -> !bidirectionalSchema.contains(Pair.of((Object)((Integer)entry.getKey()), (Object)((Integer)entry.getValue()))) && !bidirectionalSchema.contains(Pair.of((Object)((Integer)entry.getValue()), (Object)((Integer)entry.getKey())))).collect(LinkedHashMultimap::create, (map, entry) -> map.put((Object)((Integer)entry.getKey()), (Object)((Integer)entry.getValue())), Multimap::putAll);
    }

    default public double testAbilityResearchPercentage(LivingEntity entity, ItemStack stack, String ability) {
        Multimap<Integer, Integer> schema = this.getResearchTemplate(entity, stack, ability).getLinks();
        Multimap<Integer, Integer> links = this.getResearchLinks(entity, stack, ability);
        if (schema.isEmpty()) {
            return 0.0;
        }
        Set bidirectionalSchema = schema.entries().stream().flatMap(entry -> Stream.of(Pair.of((Object)((Integer)entry.getKey()), (Object)((Integer)entry.getValue())), Pair.of((Object)((Integer)entry.getValue()), (Object)((Integer)entry.getKey())))).collect(Collectors.toSet());
        long matchingLinks = links.entries().stream().filter(entry -> bidirectionalSchema.contains(Pair.of((Object)((Integer)entry.getKey()), (Object)((Integer)entry.getValue()))) || bidirectionalSchema.contains(Pair.of((Object)((Integer)entry.getValue()), (Object)((Integer)entry.getKey())))).count();
        return (double)matchingLinks / (double)schema.size();
    }

    default public boolean testAbilityResearch(LivingEntity entity, ItemStack stack, String ability) {
        return this.testAbilityResearchPercentage(entity, stack, ability) >= 1.0;
    }

    default public int getResearchHintPlayerExperienceCost(LivingEntity entity, ItemStack stack, String ability) {
        return 50;
    }

    default public int getAbilityLevel(LivingEntity entity, ItemStack stack, String ability) {
        return this.getAbilityComponent(entity, stack, ability).getPoints();
    }

    default public void setAbilityLevel(LivingEntity entity, ItemStack stack, String ability, int points) {
        this.setAbilityComponent(entity, stack, ability, this.getAbilityComponent(entity, stack, ability).toBuilder().points(points).build());
    }

    default public void addAbilityLevel(LivingEntity entity, ItemStack stack, String ability, int points) {
        this.setAbilityLevel(entity, stack, ability, this.getAbilityLevel(entity, stack, ability) + points);
    }

    default public void randomizeAbilityStats(LivingEntity entity, ItemStack stack, String ability) {
        double targetQuality;
        Map<String, StatTemplate> stats = this.getAbilityTemplate(entity, stack, ability).getStats();
        RandomSource random = entity.getRandom();
        while ((targetQuality = (double)random.nextInt(this.getAbilityMaxQuality(entity, stack, ability) + 1)) == (double)this.calculateAbilityQuality(entity, stack, ability)) {
        }
        double sumQuality = 0.0;
        HashMap<String, Double> generatedQualities = new HashMap<String, Double>();
        for (String stat : stats.keySet()) {
            double randomQuality = MathUtils.randomBetween(random, 0.0, (double)this.getStatMaxQuality(entity, stack, ability, stat));
            generatedQualities.put(stat, randomQuality);
            sumQuality += randomQuality;
        }
        double currentAverageQuality = sumQuality / (double)stats.size();
        while (Math.abs(currentAverageQuality - targetQuality) > 0.01) {
            if (currentAverageQuality < targetQuality) {
                String minStat = (String)generatedQualities.entrySet().stream().min(Map.Entry.comparingByValue()).get().getKey();
                double increment = Math.min((targetQuality - currentAverageQuality) * (double)stats.size(), (double)this.getStatMaxQuality(entity, stack, ability, minStat) - (Double)generatedQualities.get(minStat));
                generatedQualities.put(minStat, (Double)generatedQualities.get(minStat) + increment);
            } else if (currentAverageQuality > targetQuality) {
                String maxStat = (String)generatedQualities.entrySet().stream().max(Map.Entry.comparingByValue()).get().getKey();
                double decrement = Math.min((currentAverageQuality - targetQuality) * (double)stats.size(), (Double)generatedQualities.get(maxStat));
                generatedQualities.put(maxStat, (Double)generatedQualities.get(maxStat) - decrement);
            }
            sumQuality = generatedQualities.values().stream().mapToDouble(Double::doubleValue).sum();
            currentAverageQuality = sumQuality / (double)stats.size();
        }
        for (Map.Entry entry : generatedQualities.entrySet()) {
            String stat = (String)entry.getKey();
            if (this.getStatOverrideValue(entity, stack, ability, stat).isPresent()) {
                this.setStatOverrideValue(entity, stack, ability, stat, null);
            }
            this.setStatInitialQuality(entity, stack, ability, stat, (int)Math.round((Double)entry.getValue()));
        }
    }

    default public void randomizeStat(LivingEntity entity, ItemStack stack, String ability, String stat) {
        this.setStatInitialQuality(entity, stack, ability, stat, entity.getRandom().nextInt(this.getStatMaxQuality(entity, stack, ability, stat) + 1));
    }

    default public boolean isEnoughLevel(LivingEntity entity, ItemStack stack, String ability) {
        return this.getRelicLevel(entity, stack) >= this.getAbilityTemplate(entity, stack, ability).getRequiredLevel();
    }

    default public boolean isAbilityEnabled(LivingEntity entity, ItemStack stack, String ability) {
        return true;
    }

    default public boolean isAbilityUnlocked(LivingEntity entity, ItemStack stack, String ability) {
        return this.isAbilityEnabled(entity, stack, ability) && this.isEnoughLevel(entity, stack, ability) && this.isLockUnlocked(entity, stack, ability) && this.isAbilityResearched(entity, stack, ability);
    }

    default public boolean hasUnlockedUpgradeableAbility(LivingEntity entity, ItemStack stack) {
        return this.getAbilitiesTemplate(entity, stack).getAbilities().keySet().stream().anyMatch(ability -> this.canBeUpgraded(entity, stack, (String)ability) && this.isAbilityUnlocked(entity, stack, (String)ability));
    }

    default public boolean hasUnlockedAbility(LivingEntity entity, ItemStack stack) {
        return this.getAbilitiesTemplate(entity, stack).getAbilities().keySet().stream().anyMatch(ability -> this.isAbilityUnlocked(entity, stack, (String)ability));
    }

    default public boolean canPlayerUseAbility(LivingEntity entity, ItemStack stack, String ability) {
        Player player;
        return this.isAbilityUnlocked(entity, stack, ability) && (!(entity instanceof Player) || this.testAbilityPredicates(player = (Player)entity, stack, ability, PredicateType.CAST)) && this.getAbilityCooldown(entity, stack, ability) <= 0;
    }

    default public boolean canPlayerSeeAbility(Player player, ItemStack stack, String ability) {
        return this.testAbilityPredicates(player, stack, ability, PredicateType.VISIBILITY);
    }

    default public boolean mayUnlock(LivingEntity entity, ItemStack stack, String ability) {
        return this.isEnoughLevel(entity, stack, ability) && !this.isLockUnlocked(entity, stack, ability);
    }

    default public boolean mayResearch(LivingEntity entity, ItemStack stack, String ability) {
        return this.isEnoughLevel(entity, stack, ability) && this.isLockUnlocked(entity, stack, ability) && !this.isAbilityResearched(entity, stack, ability);
    }

    default public int getUpgradePlayerExperienceCost(LivingEntity entity, ItemStack stack, String ability) {
        return (this.getAbilityLevel(entity, stack, ability) + 1) * 50;
    }

    default public boolean canBeUpgraded(LivingEntity entity, ItemStack stack, String ability) {
        return this.getAbilityTemplate(entity, stack, ability).getInitialMaxLevel() > 0 && !this.getAbilityTemplate(entity, stack, ability).getStats().isEmpty();
    }

    default public boolean mayUpgrade(LivingEntity entity, ItemStack stack, String ability) {
        AbilityTemplate entry = this.getAbilityTemplate(entity, stack, ability);
        return this.canBeUpgraded(entity, stack, ability) && !this.isAbilityMaxLevel(entity, stack, ability) && this.getRelicLevelingPoints(entity, stack) >= entry.getRequiredPoints() && this.isAbilityUnlocked(entity, stack, ability);
    }

    default public boolean mayPlayerUpgrade(Player player, ItemStack stack, String ability) {
        return this.mayUpgrade((LivingEntity)player, stack, ability) && EntityUtils.getPlayerTotalExperience(player) >= (long)this.getUpgradePlayerExperienceCost((LivingEntity)player, stack, ability);
    }

    default public boolean upgrade(Player player, ItemStack stack, String ability) {
        if (!this.mayPlayerUpgrade(player, stack, ability)) {
            return false;
        }
        player.giveExperiencePoints(-this.getUpgradePlayerExperienceCost((LivingEntity)player, stack, ability));
        this.setAbilityLevel((LivingEntity)player, stack, ability, this.getAbilityLevel((LivingEntity)player, stack, ability) + 1);
        this.addRelicLevelingPoints((LivingEntity)player, stack, -this.getAbilityTemplate((LivingEntity)player, stack, ability).getRequiredPoints());
        return true;
    }

    default public int getRerollPlayerExperienceCost(LivingEntity entity, ItemStack stack, String ability) {
        return 150;
    }

    default public boolean mayReroll(LivingEntity entity, ItemStack stack, String ability) {
        return !this.getAbilityTemplate(entity, stack, ability).getStats().isEmpty() && this.isAbilityUnlocked(entity, stack, ability);
    }

    default public boolean mayPlayerReroll(Player player, ItemStack stack, String ability) {
        return this.mayReroll((LivingEntity)player, stack, ability) && EntityUtils.getPlayerTotalExperience(player) >= (long)this.getRerollPlayerExperienceCost((LivingEntity)player, stack, ability);
    }

    default public boolean reroll(Player player, ItemStack stack, String ability) {
        if (!this.mayPlayerReroll(player, stack, ability)) {
            return false;
        }
        player.giveExperiencePoints(-this.getRerollPlayerExperienceCost((LivingEntity)player, stack, ability));
        this.randomizeAbilityStats((LivingEntity)player, stack, ability);
        return true;
    }

    default public int getResetPlayerExperienceCost(LivingEntity entity, ItemStack stack, String ability) {
        return this.getAbilityLevel(entity, stack, ability) * 250;
    }

    default public boolean mayReset(LivingEntity entity, ItemStack stack, String ability) {
        return this.getAbilityLevel(entity, stack, ability) > 0 && this.isAbilityUnlocked(entity, stack, ability);
    }

    default public boolean mayPlayerReset(Player player, ItemStack stack, String ability) {
        return !this.getAbilityTemplate((LivingEntity)player, stack, ability).getStats().isEmpty() && this.mayReset((LivingEntity)player, stack, ability) && EntityUtils.getPlayerTotalExperience(player) >= (long)this.getResetPlayerExperienceCost((LivingEntity)player, stack, ability);
    }

    @ApiStatus.Obsolete
    default public boolean mayPlayerRankup(Player player, ItemStack stack) {
        LevelingTemplate levelingTemplate = this.getLevelingTemplate((LivingEntity)player, stack);
        return this.getRelicLevel((LivingEntity)player, stack) == this.calculateRelicMaxLevel((LivingEntity)player, stack) && this.getRelicRank((LivingEntity)player, stack) < levelingTemplate.getMaxRank();
    }

    @ApiStatus.Obsolete
    default public boolean rankup(Player player, ItemStack stack) {
        if (!this.mayPlayerRankup(player, stack)) {
            return false;
        }
        this.addRelicRank((LivingEntity)player, stack, 1);
        this.setRelicLevel((LivingEntity)player, stack, 0);
        this.setRelicLevelingPoints((LivingEntity)player, stack, 0);
        for (AbilityTemplate ability : this.getAbilitiesTemplate((LivingEntity)player, stack).getAbilities().values()) {
            this.setAbilityLevel((LivingEntity)player, stack, ability.getId(), 0);
        }
        return true;
    }

    default public boolean reset(Player player, ItemStack stack, String ability) {
        if (!this.mayPlayerReset(player, stack, ability)) {
            return false;
        }
        player.giveExperiencePoints(-this.getResetPlayerExperienceCost((LivingEntity)player, stack, ability));
        this.addRelicLevelingPoints((LivingEntity)player, stack, this.getAbilityLevel((LivingEntity)player, stack, ability) * this.getAbilityTemplate((LivingEntity)player, stack, ability).getRequiredPoints());
        this.setAbilityLevel((LivingEntity)player, stack, ability, 0);
        return true;
    }

    default public int getAbilityCooldownCap(LivingEntity entity, ItemStack stack, String ability) {
        return this.getAbilityExtenderComponent(entity, stack, ability).getCooldownCap();
    }

    default public void setAbilityCooldownCap(LivingEntity entity, ItemStack stack, String ability, int amount) {
        this.setAbilityExtenderComponent(entity, stack, ability, this.getAbilityExtenderComponent(entity, stack, ability).toBuilder().cooldownCap(amount).build());
    }

    default public int getAbilityCooldown(LivingEntity entity, ItemStack stack, String ability) {
        return this.getAbilityExtenderComponent(entity, stack, ability).getCooldown();
    }

    default public void setAbilityCooldown(LivingEntity entity, ItemStack stack, String ability, int amount) {
        this.setAbilityExtenderComponent(entity, stack, ability, this.getAbilityExtenderComponent(entity, stack, ability).toBuilder().cooldownCap(amount).cooldown(amount).build());
    }

    default public void addAbilityCooldown(LivingEntity entity, ItemStack stack, String ability, int amount) {
        this.setAbilityExtenderComponent(entity, stack, ability, this.getAbilityExtenderComponent(entity, stack, ability).toBuilder().cooldown(this.getAbilityCooldown(entity, stack, ability) + amount).build());
    }

    default public void setAbilityTicking(LivingEntity entity, ItemStack stack, String ability, boolean ticking) {
        this.setAbilityExtenderComponent(entity, stack, ability, this.getAbilityExtenderComponent(entity, stack, ability).toBuilder().ticking(ticking).build());
    }

    default public boolean isAbilityTicking(LivingEntity entity, ItemStack stack, String ability) {
        return this.isAbilityUnlocked(entity, stack, ability) && this.getAbilityExtenderComponent(entity, stack, ability).isTicking();
    }

    default public boolean isAbilityOnCooldown(LivingEntity entity, ItemStack stack, String ability) {
        return this.getAbilityCooldown(entity, stack, ability) > 0;
    }

    default public boolean isAbilityUpgradeEnabled(LivingEntity entity, ItemStack stack, String ability) {
        return this.isAbilityUnlocked(entity, stack, ability) && !this.getAbilityTemplate(entity, stack, ability).getStats().isEmpty();
    }

    default public boolean isAbilityRerollEnabled(LivingEntity entity, ItemStack stack, String ability) {
        return this.isAbilityUnlocked(entity, stack, ability) && !this.getAbilityTemplate(entity, stack, ability).getStats().isEmpty();
    }

    default public boolean isAbilityResetEnabled(LivingEntity entity, ItemStack stack, String ability) {
        return this.isAbilityUnlocked(entity, stack, ability) && !this.getAbilityTemplate(entity, stack, ability).getStats().isEmpty();
    }
}

