/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.api.relics;

import it.hurts.sskirillss.relics.api.relics.AbilityStatisticTemplate;
import it.hurts.sskirillss.relics.api.relics.MetricTemplate;
import it.hurts.sskirillss.relics.api.relics.RelicStatisticTemplate;
import it.hurts.sskirillss.relics.api.relics.RelicTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilitiesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourceTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourcesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStorage;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchTemplate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

public interface IRelicTemplateHolder {
    @ApiStatus.OverrideOnly
    default public RelicTemplate constructDefaultRelicTemplate() {
        return RelicTemplate.builder().abilities(this.constructDefaultAbilitiesTemplate()).leveling(this.constructDefaultLevelingTemplate()).loot(this.constructDefaultLootTemplate()).build();
    }

    @ApiStatus.OverrideOnly
    default public AbilitiesTemplate constructDefaultAbilitiesTemplate() {
        return AbilitiesTemplate.builder().build();
    }

    @ApiStatus.OverrideOnly
    default public LevelingTemplate constructDefaultLevelingTemplate() {
        return LevelingTemplate.builder().build();
    }

    @ApiStatus.OverrideOnly
    default public LootTemplate constructDefaultLootTemplate() {
        return LootTemplate.builder().build();
    }

    default public void setRelicTemplate(RelicTemplate data) {
        RelicStorage.RELIC_TEMPLATES.put(this, data);
    }

    @ApiStatus.Internal
    default public RelicTemplate getDefaultRelicTemplate() {
        return RelicStorage.RELIC_TEMPLATES.computeIfAbsent(this, data -> this.constructDefaultRelicTemplate());
    }

    @ApiStatus.Internal
    default public AbilitiesTemplate getDefaultAbilitiesTemplate() {
        return this.getDefaultRelicTemplate().getAbilities();
    }

    @ApiStatus.Internal
    default public LootTemplate getDefaultLootTemplate() {
        return this.getDefaultRelicTemplate().getLoot();
    }

    @ApiStatus.Internal
    default public AbilityTemplate getDefaultAbilityTemplate(String ability) {
        return this.getDefaultAbilitiesTemplate().getAbilities().get(ability);
    }

    @ApiStatus.Internal
    default public ResearchTemplate getDefaultResearchTemplate(String ability) {
        return this.getDefaultAbilityTemplate(ability).getResearchTemplate();
    }

    @ApiStatus.Internal
    default public StatTemplate getDefaultStatTemplate(String ability, String stat) {
        return this.getDefaultAbilityTemplate(ability).getStats().get(stat);
    }

    @ApiStatus.Internal
    default public LevelingTemplate getDefaultLevelingTemplate() {
        return this.getDefaultRelicTemplate().getLeveling();
    }

    @ApiStatus.Internal
    default public RelicStatisticTemplate getDefaultStatisticTemplate() {
        return this.getDefaultRelicTemplate().getStatistic();
    }

    @ApiStatus.Internal
    default public MetricTemplate getDefaultMetricTemplate(String metric) {
        return this.getDefaultStatisticTemplate().getMetrics().get(metric);
    }

    default public RelicTemplate getRelicTemplate(LivingEntity entity, ItemStack stack) {
        return this.getDefaultRelicTemplate();
    }

    @ApiStatus.Obsolete
    @ApiStatus.NonExtendable
    default public AbilitiesTemplate getAbilitiesTemplate(LivingEntity entity, ItemStack stack) {
        return this.getRelicTemplate(entity, stack).getAbilities();
    }

    @ApiStatus.Obsolete
    @ApiStatus.NonExtendable
    default public AbilityTemplate getAbilityTemplate(LivingEntity entity, ItemStack stack, String ability) {
        return this.getRelicTemplate(entity, stack).getAbilities().getAbilities().get(ability);
    }

    @ApiStatus.Obsolete
    @ApiStatus.NonExtendable
    default public ResearchTemplate getResearchTemplate(LivingEntity entity, ItemStack stack, String ability) {
        return this.getRelicTemplate(entity, stack).getAbilities().getAbilities().get(ability).getResearchTemplate();
    }

    @ApiStatus.Obsolete
    @ApiStatus.NonExtendable
    default public StatTemplate getStatTemplate(LivingEntity entity, ItemStack stack, String ability, String stat) {
        return this.getRelicTemplate(entity, stack).getAbilities().getAbilities().get(ability).getStats().get(stat);
    }

    @ApiStatus.Obsolete
    @ApiStatus.NonExtendable
    default public LevelingTemplate getLevelingTemplate(LivingEntity entity, ItemStack stack) {
        return this.getRelicTemplate(entity, stack).getLeveling();
    }

    @ApiStatus.Obsolete
    @ApiStatus.NonExtendable
    default public RelicStatisticTemplate getRelicStatisticTemplate(LivingEntity entity, ItemStack stack) {
        return this.getRelicTemplate(entity, stack).getStatistic();
    }

    @ApiStatus.Obsolete
    @ApiStatus.NonExtendable
    default public MetricTemplate getRelicMetricTemplate(LivingEntity entity, ItemStack stack, String metric) {
        return this.getRelicStatisticTemplate(entity, stack).getMetrics().get(metric);
    }

    @ApiStatus.Obsolete
    @ApiStatus.NonExtendable
    default public AbilityStatisticTemplate getAbilityStatisticTemplate(LivingEntity entity, ItemStack stack, String ability) {
        return this.getAbilityTemplate(entity, stack, ability).getStatistic();
    }

    @ApiStatus.Obsolete
    @ApiStatus.NonExtendable
    default public MetricTemplate getAbilityMetricTemplate(LivingEntity entity, ItemStack stack, String ability, String metric) {
        return this.getAbilityStatisticTemplate(entity, stack, ability).getMetrics().get(metric);
    }

    @ApiStatus.Obsolete
    @ApiStatus.NonExtendable
    default public ExperienceSourcesTemplate getExperienceSourcesTemplate(LivingEntity entity, ItemStack stack, String ability) {
        return this.getAbilityTemplate(entity, stack, ability).getExperienceSources();
    }

    @ApiStatus.Obsolete
    @ApiStatus.NonExtendable
    default public ExperienceSourceTemplate getExperienceSourceTemplate(LivingEntity entity, ItemStack stack, String ability, String metric) {
        return this.getExperienceSourcesTemplate(entity, stack, ability).getSources().get(metric);
    }
}

