/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.api.relics;

import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatComponent;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatTemplate;
import it.hurts.sskirillss.relics.api.scaling_models.ScalingModel;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingTemplate;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface IRelicUtilities {
    default public double getRelicExperienceLeftForLevelUp(LivingEntity entity, ItemStack stack, int level) {
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return 0.0;
        }
        IRelicItem relic = (IRelicItem)item;
        return this.getTotalRelicExperienceBetweenLevels(entity, stack, relic.getRelicLevel(entity, stack), level) - relic.getRelicExperience(entity, stack);
    }

    default public double getTotalRelicExperienceBetweenLevels(LivingEntity entity, ItemStack stack, int from, int to) {
        return this.getTotalRelicExperienceForLevel(entity, stack, to) - this.getTotalRelicExperienceForLevel(entity, stack, from);
    }

    default public double getTotalRelicExperienceForLevel(LivingEntity entity, ItemStack stack, int level) {
        IRelicItem relic;
        block4: {
            block3: {
                Item item = stack.getItem();
                if (!(item instanceof IRelicItem)) break block3;
                relic = (IRelicItem)item;
                if (level > 0) break block4;
            }
            return 0.0;
        }
        LevelingTemplate template = relic.getLevelingTemplate(entity, stack);
        ScalingModel operation = template.getScalingModel();
        double total = 0.0;
        for (int i = 0; i < level; ++i) {
            total += operation.evaluate(entity, stack, template.getInitialCost(), template.getStep(), i);
        }
        return (int)Math.floor(total);
    }

    default public int getRelicLevelFromExperience(LivingEntity entity, ItemStack stack, int experience) {
        int result = 0;
        double amount = 0.0;
        while ((amount = this.getTotalRelicExperienceForLevel(entity, stack, ++result)) <= (double)experience) {
        }
        return result - 1;
    }

    default public int getOrCalculateStatQuality(LivingEntity entity, ItemStack stack, String ability, String stat) {
        double max;
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return 0;
        }
        IRelicItem relic = (IRelicItem)item;
        StatComponent statComponent = relic.getStatComponent(entity, stack, ability, stat);
        if (statComponent == null) {
            return 0;
        }
        Optional<Double> optional = statComponent.getOverrideValue();
        if (optional.isEmpty()) {
            return statComponent.getInitialQuality();
        }
        StatTemplate statData = relic.getStatTemplate(entity, stack, ability, stat);
        Function<Double, ? extends Number> format = statData.getFormatValue();
        double initial = format.apply(optional.get()).doubleValue();
        double min = format.apply((Double)statData.getInitialValue().getKey()).doubleValue();
        if (min == (max = format.apply((Double)statData.getInitialValue().getValue()).doubleValue())) {
            return relic.getStatMaxQuality(entity, stack, ability, stat);
        }
        if (initial == min) {
            return 0;
        }
        if (initial == max) {
            return relic.getStatMaxQuality(entity, stack, ability, stat);
        }
        return Mth.clamp((int)((int)Math.round((initial - min) / ((max - min) / (double)relic.getStatMaxQuality(entity, stack, ability, stat)))), (int)1, (int)(relic.getStatMaxQuality(entity, stack, ability, stat) - 1));
    }

    default public double getOrCalculateStatValue(LivingEntity entity, ItemStack stack, String ability, String stat) {
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return 0.0;
        }
        IRelicItem relic = (IRelicItem)item;
        return relic.getStatOverrideValue(entity, stack, ability, stat).orElse(this.getStatValueFromQuality(entity, stack, ability, stat, relic.getOrCalculateStatQuality(entity, stack, ability, stat)));
    }

    default public double getRelativeStatValue(LivingEntity entity, ItemStack stack, String ability, String stat, double value, int points) {
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return 0.0;
        }
        IRelicItem relic = (IRelicItem)item;
        StatTemplate template = relic.getStatTemplate(entity, stack, ability, stat);
        if (template == null) {
            return 0.0;
        }
        Pair<Double, Double> threshold = template.getThresholdValue();
        return MathUtils.round(Mth.clamp((double)((ScalingModel)template.getUpgradeModifier().getKey()).evaluate(entity, stack, value, (Double)template.getUpgradeModifier().getValue(), points), (double)((Double)threshold.getKey()), (double)((Double)threshold.getValue())), 5);
    }

    default public double getStatValueFromQuality(LivingEntity entity, ItemStack stack, String ability, String stat, int quality) {
        double max;
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return 0.0;
        }
        IRelicItem relic = (IRelicItem)item;
        StatTemplate template = relic.getStatTemplate(entity, stack, ability, stat);
        if (template == null) {
            return 0.0;
        }
        double min = (Double)template.getInitialValue().getKey();
        if (min == (max = ((Double)template.getInitialValue().getValue()).doubleValue())) {
            return max;
        }
        return MathUtils.round(min + (max - min) / (double)relic.getStatMaxQuality(entity, stack, ability, stat) * (double)quality, 5);
    }

    default public double getStatValueForLevel(LivingEntity entity, ItemStack stack, String ability, String stat, int level) {
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return 0.0;
        }
        IRelicItem relic = (IRelicItem)item;
        return this.getRelativeStatValue(entity, stack, ability, stat, this.getOrCalculateStatValue(entity, stack, ability, stat), level);
    }

    @Deprecated(forRemoval=true)
    default public boolean isSomethingWrongWithLevelingPoints(LivingEntity entity, ItemStack stack) {
        IRelicUtilities iRelicUtilities = this;
        if (!(iRelicUtilities instanceof IRelicItem)) {
            return false;
        }
        IRelicItem relic = (IRelicItem)iRelicUtilities;
        int current = relic.getRelicLevelingPoints(entity, stack);
        for (AbilityTemplate data : relic.getAbilitiesTemplate(entity, stack).getAbilities().values()) {
            current += relic.getAbilityComponent(entity, stack, data.getId()).getPoints() * data.getRequiredPoints();
        }
        return current != relic.getRelicLevel(entity, stack);
    }

    default public boolean isRelicMaxRank(LivingEntity entity, ItemStack stack) {
        IRelicUtilities iRelicUtilities = this;
        if (!(iRelicUtilities instanceof IRelicItem)) {
            return false;
        }
        IRelicItem relic = (IRelicItem)iRelicUtilities;
        return relic.getRelicRank(entity, stack) >= relic.getLevelingTemplate(entity, stack).getMaxRank();
    }

    default public boolean isRelicMaxLevel(LivingEntity entity, ItemStack stack) {
        IRelicUtilities iRelicUtilities = this;
        if (!(iRelicUtilities instanceof IRelicItem)) {
            return false;
        }
        IRelicItem relic = (IRelicItem)iRelicUtilities;
        return relic.getRelicLevel(entity, stack) >= relic.calculateRelicMaxLevel(entity, stack);
    }

    default public boolean isRelicMaxQuality(LivingEntity entity, ItemStack stack) {
        IRelicUtilities iRelicUtilities = this;
        if (!(iRelicUtilities instanceof IRelicItem)) {
            return false;
        }
        IRelicItem relic = (IRelicItem)iRelicUtilities;
        return relic.calculateRelicQuality(entity, stack) >= relic.getRelicMaxQuality(entity, stack);
    }

    default public boolean isRelicFlawless(LivingEntity entity, ItemStack stack) {
        IRelicUtilities iRelicUtilities = this;
        if (!(iRelicUtilities instanceof IRelicItem)) {
            return false;
        }
        IRelicItem relic = (IRelicItem)iRelicUtilities;
        return relic.calculateRelicProgress(entity, stack) >= 1.0;
    }

    default public boolean isAbilityMaxLevel(LivingEntity entity, ItemStack stack, String ability) {
        IRelicUtilities iRelicUtilities = this;
        if (!(iRelicUtilities instanceof IRelicItem)) {
            return false;
        }
        IRelicItem relic = (IRelicItem)iRelicUtilities;
        return relic.getAbilityLevel(entity, stack, ability) >= relic.getAbilityTemplate(entity, stack, ability).getInitialMaxLevel();
    }

    default public boolean isAbilityMaxQuality(LivingEntity entity, ItemStack stack, String ability) {
        IRelicUtilities iRelicUtilities = this;
        if (!(iRelicUtilities instanceof IRelicItem)) {
            return false;
        }
        IRelicItem relic = (IRelicItem)iRelicUtilities;
        return relic.calculateAbilityQuality(entity, stack, ability) >= relic.getAbilityMaxQuality(entity, stack, ability);
    }

    default public boolean addRelicExperience(LivingEntity entity, ItemStack stack, double amount) {
        int level;
        IRelicUtilities iRelicUtilities = this;
        if (!(iRelicUtilities instanceof IRelicItem)) {
            return false;
        }
        IRelicItem relic = (IRelicItem)iRelicUtilities;
        double xp = relic.getRelicExperience(entity, stack);
        int oldLevel = level = relic.getRelicLevel(entity, stack);
        int maxLevel = relic.calculateRelicMaxLevel(entity, stack);
        while (amount > 0.0 && level < maxLevel || amount < 0.0 && level > 0) {
            if (amount > 0.0) {
                double requirement = this.getTotalRelicExperienceBetweenLevels(entity, stack, level, level + 1) - xp;
                if (amount >= requirement) {
                    amount -= requirement;
                    ++level;
                    xp = 0.0;
                    continue;
                }
                xp += amount;
                amount = 0.0;
                continue;
            }
            if (xp + amount >= 0.0) {
                xp += amount;
                amount = 0.0;
                continue;
            }
            amount += xp;
            xp = this.getTotalRelicExperienceBetweenLevels(entity, stack, --level, level + 1);
        }
        if (amount < 0.0) {
            xp = 0.0;
        }
        relic.setRelicExperience(entity, stack, xp);
        if (level != oldLevel) {
            relic.addRelicLevel(entity, stack, level - oldLevel);
        }
        return true;
    }
}

