/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.api.relics;

import it.hurts.sskirillss.relics.api.relics.RelicMetricTemplate;
import it.hurts.sskirillss.relics.api.relics.RelicStatisticTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilitiesTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootTemplate;
import it.hurts.sskirillss.relics.utils.MathUtils;
import lombok.Generated;
import net.minecraft.network.chat.Component;

public class RelicTemplate {
    private final AbilitiesTemplate abilities;
    private final RelicStatisticTemplate statistic;
    private final LevelingTemplate leveling;
    private final LootTemplate loot;

    public static RelicTemplateBuilder builder() {
        return new RelicTemplateBuilder();
    }

    public RelicTemplateBuilder toBuilder() {
        return new RelicTemplateBuilder(this);
    }

    @Generated
    public AbilitiesTemplate getAbilities() {
        return this.abilities;
    }

    @Generated
    public RelicStatisticTemplate getStatistic() {
        return this.statistic;
    }

    @Generated
    public LevelingTemplate getLeveling() {
        return this.leveling;
    }

    @Generated
    public LootTemplate getLoot() {
        return this.loot;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelicTemplate)) {
            return false;
        }
        RelicTemplate other = (RelicTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AbilitiesTemplate this$abilities = this.getAbilities();
        AbilitiesTemplate other$abilities = other.getAbilities();
        if (this$abilities == null ? other$abilities != null : !((Object)this$abilities).equals(other$abilities)) {
            return false;
        }
        RelicStatisticTemplate this$statistic = this.getStatistic();
        RelicStatisticTemplate other$statistic = other.getStatistic();
        if (this$statistic == null ? other$statistic != null : !((Object)this$statistic).equals(other$statistic)) {
            return false;
        }
        LevelingTemplate this$leveling = this.getLeveling();
        LevelingTemplate other$leveling = other.getLeveling();
        if (this$leveling == null ? other$leveling != null : !((Object)this$leveling).equals(other$leveling)) {
            return false;
        }
        LootTemplate this$loot = this.getLoot();
        LootTemplate other$loot = other.getLoot();
        return !(this$loot == null ? other$loot != null : !((Object)this$loot).equals(other$loot));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RelicTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AbilitiesTemplate $abilities = this.getAbilities();
        result = result * 59 + ($abilities == null ? 43 : ((Object)$abilities).hashCode());
        RelicStatisticTemplate $statistic = this.getStatistic();
        result = result * 59 + ($statistic == null ? 43 : ((Object)$statistic).hashCode());
        LevelingTemplate $leveling = this.getLeveling();
        result = result * 59 + ($leveling == null ? 43 : ((Object)$leveling).hashCode());
        LootTemplate $loot = this.getLoot();
        result = result * 59 + ($loot == null ? 43 : ((Object)$loot).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RelicTemplate(abilities=" + String.valueOf(this.getAbilities()) + ", statistic=" + String.valueOf(this.getStatistic()) + ", leveling=" + String.valueOf(this.getLeveling()) + ", loot=" + String.valueOf(this.getLoot()) + ")";
    }

    @Generated
    private RelicTemplate(AbilitiesTemplate abilities, RelicStatisticTemplate statistic, LevelingTemplate leveling, LootTemplate loot) {
        this.abilities = abilities;
        this.statistic = statistic;
        this.leveling = leveling;
        this.loot = loot;
    }

    public static class RelicTemplateBuilder {
        private AbilitiesTemplate abilities = AbilitiesTemplate.builder().build();
        @Deprecated
        private RelicStatisticTemplate statistic = RelicStatisticTemplate.builder().metric(RelicMetricTemplate.builder("retention_time").formatValue(value -> MathUtils.formatTime(value.intValue())).component((entity, stack) -> Component.translatable((String)"relics.description.statistic.relic.retention_time")).build()).build();
        private LevelingTemplate leveling = LevelingTemplate.builder().build();
        private LootTemplate loot = LootTemplate.builder().build();

        private RelicTemplateBuilder(RelicTemplate base) {
            this.abilities = base.getAbilities();
            this.statistic = base.getStatistic();
            this.leveling = base.getLeveling();
            this.loot = base.getLoot();
        }

        public RelicTemplateBuilder abilities(AbilitiesTemplate abilities) {
            this.abilities = abilities;
            return this;
        }

        public RelicTemplateBuilder statistic(RelicStatisticTemplate statistic) {
            this.statistic = statistic;
            return this;
        }

        public RelicTemplateBuilder leveling(LevelingTemplate leveling) {
            this.leveling = leveling;
            return this;
        }

        public RelicTemplateBuilder loot(LootTemplate loot) {
            this.loot = loot;
            return this;
        }

        public RelicTemplate build() {
            return new RelicTemplate(this.abilities, this.statistic, this.leveling, this.loot);
        }

        @Generated
        public RelicTemplateBuilder() {
        }
    }
}

