/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.api.relics.abilities.stats;

import it.hurts.sskirillss.relics.api.scaling_models.ScalingModel;
import it.hurts.sskirillss.relics.config.data.StatConfigData;
import it.hurts.sskirillss.relics.init.RelicsRegistries;
import it.hurts.sskirillss.relics.init.RelicsScalingModels;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class StatTemplate {
    private final String id;
    private final Pair<ScalingModel, Double> upgradeModifier;
    private final Pair<Double, Double> initialValue;
    private final Pair<Double, Double> thresholdValue;
    private final Function<Double, ? extends Number> formatValue;

    public static StatTemplateBuilder builder(String id) {
        return new StatTemplateBuilder(id);
    }

    public StatTemplateBuilder toBuilder() {
        return new StatTemplateBuilder(this);
    }

    public StatConfigData toConfigData() {
        return new StatConfigData((Double)this.initialValue.getKey(), (Double)this.initialValue.getValue(), (Double)this.thresholdValue.getKey(), (Double)this.thresholdValue.getValue(), RelicsRegistries.SCALING_MODEL_REGISTRY.getKey((Object)((ScalingModel)this.upgradeModifier.getKey())).toString(), (Double)this.upgradeModifier.getValue());
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Pair<ScalingModel, Double> getUpgradeModifier() {
        return this.upgradeModifier;
    }

    @Generated
    public Pair<Double, Double> getInitialValue() {
        return this.initialValue;
    }

    @Generated
    public Pair<Double, Double> getThresholdValue() {
        return this.thresholdValue;
    }

    @Generated
    public Function<Double, ? extends Number> getFormatValue() {
        return this.formatValue;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatTemplate)) {
            return false;
        }
        StatTemplate other = (StatTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Pair<ScalingModel, Double> this$upgradeModifier = this.getUpgradeModifier();
        Pair<ScalingModel, Double> other$upgradeModifier = other.getUpgradeModifier();
        if (this$upgradeModifier == null ? other$upgradeModifier != null : !this$upgradeModifier.equals(other$upgradeModifier)) {
            return false;
        }
        Pair<Double, Double> this$initialValue = this.getInitialValue();
        Pair<Double, Double> other$initialValue = other.getInitialValue();
        if (this$initialValue == null ? other$initialValue != null : !this$initialValue.equals(other$initialValue)) {
            return false;
        }
        Pair<Double, Double> this$thresholdValue = this.getThresholdValue();
        Pair<Double, Double> other$thresholdValue = other.getThresholdValue();
        if (this$thresholdValue == null ? other$thresholdValue != null : !this$thresholdValue.equals(other$thresholdValue)) {
            return false;
        }
        Function<Double, ? extends Number> this$formatValue = this.getFormatValue();
        Function<Double, ? extends Number> other$formatValue = other.getFormatValue();
        return !(this$formatValue == null ? other$formatValue != null : !this$formatValue.equals(other$formatValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StatTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Pair<ScalingModel, Double> $upgradeModifier = this.getUpgradeModifier();
        result = result * 59 + ($upgradeModifier == null ? 43 : $upgradeModifier.hashCode());
        Pair<Double, Double> $initialValue = this.getInitialValue();
        result = result * 59 + ($initialValue == null ? 43 : $initialValue.hashCode());
        Pair<Double, Double> $thresholdValue = this.getThresholdValue();
        result = result * 59 + ($thresholdValue == null ? 43 : $thresholdValue.hashCode());
        Function<Double, ? extends Number> $formatValue = this.getFormatValue();
        result = result * 59 + ($formatValue == null ? 43 : $formatValue.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StatTemplate(id=" + this.getId() + ", upgradeModifier=" + String.valueOf(this.getUpgradeModifier()) + ", initialValue=" + String.valueOf(this.getInitialValue()) + ", thresholdValue=" + String.valueOf(this.getThresholdValue()) + ", formatValue=" + String.valueOf(this.getFormatValue()) + ")";
    }

    @Generated
    private StatTemplate(String id, Pair<ScalingModel, Double> upgradeModifier, Pair<Double, Double> initialValue, Pair<Double, Double> thresholdValue, Function<Double, ? extends Number> formatValue) {
        this.id = id;
        this.upgradeModifier = upgradeModifier;
        this.initialValue = initialValue;
        this.thresholdValue = thresholdValue;
        this.formatValue = formatValue;
    }

    public static class StatTemplateBuilder {
        private final String id;
        private Pair<ScalingModel, Double> upgradeModifier = Pair.of((Object)RelicsScalingModels.ADDITIVE.get(), (Object)1.0);
        private Pair<Double, Double> initialValue = Pair.of((Object)0.0, (Object)0.0);
        private Pair<Double, Double> thresholdValue = Pair.of((Object)Double.MIN_VALUE, (Object)Double.MAX_VALUE);
        private Function<Double, ? extends Number> formatValue = Double::doubleValue;

        public StatTemplateBuilder(String id) {
            this.id = id;
        }

        private StatTemplateBuilder(StatTemplate base) {
            this.id = base.getId();
            this.upgradeModifier = base.getUpgradeModifier();
            this.initialValue = base.getInitialValue();
            this.thresholdValue = base.getThresholdValue();
            this.formatValue = base.getFormatValue();
        }

        public StatTemplateBuilder upgradeModifier(ScalingModel model, double step) {
            this.upgradeModifier = Pair.of((Object)model, (Object)step);
            return this;
        }

        public StatTemplateBuilder initialValue(double min, double max) {
            this.initialValue = Pair.of((Object)min, (Object)max);
            return this;
        }

        public StatTemplateBuilder thresholdValue(double min, double max) {
            this.thresholdValue = Pair.of((Object)min, (Object)max);
            return this;
        }

        public StatTemplateBuilder formatValue(Function<Double, ? extends Number> formatValue) {
            this.formatValue = formatValue;
            return this;
        }

        public StatTemplate build() {
            return new StatTemplate(this.id, this.upgradeModifier, this.initialValue, this.thresholdValue, this.formatValue);
        }
    }
}

